/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPageResolutionsResponse extends SsmContactsResponse implements
        ToCopyableBuilder<ListPageResolutionsResponse.Builder, ListPageResolutionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPageResolutionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ResolutionContact>> PAGE_RESOLUTIONS_FIELD = SdkField
            .<List<ResolutionContact>> builder(MarshallingType.LIST)
            .memberName("PageResolutions")
            .getter(getter(ListPageResolutionsResponse::pageResolutions))
            .setter(setter(Builder::pageResolutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageResolutions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResolutionContact> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResolutionContact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PAGE_RESOLUTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ResolutionContact> pageResolutions;

    private ListPageResolutionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.pageResolutions = builder.pageResolutions;
    }

    /**
     * <p>
     * The token for the next set of items to return. Use this token to get the next set of results.
     * </p>
     * 
     * @return The token for the next set of items to return. Use this token to get the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PageResolutions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPageResolutions() {
        return pageResolutions != null && !(pageResolutions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the resolution for an engagement.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPageResolutions} method.
     * </p>
     * 
     * @return Information about the resolution for an engagement.
     */
    public final List<ResolutionContact> pageResolutions() {
        return pageResolutions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPageResolutions() ? pageResolutions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPageResolutionsResponse)) {
            return false;
        }
        ListPageResolutionsResponse other = (ListPageResolutionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasPageResolutions() == other.hasPageResolutions()
                && Objects.equals(pageResolutions(), other.pageResolutions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPageResolutionsResponse").add("NextToken", nextToken())
                .add("PageResolutions", hasPageResolutions() ? pageResolutions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PageResolutions":
            return Optional.ofNullable(clazz.cast(pageResolutions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("PageResolutions", PAGE_RESOLUTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPageResolutionsResponse, T> g) {
        return obj -> g.apply((ListPageResolutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmContactsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPageResolutionsResponse> {
        /**
         * <p>
         * The token for the next set of items to return. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the resolution for an engagement.
         * </p>
         * 
         * @param pageResolutions
         *        Information about the resolution for an engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageResolutions(Collection<ResolutionContact> pageResolutions);

        /**
         * <p>
         * Information about the resolution for an engagement.
         * </p>
         * 
         * @param pageResolutions
         *        Information about the resolution for an engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageResolutions(ResolutionContact... pageResolutions);

        /**
         * <p>
         * Information about the resolution for an engagement.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmcontacts.model.ResolutionContact.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ssmcontacts.model.ResolutionContact#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmcontacts.model.ResolutionContact.Builder#build()} is called
         * immediately and its result is passed to {@link #pageResolutions(List<ResolutionContact>)}.
         * 
         * @param pageResolutions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmcontacts.model.ResolutionContact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pageResolutions(java.util.Collection<ResolutionContact>)
         */
        Builder pageResolutions(Consumer<ResolutionContact.Builder>... pageResolutions);
    }

    static final class BuilderImpl extends SsmContactsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ResolutionContact> pageResolutions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPageResolutionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            pageResolutions(model.pageResolutions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ResolutionContact.Builder> getPageResolutions() {
            List<ResolutionContact.Builder> result = ResolutionListCopier.copyToBuilder(this.pageResolutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPageResolutions(Collection<ResolutionContact.BuilderImpl> pageResolutions) {
            this.pageResolutions = ResolutionListCopier.copyFromBuilder(pageResolutions);
        }

        @Override
        public final Builder pageResolutions(Collection<ResolutionContact> pageResolutions) {
            this.pageResolutions = ResolutionListCopier.copy(pageResolutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pageResolutions(ResolutionContact... pageResolutions) {
            pageResolutions(Arrays.asList(pageResolutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pageResolutions(Consumer<ResolutionContact.Builder>... pageResolutions) {
            pageResolutions(Stream.of(pageResolutions).map(c -> ResolutionContact.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPageResolutionsResponse build() {
            return new ListPageResolutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
