/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about contacts and times that an on-call override replaces.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PreviewOverride implements SdkPojo, Serializable, ToCopyableBuilder<PreviewOverride.Builder, PreviewOverride> {
    private static final SdkField<List<String>> NEW_MEMBERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NewMembers")
            .getter(getter(PreviewOverride::newMembers))
            .setter(setter(Builder::newMembers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewMembers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(PreviewOverride::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(PreviewOverride::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEW_MEMBERS_FIELD,
            START_TIME_FIELD, END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> newMembers;

    private final Instant startTime;

    private final Instant endTime;

    private PreviewOverride(BuilderImpl builder) {
        this.newMembers = builder.newMembers;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the NewMembers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNewMembers() {
        return newMembers != null && !(newMembers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about contacts to add to an on-call rotation override.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNewMembers} method.
     * </p>
     * 
     * @return Information about contacts to add to an on-call rotation override.
     */
    public final List<String> newMembers() {
        return newMembers;
    }

    /**
     * <p>
     * Information about the time a rotation override would begin.
     * </p>
     * 
     * @return Information about the time a rotation override would begin.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Information about the time a rotation override would end.
     * </p>
     * 
     * @return Information about the time a rotation override would end.
     */
    public final Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasNewMembers() ? newMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PreviewOverride)) {
            return false;
        }
        PreviewOverride other = (PreviewOverride) obj;
        return hasNewMembers() == other.hasNewMembers() && Objects.equals(newMembers(), other.newMembers())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PreviewOverride").add("NewMembers", hasNewMembers() ? newMembers() : null)
                .add("StartTime", startTime()).add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NewMembers":
            return Optional.ofNullable(clazz.cast(newMembers()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NewMembers", NEW_MEMBERS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PreviewOverride, T> g) {
        return obj -> g.apply((PreviewOverride) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PreviewOverride> {
        /**
         * <p>
         * Information about contacts to add to an on-call rotation override.
         * </p>
         * 
         * @param newMembers
         *        Information about contacts to add to an on-call rotation override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newMembers(Collection<String> newMembers);

        /**
         * <p>
         * Information about contacts to add to an on-call rotation override.
         * </p>
         * 
         * @param newMembers
         *        Information about contacts to add to an on-call rotation override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newMembers(String... newMembers);

        /**
         * <p>
         * Information about the time a rotation override would begin.
         * </p>
         * 
         * @param startTime
         *        Information about the time a rotation override would begin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Information about the time a rotation override would end.
         * </p>
         * 
         * @param endTime
         *        Information about the time a rotation override would end.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl implements Builder {
        private List<String> newMembers = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PreviewOverride model) {
            newMembers(model.newMembers);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final Collection<String> getNewMembers() {
            if (newMembers instanceof SdkAutoConstructList) {
                return null;
            }
            return newMembers;
        }

        public final void setNewMembers(Collection<String> newMembers) {
            this.newMembers = RotationOverridePreviewMemberListCopier.copy(newMembers);
        }

        @Override
        public final Builder newMembers(Collection<String> newMembers) {
            this.newMembers = RotationOverridePreviewMemberListCopier.copy(newMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newMembers(String... newMembers) {
            newMembers(Arrays.asList(newMembers));
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public PreviewOverride build() {
            return new PreviewOverride(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
