/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request was denied due to request throttling.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThrottlingException extends SsmContactsException implements
        ToCopyableBuilder<ThrottlingException.Builder, ThrottlingException> {
    private static final SdkField<String> QUOTA_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuotaCode").getter(getter(ThrottlingException::quotaCode)).setter(setter(Builder::quotaCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaCode").build()).build();

    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceCode").getter(getter(ThrottlingException::serviceCode)).setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()).build();

    private static final SdkField<Integer> RETRY_AFTER_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetryAfterSeconds").getter(getter(ThrottlingException::retryAfterSeconds))
            .setter(setter(Builder::retryAfterSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryAfterSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUOTA_CODE_FIELD,
            SERVICE_CODE_FIELD, RETRY_AFTER_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String quotaCode;

    private final String serviceCode;

    private final Integer retryAfterSeconds;

    private ThrottlingException(BuilderImpl builder) {
        super(builder);
        this.quotaCode = builder.quotaCode;
        this.serviceCode = builder.serviceCode;
        this.retryAfterSeconds = builder.retryAfterSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Service Quotas requirement to identify originating service
     * 
     * @return Service Quotas requirement to identify originating service
     */
    public String quotaCode() {
        return quotaCode;
    }

    /**
     * Service Quotas requirement to identify originating quota
     * 
     * @return Service Quotas requirement to identify originating quota
     */
    public String serviceCode() {
        return serviceCode;
    }

    /**
     * Advice to clients on when the call can be safely retried
     * 
     * @return Advice to clients on when the call can be safely retried
     */
    public Integer retryAfterSeconds() {
        return retryAfterSeconds;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QuotaCode", QUOTA_CODE_FIELD);
        map.put("ServiceCode", SERVICE_CODE_FIELD);
        map.put("RetryAfterSeconds", RETRY_AFTER_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ThrottlingException, T> g) {
        return obj -> g.apply((ThrottlingException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThrottlingException>, SsmContactsException.Builder {
        /**
         * Service Quotas requirement to identify originating service
         * 
         * @param quotaCode
         *        Service Quotas requirement to identify originating service
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotaCode(String quotaCode);

        /**
         * Service Quotas requirement to identify originating quota
         * 
         * @param serviceCode
         *        Service Quotas requirement to identify originating quota
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * Advice to clients on when the call can be safely retried
         * 
         * @param retryAfterSeconds
         *        Advice to clients on when the call can be safely retried
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryAfterSeconds(Integer retryAfterSeconds);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends SsmContactsException.BuilderImpl implements Builder {
        private String quotaCode;

        private String serviceCode;

        private Integer retryAfterSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ThrottlingException model) {
            super(model);
            quotaCode(model.quotaCode);
            serviceCode(model.serviceCode);
            retryAfterSeconds(model.retryAfterSeconds);
        }

        public final String getQuotaCode() {
            return quotaCode;
        }

        public final void setQuotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
        }

        @Override
        public final Builder quotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
            return this;
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final Integer getRetryAfterSeconds() {
            return retryAfterSeconds;
        }

        public final void setRetryAfterSeconds(Integer retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
        }

        @Override
        public final Builder retryAfterSeconds(Integer retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public ThrottlingException build() {
            return new ThrottlingException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
