/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmcontacts.model.Receipt;
import software.amazon.awssdk.services.ssmcontacts.model.ReceiptsListCopier;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPageReceiptsResponse
extends SsmContactsResponse
implements ToCopyableBuilder<Builder, ListPageReceiptsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPageReceiptsResponse.getter(ListPageReceiptsResponse::nextToken)).setter(ListPageReceiptsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<Receipt>> RECEIPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Receipts").getter(ListPageReceiptsResponse.getter(ListPageReceiptsResponse::receipts)).setter(ListPageReceiptsResponse.setter(Builder::receipts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Receipts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Receipt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RECEIPTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPageReceiptsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<Receipt> receipts;

    private ListPageReceiptsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.receipts = builder.receipts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasReceipts() {
        return this.receipts != null && !(this.receipts instanceof SdkAutoConstructList);
    }

    public final List<Receipt> receipts() {
        return this.receipts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReceipts() ? this.receipts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPageReceiptsResponse)) {
            return false;
        }
        ListPageReceiptsResponse other = (ListPageReceiptsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasReceipts() == other.hasReceipts() && Objects.equals(this.receipts(), other.receipts());
    }

    public final String toString() {
        return ToString.builder((String)"ListPageReceiptsResponse").add("NextToken", (Object)this.nextToken()).add("Receipts", this.hasReceipts() ? this.receipts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Receipts": {
                return Optional.ofNullable(clazz.cast(this.receipts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Receipts", RECEIPTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPageReceiptsResponse, T> g) {
        return obj -> g.apply((ListPageReceiptsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmContactsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Receipt> receipts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPageReceiptsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.receipts(model.receipts);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Receipt.Builder> getReceipts() {
            List<Receipt.Builder> result = ReceiptsListCopier.copyToBuilder(this.receipts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReceipts(Collection<Receipt.BuilderImpl> receipts) {
            this.receipts = ReceiptsListCopier.copyFromBuilder(receipts);
        }

        @Override
        public final Builder receipts(Collection<Receipt> receipts) {
            this.receipts = ReceiptsListCopier.copy(receipts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder receipts(Receipt ... receipts) {
            this.receipts(Arrays.asList(receipts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder receipts(Consumer<Receipt.Builder> ... receipts) {
            this.receipts(Stream.of(receipts).map(c -> (Receipt)((Receipt.Builder)Receipt.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPageReceiptsResponse build() {
            return new ListPageReceiptsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmContactsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPageReceiptsResponse> {
        public Builder nextToken(String var1);

        public Builder receipts(Collection<Receipt> var1);

        public Builder receipts(Receipt ... var1);

        public Builder receipts(Consumer<Receipt.Builder> ... var1);
    }
}

