/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmguiconnect;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.ssmguiconnect.model.DeleteConnectionRecordingPreferencesRequest;
import software.amazon.awssdk.services.ssmguiconnect.model.DeleteConnectionRecordingPreferencesResponse;
import software.amazon.awssdk.services.ssmguiconnect.model.GetConnectionRecordingPreferencesRequest;
import software.amazon.awssdk.services.ssmguiconnect.model.GetConnectionRecordingPreferencesResponse;
import software.amazon.awssdk.services.ssmguiconnect.model.UpdateConnectionRecordingPreferencesRequest;
import software.amazon.awssdk.services.ssmguiconnect.model.UpdateConnectionRecordingPreferencesResponse;

/**
 * Service client for accessing AWS SSM-GUIConnect asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * <fullname>AWS Systems Manager GUI Connect</fullname>
 * <p>
 * Systems Manager GUI Connect, a component of Fleet Manager, lets you connect to your Window Server-type Amazon Elastic
 * Compute Cloud (Amazon EC2) instances using the Remote Desktop Protocol (RDP). GUI Connect, which is powered by <a
 * href="https://docs.aws.amazon.com/dcv/latest/adminguide/what-is-dcv.html">Amazon DCV</a>, provides you with secure
 * connectivity to your Windows Server instances directly from the Systems Manager console. You can have up to four
 * simultaneous connections in a single browser window. In the console, GUI Connect is also referred to as Fleet Manager
 * Remote Desktop.
 * </p>
 * <p>
 * This reference is intended to be used with the <a
 * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/"> <i>Amazon Web Services Systems Manager User
 * Guide</i> </a>. To get started, see the following user guide topics:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-setting-up.html">Setting up
 * Amazon Web Services Systems Manager</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/fleet-rdp.html">Connect to a Windows Server
 * managed instance using Remote Desktop</a>
 * </p>
 * </li>
 * </ul>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SsmGuiConnectAsyncClient extends AwsClient {
    String SERVICE_NAME = "ssm-guiconnect";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "ssm-guiconnect";

    /**
     * <p>
     * Deletes the preferences for recording RDP connections.
     * </p>
     *
     * @param deleteConnectionRecordingPreferencesRequest
     * @return A Java Future containing the result of the DeleteConnectionRecordingPreferences operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException An error occurred due to a conflict.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmGuiConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmGuiConnectAsyncClient.DeleteConnectionRecordingPreferences
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-guiconnect-2021-05-01/DeleteConnectionRecordingPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectionRecordingPreferencesResponse> deleteConnectionRecordingPreferences(
            DeleteConnectionRecordingPreferencesRequest deleteConnectionRecordingPreferencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the preferences for recording RDP connections.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteConnectionRecordingPreferencesRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteConnectionRecordingPreferencesRequest#builder()}
     * </p>
     *
     * @param deleteConnectionRecordingPreferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmguiconnect.model.DeleteConnectionRecordingPreferencesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteConnectionRecordingPreferences operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException An error occurred due to a conflict.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmGuiConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmGuiConnectAsyncClient.DeleteConnectionRecordingPreferences
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-guiconnect-2021-05-01/DeleteConnectionRecordingPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectionRecordingPreferencesResponse> deleteConnectionRecordingPreferences(
            Consumer<DeleteConnectionRecordingPreferencesRequest.Builder> deleteConnectionRecordingPreferencesRequest) {
        return deleteConnectionRecordingPreferences(DeleteConnectionRecordingPreferencesRequest.builder()
                .applyMutation(deleteConnectionRecordingPreferencesRequest).build());
    }

    /**
     * <p>
     * Returns the preferences specified for recording RDP connections in the requesting Amazon Web Services account and
     * Amazon Web Services Region.
     * </p>
     *
     * @param getConnectionRecordingPreferencesRequest
     * @return A Java Future containing the result of the GetConnectionRecordingPreferences operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException An error occurred due to a conflict.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmGuiConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmGuiConnectAsyncClient.GetConnectionRecordingPreferences
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-guiconnect-2021-05-01/GetConnectionRecordingPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConnectionRecordingPreferencesResponse> getConnectionRecordingPreferences(
            GetConnectionRecordingPreferencesRequest getConnectionRecordingPreferencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the preferences specified for recording RDP connections in the requesting Amazon Web Services account and
     * Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectionRecordingPreferencesRequest.Builder}
     * avoiding the need to create one manually via {@link GetConnectionRecordingPreferencesRequest#builder()}
     * </p>
     *
     * @param getConnectionRecordingPreferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmguiconnect.model.GetConnectionRecordingPreferencesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetConnectionRecordingPreferences operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException An error occurred due to a conflict.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmGuiConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmGuiConnectAsyncClient.GetConnectionRecordingPreferences
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-guiconnect-2021-05-01/GetConnectionRecordingPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConnectionRecordingPreferencesResponse> getConnectionRecordingPreferences(
            Consumer<GetConnectionRecordingPreferencesRequest.Builder> getConnectionRecordingPreferencesRequest) {
        return getConnectionRecordingPreferences(GetConnectionRecordingPreferencesRequest.builder()
                .applyMutation(getConnectionRecordingPreferencesRequest).build());
    }

    /**
     * <p>
     * Updates the preferences for recording RDP connections.
     * </p>
     *
     * @param updateConnectionRecordingPreferencesRequest
     * @return A Java Future containing the result of the UpdateConnectionRecordingPreferences operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException An error occurred due to a conflict.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmGuiConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmGuiConnectAsyncClient.UpdateConnectionRecordingPreferences
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-guiconnect-2021-05-01/UpdateConnectionRecordingPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConnectionRecordingPreferencesResponse> updateConnectionRecordingPreferences(
            UpdateConnectionRecordingPreferencesRequest updateConnectionRecordingPreferencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the preferences for recording RDP connections.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateConnectionRecordingPreferencesRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateConnectionRecordingPreferencesRequest#builder()}
     * </p>
     *
     * @param updateConnectionRecordingPreferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmguiconnect.model.UpdateConnectionRecordingPreferencesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateConnectionRecordingPreferences operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException An error occurred due to a conflict.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmGuiConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmGuiConnectAsyncClient.UpdateConnectionRecordingPreferences
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-guiconnect-2021-05-01/UpdateConnectionRecordingPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConnectionRecordingPreferencesResponse> updateConnectionRecordingPreferences(
            Consumer<UpdateConnectionRecordingPreferencesRequest.Builder> updateConnectionRecordingPreferencesRequest) {
        return updateConnectionRecordingPreferences(UpdateConnectionRecordingPreferencesRequest.builder()
                .applyMutation(updateConnectionRecordingPreferencesRequest).build());
    }

    @Override
    default SsmGuiConnectServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link SsmGuiConnectAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SsmGuiConnectAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SsmGuiConnectAsyncClient}.
     */
    static SsmGuiConnectAsyncClientBuilder builder() {
        return new DefaultSsmGuiConnectAsyncClientBuilder();
    }
}
