/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmguiconnect;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.ssmguiconnect.model.AccessDeniedException;
import software.amazon.awssdk.services.ssmguiconnect.model.ConflictException;
import software.amazon.awssdk.services.ssmguiconnect.model.DeleteConnectionRecordingPreferencesRequest;
import software.amazon.awssdk.services.ssmguiconnect.model.DeleteConnectionRecordingPreferencesResponse;
import software.amazon.awssdk.services.ssmguiconnect.model.GetConnectionRecordingPreferencesRequest;
import software.amazon.awssdk.services.ssmguiconnect.model.GetConnectionRecordingPreferencesResponse;
import software.amazon.awssdk.services.ssmguiconnect.model.InternalServerException;
import software.amazon.awssdk.services.ssmguiconnect.model.ResourceNotFoundException;
import software.amazon.awssdk.services.ssmguiconnect.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.ssmguiconnect.model.SsmGuiConnectException;
import software.amazon.awssdk.services.ssmguiconnect.model.ThrottlingException;
import software.amazon.awssdk.services.ssmguiconnect.model.UpdateConnectionRecordingPreferencesRequest;
import software.amazon.awssdk.services.ssmguiconnect.model.UpdateConnectionRecordingPreferencesResponse;
import software.amazon.awssdk.services.ssmguiconnect.model.ValidationException;

/**
 * Service client for accessing AWS SSM-GUIConnect. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * <fullname>AWS Systems Manager GUI Connect</fullname>
 * <p>
 * Systems Manager GUI Connect, a component of Fleet Manager, lets you connect to your Window Server-type Amazon Elastic
 * Compute Cloud (Amazon EC2) instances using the Remote Desktop Protocol (RDP). GUI Connect, which is powered by <a
 * href="https://docs.aws.amazon.com/dcv/latest/adminguide/what-is-dcv.html">Amazon DCV</a>, provides you with secure
 * connectivity to your Windows Server instances directly from the Systems Manager console. You can have up to four
 * simultaneous connections in a single browser window. In the console, GUI Connect is also referred to as Fleet Manager
 * Remote Desktop.
 * </p>
 * <p>
 * This reference is intended to be used with the <a
 * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/"> <i>Amazon Web Services Systems Manager User
 * Guide</i> </a>. To get started, see the following user guide topics:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-setting-up.html">Setting up
 * Amazon Web Services Systems Manager</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/fleet-rdp.html">Connect to a Windows Server
 * managed instance using Remote Desktop</a>
 * </p>
 * </li>
 * </ul>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SsmGuiConnectClient extends AwsClient {
    String SERVICE_NAME = "ssm-guiconnect";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "ssm-guiconnect";

    /**
     * <p>
     * Deletes the preferences for recording RDP connections.
     * </p>
     *
     * @param deleteConnectionRecordingPreferencesRequest
     * @return Result of the DeleteConnectionRecordingPreferences operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Your request exceeds a service quota.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         An error occurred due to a conflict.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmGuiConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmGuiConnectClient.DeleteConnectionRecordingPreferences
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-guiconnect-2021-05-01/DeleteConnectionRecordingPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectionRecordingPreferencesResponse deleteConnectionRecordingPreferences(
            DeleteConnectionRecordingPreferencesRequest deleteConnectionRecordingPreferencesRequest)
            throws ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, ConflictException,
            ThrottlingException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            SsmGuiConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the preferences for recording RDP connections.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteConnectionRecordingPreferencesRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteConnectionRecordingPreferencesRequest#builder()}
     * </p>
     *
     * @param deleteConnectionRecordingPreferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmguiconnect.model.DeleteConnectionRecordingPreferencesRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteConnectionRecordingPreferences operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Your request exceeds a service quota.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         An error occurred due to a conflict.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmGuiConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmGuiConnectClient.DeleteConnectionRecordingPreferences
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-guiconnect-2021-05-01/DeleteConnectionRecordingPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectionRecordingPreferencesResponse deleteConnectionRecordingPreferences(
            Consumer<DeleteConnectionRecordingPreferencesRequest.Builder> deleteConnectionRecordingPreferencesRequest)
            throws ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, ConflictException,
            ThrottlingException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            SsmGuiConnectException {
        return deleteConnectionRecordingPreferences(DeleteConnectionRecordingPreferencesRequest.builder()
                .applyMutation(deleteConnectionRecordingPreferencesRequest).build());
    }

    /**
     * <p>
     * Returns the preferences specified for recording RDP connections in the requesting Amazon Web Services account and
     * Amazon Web Services Region.
     * </p>
     *
     * @param getConnectionRecordingPreferencesRequest
     * @return Result of the GetConnectionRecordingPreferences operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Your request exceeds a service quota.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         An error occurred due to a conflict.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmGuiConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmGuiConnectClient.GetConnectionRecordingPreferences
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-guiconnect-2021-05-01/GetConnectionRecordingPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectionRecordingPreferencesResponse getConnectionRecordingPreferences(
            GetConnectionRecordingPreferencesRequest getConnectionRecordingPreferencesRequest)
            throws ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, ConflictException,
            ThrottlingException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            SsmGuiConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the preferences specified for recording RDP connections in the requesting Amazon Web Services account and
     * Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectionRecordingPreferencesRequest.Builder}
     * avoiding the need to create one manually via {@link GetConnectionRecordingPreferencesRequest#builder()}
     * </p>
     *
     * @param getConnectionRecordingPreferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmguiconnect.model.GetConnectionRecordingPreferencesRequest.Builder}
     *        to create a request.
     * @return Result of the GetConnectionRecordingPreferences operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Your request exceeds a service quota.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         An error occurred due to a conflict.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmGuiConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmGuiConnectClient.GetConnectionRecordingPreferences
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-guiconnect-2021-05-01/GetConnectionRecordingPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectionRecordingPreferencesResponse getConnectionRecordingPreferences(
            Consumer<GetConnectionRecordingPreferencesRequest.Builder> getConnectionRecordingPreferencesRequest)
            throws ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, ConflictException,
            ThrottlingException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            SsmGuiConnectException {
        return getConnectionRecordingPreferences(GetConnectionRecordingPreferencesRequest.builder()
                .applyMutation(getConnectionRecordingPreferencesRequest).build());
    }

    /**
     * <p>
     * Updates the preferences for recording RDP connections.
     * </p>
     *
     * @param updateConnectionRecordingPreferencesRequest
     * @return Result of the UpdateConnectionRecordingPreferences operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Your request exceeds a service quota.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         An error occurred due to a conflict.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmGuiConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmGuiConnectClient.UpdateConnectionRecordingPreferences
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-guiconnect-2021-05-01/UpdateConnectionRecordingPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConnectionRecordingPreferencesResponse updateConnectionRecordingPreferences(
            UpdateConnectionRecordingPreferencesRequest updateConnectionRecordingPreferencesRequest)
            throws ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, ConflictException,
            ThrottlingException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            SsmGuiConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the preferences for recording RDP connections.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateConnectionRecordingPreferencesRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateConnectionRecordingPreferencesRequest#builder()}
     * </p>
     *
     * @param updateConnectionRecordingPreferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmguiconnect.model.UpdateConnectionRecordingPreferencesRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateConnectionRecordingPreferences operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Your request exceeds a service quota.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         An error occurred due to a conflict.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmGuiConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmGuiConnectClient.UpdateConnectionRecordingPreferences
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-guiconnect-2021-05-01/UpdateConnectionRecordingPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConnectionRecordingPreferencesResponse updateConnectionRecordingPreferences(
            Consumer<UpdateConnectionRecordingPreferencesRequest.Builder> updateConnectionRecordingPreferencesRequest)
            throws ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, ConflictException,
            ThrottlingException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            SsmGuiConnectException {
        return updateConnectionRecordingPreferences(UpdateConnectionRecordingPreferencesRequest.builder()
                .applyMutation(updateConnectionRecordingPreferencesRequest).build());
    }

    /**
     * Create a {@link SsmGuiConnectClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SsmGuiConnectClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SsmGuiConnectClient}.
     */
    static SsmGuiConnectClientBuilder builder() {
        return new DefaultSsmGuiConnectClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default SsmGuiConnectServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
