/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmguiconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The set of preferences used for recording RDP connections in the requesting Amazon Web Services account and Amazon
 * Web Services Region. This includes details such as which S3 bucket recordings are stored in.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionRecordingPreferences implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionRecordingPreferences.Builder, ConnectionRecordingPreferences> {
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KMSKeyArn").getter(getter(ConnectionRecordingPreferences::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyArn").build()).build();

    private static final SdkField<RecordingDestinations> RECORDING_DESTINATIONS_FIELD = SdkField
            .<RecordingDestinations> builder(MarshallingType.SDK_POJO).memberName("RecordingDestinations")
            .getter(getter(ConnectionRecordingPreferences::recordingDestinations)).setter(setter(Builder::recordingDestinations))
            .constructor(RecordingDestinations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordingDestinations").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ARN_FIELD,
            RECORDING_DESTINATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String kmsKeyArn;

    private final RecordingDestinations recordingDestinations;

    private ConnectionRecordingPreferences(BuilderImpl builder) {
        this.kmsKeyArn = builder.kmsKeyArn;
        this.recordingDestinations = builder.recordingDestinations;
    }

    /**
     * <p>
     * The ARN of a KMS key that is used to encrypt data while it is being processed by the service. This key must exist
     * in the same Amazon Web Services Region as the node you start an RDP connection to.
     * </p>
     * 
     * @return The ARN of a KMS key that is used to encrypt data while it is being processed by the service. This key
     *         must exist in the same Amazon Web Services Region as the node you start an RDP connection to.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * Determines where recordings of RDP connections are stored.
     * </p>
     * 
     * @return Determines where recordings of RDP connections are stored.
     */
    public final RecordingDestinations recordingDestinations() {
        return recordingDestinations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(recordingDestinations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionRecordingPreferences)) {
            return false;
        }
        ConnectionRecordingPreferences other = (ConnectionRecordingPreferences) obj;
        return Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(recordingDestinations(), other.recordingDestinations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionRecordingPreferences").add("KMSKeyArn", kmsKeyArn())
                .add("RecordingDestinations", recordingDestinations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KMSKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "RecordingDestinations":
            return Optional.ofNullable(clazz.cast(recordingDestinations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KMSKeyArn", KMS_KEY_ARN_FIELD);
        map.put("RecordingDestinations", RECORDING_DESTINATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionRecordingPreferences, T> g) {
        return obj -> g.apply((ConnectionRecordingPreferences) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionRecordingPreferences> {
        /**
         * <p>
         * The ARN of a KMS key that is used to encrypt data while it is being processed by the service. This key must
         * exist in the same Amazon Web Services Region as the node you start an RDP connection to.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN of a KMS key that is used to encrypt data while it is being processed by the service. This key
         *        must exist in the same Amazon Web Services Region as the node you start an RDP connection to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * Determines where recordings of RDP connections are stored.
         * </p>
         * 
         * @param recordingDestinations
         *        Determines where recordings of RDP connections are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordingDestinations(RecordingDestinations recordingDestinations);

        /**
         * <p>
         * Determines where recordings of RDP connections are stored.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecordingDestinations.Builder} avoiding
         * the need to create one manually via {@link RecordingDestinations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecordingDestinations.Builder#build()} is called immediately and
         * its result is passed to {@link #recordingDestinations(RecordingDestinations)}.
         * 
         * @param recordingDestinations
         *        a consumer that will call methods on {@link RecordingDestinations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recordingDestinations(RecordingDestinations)
         */
        default Builder recordingDestinations(Consumer<RecordingDestinations.Builder> recordingDestinations) {
            return recordingDestinations(RecordingDestinations.builder().applyMutation(recordingDestinations).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String kmsKeyArn;

        private RecordingDestinations recordingDestinations;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionRecordingPreferences model) {
            kmsKeyArn(model.kmsKeyArn);
            recordingDestinations(model.recordingDestinations);
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final RecordingDestinations.Builder getRecordingDestinations() {
            return recordingDestinations != null ? recordingDestinations.toBuilder() : null;
        }

        public final void setRecordingDestinations(RecordingDestinations.BuilderImpl recordingDestinations) {
            this.recordingDestinations = recordingDestinations != null ? recordingDestinations.build() : null;
        }

        @Override
        public final Builder recordingDestinations(RecordingDestinations recordingDestinations) {
            this.recordingDestinations = recordingDestinations;
            return this;
        }

        @Override
        public ConnectionRecordingPreferences build() {
            return new ConnectionRecordingPreferences(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
