/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmguiconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determines where recordings of RDP connections are stored.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecordingDestinations implements SdkPojo, Serializable,
        ToCopyableBuilder<RecordingDestinations.Builder, RecordingDestinations> {
    private static final SdkField<List<S3Bucket>> S3_BUCKETS_FIELD = SdkField
            .<List<S3Bucket>> builder(MarshallingType.LIST)
            .memberName("S3Buckets")
            .getter(getter(RecordingDestinations::s3Buckets))
            .setter(setter(Builder::s3Buckets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Buckets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3Bucket> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3Bucket::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<S3Bucket> s3Buckets;

    private RecordingDestinations(BuilderImpl builder) {
        this.s3Buckets = builder.s3Buckets;
    }

    /**
     * For responses, this returns true if the service returned a value for the S3Buckets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasS3Buckets() {
        return s3Buckets != null && !(s3Buckets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The S3 bucket where RDP connection recordings are stored.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasS3Buckets} method.
     * </p>
     * 
     * @return The S3 bucket where RDP connection recordings are stored.
     */
    public final List<S3Bucket> s3Buckets() {
        return s3Buckets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasS3Buckets() ? s3Buckets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordingDestinations)) {
            return false;
        }
        RecordingDestinations other = (RecordingDestinations) obj;
        return hasS3Buckets() == other.hasS3Buckets() && Objects.equals(s3Buckets(), other.s3Buckets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecordingDestinations").add("S3Buckets", hasS3Buckets() ? s3Buckets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Buckets":
            return Optional.ofNullable(clazz.cast(s3Buckets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3Buckets", S3_BUCKETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecordingDestinations, T> g) {
        return obj -> g.apply((RecordingDestinations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecordingDestinations> {
        /**
         * <p>
         * The S3 bucket where RDP connection recordings are stored.
         * </p>
         * 
         * @param s3Buckets
         *        The S3 bucket where RDP connection recordings are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Buckets(Collection<S3Bucket> s3Buckets);

        /**
         * <p>
         * The S3 bucket where RDP connection recordings are stored.
         * </p>
         * 
         * @param s3Buckets
         *        The S3 bucket where RDP connection recordings are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Buckets(S3Bucket... s3Buckets);

        /**
         * <p>
         * The S3 bucket where RDP connection recordings are stored.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmguiconnect.model.S3Bucket.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ssmguiconnect.model.S3Bucket#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmguiconnect.model.S3Bucket.Builder#build()} is called immediately
         * and its result is passed to {@link #s3Buckets(List<S3Bucket>)}.
         * 
         * @param s3Buckets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmguiconnect.model.S3Bucket.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Buckets(java.util.Collection<S3Bucket>)
         */
        Builder s3Buckets(Consumer<S3Bucket.Builder>... s3Buckets);
    }

    static final class BuilderImpl implements Builder {
        private List<S3Bucket> s3Buckets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecordingDestinations model) {
            s3Buckets(model.s3Buckets);
        }

        public final List<S3Bucket.Builder> getS3Buckets() {
            List<S3Bucket.Builder> result = S3BucketsCopier.copyToBuilder(this.s3Buckets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setS3Buckets(Collection<S3Bucket.BuilderImpl> s3Buckets) {
            this.s3Buckets = S3BucketsCopier.copyFromBuilder(s3Buckets);
        }

        @Override
        public final Builder s3Buckets(Collection<S3Bucket> s3Buckets) {
            this.s3Buckets = S3BucketsCopier.copy(s3Buckets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Buckets(S3Bucket... s3Buckets) {
            s3Buckets(Arrays.asList(s3Buckets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Buckets(Consumer<S3Bucket.Builder>... s3Buckets) {
            s3Buckets(Stream.of(s3Buckets).map(c -> S3Bucket.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RecordingDestinations build() {
            return new RecordingDestinations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
