/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmguiconnect.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class S3BucketsCopier {
    static List<S3Bucket> copy(Collection<? extends S3Bucket> s3BucketsParam) {
        List<S3Bucket> list;
        if (s3BucketsParam == null || s3BucketsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<S3Bucket> modifiableList = new ArrayList<>(s3BucketsParam.size());
            s3BucketsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<S3Bucket> copyFromBuilder(Collection<? extends S3Bucket.Builder> s3BucketsParam) {
        List<S3Bucket> list;
        if (s3BucketsParam == null || s3BucketsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<S3Bucket> modifiableList = new ArrayList<>(s3BucketsParam.size());
            s3BucketsParam.forEach(entry -> {
                S3Bucket member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<S3Bucket.Builder> copyToBuilder(Collection<? extends S3Bucket> s3BucketsParam) {
        List<S3Bucket.Builder> list;
        if (s3BucketsParam == null || s3BucketsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<S3Bucket.Builder> modifiableList = new ArrayList<>(s3BucketsParam.size());
            s3BucketsParam.forEach(entry -> {
                S3Bucket.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
