/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmguiconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectionRecordingPreferencesResponse extends SsmGuiConnectResponse implements
        ToCopyableBuilder<UpdateConnectionRecordingPreferencesResponse.Builder, UpdateConnectionRecordingPreferencesResponse> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(UpdateConnectionRecordingPreferencesResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<ConnectionRecordingPreferences> CONNECTION_RECORDING_PREFERENCES_FIELD = SdkField
            .<ConnectionRecordingPreferences> builder(MarshallingType.SDK_POJO)
            .memberName("ConnectionRecordingPreferences")
            .getter(getter(UpdateConnectionRecordingPreferencesResponse::connectionRecordingPreferences))
            .setter(setter(Builder::connectionRecordingPreferences))
            .constructor(ConnectionRecordingPreferences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionRecordingPreferences")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            CONNECTION_RECORDING_PREFERENCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final ConnectionRecordingPreferences connectionRecordingPreferences;

    private UpdateConnectionRecordingPreferencesResponse(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.connectionRecordingPreferences = builder.connectionRecordingPreferences;
    }

    /**
     * <p>
     * Service-provided idempotency token.
     * </p>
     * 
     * @return Service-provided idempotency token.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The set of preferences used for recording RDP connections in the requesting Amazon Web Services account and
     * Amazon Web Services Region. This includes details such as which S3 bucket recordings are stored in.
     * </p>
     * 
     * @return The set of preferences used for recording RDP connections in the requesting Amazon Web Services account
     *         and Amazon Web Services Region. This includes details such as which S3 bucket recordings are stored in.
     */
    public final ConnectionRecordingPreferences connectionRecordingPreferences() {
        return connectionRecordingPreferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(connectionRecordingPreferences());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectionRecordingPreferencesResponse)) {
            return false;
        }
        UpdateConnectionRecordingPreferencesResponse other = (UpdateConnectionRecordingPreferencesResponse) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(connectionRecordingPreferences(), other.connectionRecordingPreferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConnectionRecordingPreferencesResponse").add("ClientToken", clientToken())
                .add("ConnectionRecordingPreferences", connectionRecordingPreferences()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ConnectionRecordingPreferences":
            return Optional.ofNullable(clazz.cast(connectionRecordingPreferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("ConnectionRecordingPreferences", CONNECTION_RECORDING_PREFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectionRecordingPreferencesResponse, T> g) {
        return obj -> g.apply((UpdateConnectionRecordingPreferencesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsmGuiConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateConnectionRecordingPreferencesResponse> {
        /**
         * <p>
         * Service-provided idempotency token.
         * </p>
         * 
         * @param clientToken
         *        Service-provided idempotency token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The set of preferences used for recording RDP connections in the requesting Amazon Web Services account and
         * Amazon Web Services Region. This includes details such as which S3 bucket recordings are stored in.
         * </p>
         * 
         * @param connectionRecordingPreferences
         *        The set of preferences used for recording RDP connections in the requesting Amazon Web Services
         *        account and Amazon Web Services Region. This includes details such as which S3 bucket recordings are
         *        stored in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionRecordingPreferences(ConnectionRecordingPreferences connectionRecordingPreferences);

        /**
         * <p>
         * The set of preferences used for recording RDP connections in the requesting Amazon Web Services account and
         * Amazon Web Services Region. This includes details such as which S3 bucket recordings are stored in.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionRecordingPreferences.Builder}
         * avoiding the need to create one manually via {@link ConnectionRecordingPreferences#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionRecordingPreferences.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #connectionRecordingPreferences(ConnectionRecordingPreferences)}.
         * 
         * @param connectionRecordingPreferences
         *        a consumer that will call methods on {@link ConnectionRecordingPreferences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionRecordingPreferences(ConnectionRecordingPreferences)
         */
        default Builder connectionRecordingPreferences(
                Consumer<ConnectionRecordingPreferences.Builder> connectionRecordingPreferences) {
            return connectionRecordingPreferences(ConnectionRecordingPreferences.builder()
                    .applyMutation(connectionRecordingPreferences).build());
        }
    }

    static final class BuilderImpl extends SsmGuiConnectResponse.BuilderImpl implements Builder {
        private String clientToken;

        private ConnectionRecordingPreferences connectionRecordingPreferences;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectionRecordingPreferencesResponse model) {
            super(model);
            clientToken(model.clientToken);
            connectionRecordingPreferences(model.connectionRecordingPreferences);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final ConnectionRecordingPreferences.Builder getConnectionRecordingPreferences() {
            return connectionRecordingPreferences != null ? connectionRecordingPreferences.toBuilder() : null;
        }

        public final void setConnectionRecordingPreferences(
                ConnectionRecordingPreferences.BuilderImpl connectionRecordingPreferences) {
            this.connectionRecordingPreferences = connectionRecordingPreferences != null ? connectionRecordingPreferences.build()
                    : null;
        }

        @Override
        public final Builder connectionRecordingPreferences(ConnectionRecordingPreferences connectionRecordingPreferences) {
            this.connectionRecordingPreferences = connectionRecordingPreferences;
            return this;
        }

        @Override
        public UpdateConnectionRecordingPreferencesResponse build() {
            return new UpdateConnectionRecordingPreferencesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
