/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmquicksetup;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.ssmquicksetup.model.AccessDeniedException;
import software.amazon.awssdk.services.ssmquicksetup.model.ConflictException;
import software.amazon.awssdk.services.ssmquicksetup.model.CreateConfigurationManagerRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.CreateConfigurationManagerResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.DeleteConfigurationManagerRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.DeleteConfigurationManagerResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.GetConfigurationManagerRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.GetConfigurationManagerResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.GetServiceSettingsRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.GetServiceSettingsResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.InternalServerException;
import software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.ListQuickSetupTypesRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.ListQuickSetupTypesResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.ResourceNotFoundException;
import software.amazon.awssdk.services.ssmquicksetup.model.SsmQuickSetupException;
import software.amazon.awssdk.services.ssmquicksetup.model.TagResourceRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.TagResourceResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.ThrottlingException;
import software.amazon.awssdk.services.ssmquicksetup.model.UntagResourceRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.UntagResourceResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.UpdateConfigurationDefinitionRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.UpdateConfigurationDefinitionResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.UpdateConfigurationManagerRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.UpdateConfigurationManagerResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.UpdateServiceSettingsRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.UpdateServiceSettingsResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.ValidationException;
import software.amazon.awssdk.services.ssmquicksetup.paginators.ListConfigurationManagersIterable;

/**
 * Service client for accessing AWS Systems Manager QuickSetup. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Quick Setup helps you quickly configure frequently used services and features with recommended best practices. Quick
 * Setup simplifies setting up services, including Systems Manager, by automating common or recommended tasks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SsmQuickSetupClient extends AwsClient {
    String SERVICE_NAME = "ssm-quicksetup";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "ssm-quicksetup";

    /**
     * <p>
     * Creates a Quick Setup configuration manager resource. This object is a collection of desired state configurations
     * for multiple configuration definitions and summaries describing the deployments of those definitions.
     * </p>
     *
     * @param createConfigurationManagerRequest
     * @return Result of the CreateConfigurationManager operation returned by the service.
     * @throws ValidationException
     *         The request is invalid. Verify the values provided for the request parameters are accurate.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.CreateConfigurationManager
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/CreateConfigurationManager"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfigurationManagerResponse createConfigurationManager(
            CreateConfigurationManagerRequest createConfigurationManagerRequest) throws ValidationException, ConflictException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            SsmQuickSetupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Quick Setup configuration manager resource. This object is a collection of desired state configurations
     * for multiple configuration definitions and summaries describing the deployments of those definitions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfigurationManagerRequest.Builder} avoiding
     * the need to create one manually via {@link CreateConfigurationManagerRequest#builder()}
     * </p>
     *
     * @param createConfigurationManagerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.CreateConfigurationManagerRequest.Builder} to
     *        create a request.
     * @return Result of the CreateConfigurationManager operation returned by the service.
     * @throws ValidationException
     *         The request is invalid. Verify the values provided for the request parameters are accurate.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.CreateConfigurationManager
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/CreateConfigurationManager"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfigurationManagerResponse createConfigurationManager(
            Consumer<CreateConfigurationManagerRequest.Builder> createConfigurationManagerRequest) throws ValidationException,
            ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, SsmQuickSetupException {
        return createConfigurationManager(CreateConfigurationManagerRequest.builder()
                .applyMutation(createConfigurationManagerRequest).build());
    }

    /**
     * <p>
     * Deletes a configuration manager.
     * </p>
     *
     * @param deleteConfigurationManagerRequest
     * @return Result of the DeleteConfigurationManager operation returned by the service.
     * @throws ValidationException
     *         The request is invalid. Verify the values provided for the request parameters are accurate.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found. Check the ID or name and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.DeleteConfigurationManager
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/DeleteConfigurationManager"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfigurationManagerResponse deleteConfigurationManager(
            DeleteConfigurationManagerRequest deleteConfigurationManagerRequest) throws ValidationException, ConflictException,
            InternalServerException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, SsmQuickSetupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a configuration manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigurationManagerRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteConfigurationManagerRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationManagerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.DeleteConfigurationManagerRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteConfigurationManager operation returned by the service.
     * @throws ValidationException
     *         The request is invalid. Verify the values provided for the request parameters are accurate.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found. Check the ID or name and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.DeleteConfigurationManager
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/DeleteConfigurationManager"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfigurationManagerResponse deleteConfigurationManager(
            Consumer<DeleteConfigurationManagerRequest.Builder> deleteConfigurationManagerRequest) throws ValidationException,
            ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SsmQuickSetupException {
        return deleteConfigurationManager(DeleteConfigurationManagerRequest.builder()
                .applyMutation(deleteConfigurationManagerRequest).build());
    }

    /**
     * <p>
     * Returns a configuration manager.
     * </p>
     *
     * @param getConfigurationManagerRequest
     * @return Result of the GetConfigurationManager operation returned by the service.
     * @throws ValidationException
     *         The request is invalid. Verify the values provided for the request parameters are accurate.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found. Check the ID or name and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.GetConfigurationManager
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/GetConfigurationManager"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfigurationManagerResponse getConfigurationManager(GetConfigurationManagerRequest getConfigurationManagerRequest)
            throws ValidationException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SsmQuickSetupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a configuration manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfigurationManagerRequest.Builder} avoiding
     * the need to create one manually via {@link GetConfigurationManagerRequest#builder()}
     * </p>
     *
     * @param getConfigurationManagerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.GetConfigurationManagerRequest.Builder} to
     *        create a request.
     * @return Result of the GetConfigurationManager operation returned by the service.
     * @throws ValidationException
     *         The request is invalid. Verify the values provided for the request parameters are accurate.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found. Check the ID or name and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.GetConfigurationManager
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/GetConfigurationManager"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfigurationManagerResponse getConfigurationManager(
            Consumer<GetConfigurationManagerRequest.Builder> getConfigurationManagerRequest) throws ValidationException,
            ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SsmQuickSetupException {
        return getConfigurationManager(GetConfigurationManagerRequest.builder().applyMutation(getConfigurationManagerRequest)
                .build());
    }

    /**
     * <p>
     * Returns settings configured for Quick Setup in the requesting Amazon Web Services account and Amazon Web Services
     * Region.
     * </p>
     *
     * @param getServiceSettingsRequest
     * @return Result of the GetServiceSettings operation returned by the service.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.GetServiceSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/GetServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceSettingsResponse getServiceSettings(GetServiceSettingsRequest getServiceSettingsRequest)
            throws ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, SsmQuickSetupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns settings configured for Quick Setup in the requesting Amazon Web Services account and Amazon Web Services
     * Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetServiceSettingsRequest#builder()}
     * </p>
     *
     * @param getServiceSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.GetServiceSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the GetServiceSettings operation returned by the service.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.GetServiceSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/GetServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceSettingsResponse getServiceSettings(Consumer<GetServiceSettingsRequest.Builder> getServiceSettingsRequest)
            throws ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, SsmQuickSetupException {
        return getServiceSettings(GetServiceSettingsRequest.builder().applyMutation(getServiceSettingsRequest).build());
    }

    /**
     * <p>
     * Returns Quick Setup configuration managers.
     * </p>
     *
     * @param listConfigurationManagersRequest
     * @return Result of the ListConfigurationManagers operation returned by the service.
     * @throws ValidationException
     *         The request is invalid. Verify the values provided for the request parameters are accurate.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.ListConfigurationManagers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/ListConfigurationManagers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationManagersResponse listConfigurationManagers(
            ListConfigurationManagersRequest listConfigurationManagersRequest) throws ValidationException, ConflictException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            SsmQuickSetupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns Quick Setup configuration managers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationManagersRequest.Builder} avoiding
     * the need to create one manually via {@link ListConfigurationManagersRequest#builder()}
     * </p>
     *
     * @param listConfigurationManagersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersRequest.Builder} to
     *        create a request.
     * @return Result of the ListConfigurationManagers operation returned by the service.
     * @throws ValidationException
     *         The request is invalid. Verify the values provided for the request parameters are accurate.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.ListConfigurationManagers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/ListConfigurationManagers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationManagersResponse listConfigurationManagers(
            Consumer<ListConfigurationManagersRequest.Builder> listConfigurationManagersRequest) throws ValidationException,
            ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, SsmQuickSetupException {
        return listConfigurationManagers(ListConfigurationManagersRequest.builder()
                .applyMutation(listConfigurationManagersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurationManagers(software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmquicksetup.paginators.ListConfigurationManagersIterable responses = client.listConfigurationManagersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmquicksetup.paginators.ListConfigurationManagersIterable responses = client
     *             .listConfigurationManagersPaginator(request);
     *     for (software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmquicksetup.paginators.ListConfigurationManagersIterable responses = client.listConfigurationManagersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationManagers(software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfigurationManagersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request is invalid. Verify the values provided for the request parameters are accurate.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.ListConfigurationManagers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/ListConfigurationManagers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationManagersIterable listConfigurationManagersPaginator(
            ListConfigurationManagersRequest listConfigurationManagersRequest) throws ValidationException, ConflictException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            SsmQuickSetupException {
        return new ListConfigurationManagersIterable(this, listConfigurationManagersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurationManagers(software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmquicksetup.paginators.ListConfigurationManagersIterable responses = client.listConfigurationManagersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmquicksetup.paginators.ListConfigurationManagersIterable responses = client
     *             .listConfigurationManagersPaginator(request);
     *     for (software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmquicksetup.paginators.ListConfigurationManagersIterable responses = client.listConfigurationManagersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationManagers(software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationManagersRequest.Builder} avoiding
     * the need to create one manually via {@link ListConfigurationManagersRequest#builder()}
     * </p>
     *
     * @param listConfigurationManagersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request is invalid. Verify the values provided for the request parameters are accurate.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.ListConfigurationManagers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/ListConfigurationManagers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationManagersIterable listConfigurationManagersPaginator(
            Consumer<ListConfigurationManagersRequest.Builder> listConfigurationManagersRequest) throws ValidationException,
            ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, SsmQuickSetupException {
        return listConfigurationManagersPaginator(ListConfigurationManagersRequest.builder()
                .applyMutation(listConfigurationManagersRequest).build());
    }

    /**
     * <p>
     * Returns the available Quick Setup types.
     * </p>
     *
     * @param listQuickSetupTypesRequest
     * @return Result of the ListQuickSetupTypes operation returned by the service.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.ListQuickSetupTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/ListQuickSetupTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQuickSetupTypesResponse listQuickSetupTypes(ListQuickSetupTypesRequest listQuickSetupTypesRequest)
            throws ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, SsmQuickSetupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the available Quick Setup types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQuickSetupTypesRequest.Builder} avoiding the
     * need to create one manually via {@link ListQuickSetupTypesRequest#builder()}
     * </p>
     *
     * @param listQuickSetupTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.ListQuickSetupTypesRequest.Builder} to create a
     *        request.
     * @return Result of the ListQuickSetupTypes operation returned by the service.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.ListQuickSetupTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/ListQuickSetupTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQuickSetupTypesResponse listQuickSetupTypes(
            Consumer<ListQuickSetupTypesRequest.Builder> listQuickSetupTypesRequest) throws ConflictException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            SsmQuickSetupException {
        return listQuickSetupTypes(ListQuickSetupTypesRequest.builder().applyMutation(listQuickSetupTypesRequest).build());
    }

    /**
     * <p>
     * Returns tags assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The request is invalid. Verify the values provided for the request parameters are accurate.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found. Check the ID or name and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SsmQuickSetupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns tags assigned to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The request is invalid. Verify the values provided for the request parameters are accurate.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found. Check the ID or name and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SsmQuickSetupException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Assigns key-value pairs of metadata to Amazon Web Services resources.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The request is invalid. Verify the values provided for the request parameters are accurate.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found. Check the ID or name and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, ConflictException,
            InternalServerException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, SsmQuickSetupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns key-value pairs of metadata to Amazon Web Services resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The request is invalid. Verify the values provided for the request parameters are accurate.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found. Check the ID or name and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SsmQuickSetupException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The request is invalid. Verify the values provided for the request parameters are accurate.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found. Check the ID or name and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SsmQuickSetupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The request is invalid. Verify the values provided for the request parameters are accurate.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found. Check the ID or name and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SsmQuickSetupException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a Quick Setup configuration definition.
     * </p>
     *
     * @param updateConfigurationDefinitionRequest
     * @return Result of the UpdateConfigurationDefinition operation returned by the service.
     * @throws ValidationException
     *         The request is invalid. Verify the values provided for the request parameters are accurate.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found. Check the ID or name and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.UpdateConfigurationDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/UpdateConfigurationDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationDefinitionResponse updateConfigurationDefinition(
            UpdateConfigurationDefinitionRequest updateConfigurationDefinitionRequest) throws ValidationException,
            ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SsmQuickSetupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Quick Setup configuration definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfigurationDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateConfigurationDefinitionRequest#builder()}
     * </p>
     *
     * @param updateConfigurationDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.UpdateConfigurationDefinitionRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateConfigurationDefinition operation returned by the service.
     * @throws ValidationException
     *         The request is invalid. Verify the values provided for the request parameters are accurate.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found. Check the ID or name and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.UpdateConfigurationDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/UpdateConfigurationDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationDefinitionResponse updateConfigurationDefinition(
            Consumer<UpdateConfigurationDefinitionRequest.Builder> updateConfigurationDefinitionRequest)
            throws ValidationException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SsmQuickSetupException {
        return updateConfigurationDefinition(UpdateConfigurationDefinitionRequest.builder()
                .applyMutation(updateConfigurationDefinitionRequest).build());
    }

    /**
     * <p>
     * Updates a Quick Setup configuration manager.
     * </p>
     *
     * @param updateConfigurationManagerRequest
     * @return Result of the UpdateConfigurationManager operation returned by the service.
     * @throws ValidationException
     *         The request is invalid. Verify the values provided for the request parameters are accurate.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found. Check the ID or name and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.UpdateConfigurationManager
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/UpdateConfigurationManager"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationManagerResponse updateConfigurationManager(
            UpdateConfigurationManagerRequest updateConfigurationManagerRequest) throws ValidationException, ConflictException,
            InternalServerException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, SsmQuickSetupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Quick Setup configuration manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfigurationManagerRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateConfigurationManagerRequest#builder()}
     * </p>
     *
     * @param updateConfigurationManagerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.UpdateConfigurationManagerRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateConfigurationManager operation returned by the service.
     * @throws ValidationException
     *         The request is invalid. Verify the values provided for the request parameters are accurate.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found. Check the ID or name and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.UpdateConfigurationManager
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/UpdateConfigurationManager"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationManagerResponse updateConfigurationManager(
            Consumer<UpdateConfigurationManagerRequest.Builder> updateConfigurationManagerRequest) throws ValidationException,
            ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SsmQuickSetupException {
        return updateConfigurationManager(UpdateConfigurationManagerRequest.builder()
                .applyMutation(updateConfigurationManagerRequest).build());
    }

    /**
     * <p>
     * Updates settings configured for Quick Setup.
     * </p>
     *
     * @param updateServiceSettingsRequest
     * @return Result of the UpdateServiceSettings operation returned by the service.
     * @throws ValidationException
     *         The request is invalid. Verify the values provided for the request parameters are accurate.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.UpdateServiceSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/UpdateServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateServiceSettingsResponse updateServiceSettings(UpdateServiceSettingsRequest updateServiceSettingsRequest)
            throws ValidationException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, SsmQuickSetupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates settings configured for Quick Setup.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateServiceSettingsRequest#builder()}
     * </p>
     *
     * @param updateServiceSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.UpdateServiceSettingsRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateServiceSettings operation returned by the service.
     * @throws ValidationException
     *         The request is invalid. Verify the values provided for the request parameters are accurate.
     * @throws ConflictException
     *         Another request is being processed. Wait a few minutes and try again.
     * @throws InternalServerException
     *         An error occurred on the server side.
     * @throws AccessDeniedException
     *         The requester has insufficient permissions to perform the operation.
     * @throws ThrottlingException
     *         The request or operation exceeds the maximum allowed request rate per Amazon Web Services account and
     *         Amazon Web Services Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmQuickSetupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmQuickSetupClient.UpdateServiceSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/UpdateServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateServiceSettingsResponse updateServiceSettings(
            Consumer<UpdateServiceSettingsRequest.Builder> updateServiceSettingsRequest) throws ValidationException,
            ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, SsmQuickSetupException {
        return updateServiceSettings(UpdateServiceSettingsRequest.builder().applyMutation(updateServiceSettingsRequest).build());
    }

    /**
     * Create a {@link SsmQuickSetupClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SsmQuickSetupClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SsmQuickSetupClient}.
     */
    static SsmQuickSetupClientBuilder builder() {
        return new DefaultSsmQuickSetupClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default SsmQuickSetupServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
