/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmquicksetup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summarized definition of a Quick Setup configuration definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationDefinitionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationDefinitionSummary.Builder, ConfigurationDefinitionSummary> {
    private static final SdkField<Map<String, String>> FIRST_CLASS_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("FirstClassParameters")
            .getter(getter(ConfigurationDefinitionSummary::firstClassParameters))
            .setter(setter(Builder::firstClassParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstClassParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ConfigurationDefinitionSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ConfigurationDefinitionSummary::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> TYPE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeVersion").getter(getter(ConfigurationDefinitionSummary::typeVersion))
            .setter(setter(Builder::typeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIRST_CLASS_PARAMETERS_FIELD,
            ID_FIELD, TYPE_FIELD, TYPE_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> firstClassParameters;

    private final String id;

    private final String type;

    private final String typeVersion;

    private ConfigurationDefinitionSummary(BuilderImpl builder) {
        this.firstClassParameters = builder.firstClassParameters;
        this.id = builder.id;
        this.type = builder.type;
        this.typeVersion = builder.typeVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the FirstClassParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFirstClassParameters() {
        return firstClassParameters != null && !(firstClassParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The common parameters and values for the configuration definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFirstClassParameters} method.
     * </p>
     * 
     * @return The common parameters and values for the configuration definition.
     */
    public final Map<String, String> firstClassParameters() {
        return firstClassParameters;
    }

    /**
     * <p>
     * The ID of the configuration definition.
     * </p>
     * 
     * @return The ID of the configuration definition.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of the Quick Setup configuration used by the configuration definition.
     * </p>
     * 
     * @return The type of the Quick Setup configuration used by the configuration definition.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The version of the Quick Setup type used by the configuration definition.
     * </p>
     * 
     * @return The version of the Quick Setup type used by the configuration definition.
     */
    public final String typeVersion() {
        return typeVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFirstClassParameters() ? firstClassParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(typeVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationDefinitionSummary)) {
            return false;
        }
        ConfigurationDefinitionSummary other = (ConfigurationDefinitionSummary) obj;
        return hasFirstClassParameters() == other.hasFirstClassParameters()
                && Objects.equals(firstClassParameters(), other.firstClassParameters()) && Objects.equals(id(), other.id())
                && Objects.equals(type(), other.type()) && Objects.equals(typeVersion(), other.typeVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationDefinitionSummary")
                .add("FirstClassParameters", hasFirstClassParameters() ? firstClassParameters() : null).add("Id", id())
                .add("Type", type()).add("TypeVersion", typeVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirstClassParameters":
            return Optional.ofNullable(clazz.cast(firstClassParameters()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "TypeVersion":
            return Optional.ofNullable(clazz.cast(typeVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationDefinitionSummary, T> g) {
        return obj -> g.apply((ConfigurationDefinitionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationDefinitionSummary> {
        /**
         * <p>
         * The common parameters and values for the configuration definition.
         * </p>
         * 
         * @param firstClassParameters
         *        The common parameters and values for the configuration definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstClassParameters(Map<String, String> firstClassParameters);

        /**
         * <p>
         * The ID of the configuration definition.
         * </p>
         * 
         * @param id
         *        The ID of the configuration definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of the Quick Setup configuration used by the configuration definition.
         * </p>
         * 
         * @param type
         *        The type of the Quick Setup configuration used by the configuration definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The version of the Quick Setup type used by the configuration definition.
         * </p>
         * 
         * @param typeVersion
         *        The version of the Quick Setup type used by the configuration definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeVersion(String typeVersion);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> firstClassParameters = DefaultSdkAutoConstructMap.getInstance();

        private String id;

        private String type;

        private String typeVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationDefinitionSummary model) {
            firstClassParameters(model.firstClassParameters);
            id(model.id);
            type(model.type);
            typeVersion(model.typeVersion);
        }

        public final Map<String, String> getFirstClassParameters() {
            if (firstClassParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return firstClassParameters;
        }

        public final void setFirstClassParameters(Map<String, String> firstClassParameters) {
            this.firstClassParameters = ConfigurationParametersMapCopier.copy(firstClassParameters);
        }

        @Override
        public final Builder firstClassParameters(Map<String, String> firstClassParameters) {
            this.firstClassParameters = ConfigurationParametersMapCopier.copy(firstClassParameters);
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getTypeVersion() {
            return typeVersion;
        }

        public final void setTypeVersion(String typeVersion) {
            this.typeVersion = typeVersion;
        }

        @Override
        public final Builder typeVersion(String typeVersion) {
            this.typeVersion = typeVersion;
            return this;
        }

        @Override
        public ConfigurationDefinitionSummary build() {
            return new ConfigurationDefinitionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
