/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmquicksetup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConfigurationManagerResponse extends SsmQuickSetupResponse implements
        ToCopyableBuilder<CreateConfigurationManagerResponse.Builder, CreateConfigurationManagerResponse> {
    private static final SdkField<String> MANAGER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagerArn").getter(getter(CreateConfigurationManagerResponse::managerArn))
            .setter(setter(Builder::managerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagerArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGER_ARN_FIELD));

    private final String managerArn;

    private CreateConfigurationManagerResponse(BuilderImpl builder) {
        super(builder);
        this.managerArn = builder.managerArn;
    }

    /**
     * <p>
     * The ARN for the newly created configuration manager.
     * </p>
     * 
     * @return The ARN for the newly created configuration manager.
     */
    public final String managerArn() {
        return managerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(managerArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationManagerResponse)) {
            return false;
        }
        CreateConfigurationManagerResponse other = (CreateConfigurationManagerResponse) obj;
        return Objects.equals(managerArn(), other.managerArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConfigurationManagerResponse").add("ManagerArn", managerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManagerArn":
            return Optional.ofNullable(clazz.cast(managerArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfigurationManagerResponse, T> g) {
        return obj -> g.apply((CreateConfigurationManagerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmQuickSetupResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateConfigurationManagerResponse> {
        /**
         * <p>
         * The ARN for the newly created configuration manager.
         * </p>
         * 
         * @param managerArn
         *        The ARN for the newly created configuration manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managerArn(String managerArn);
    }

    static final class BuilderImpl extends SsmQuickSetupResponse.BuilderImpl implements Builder {
        private String managerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationManagerResponse model) {
            super(model);
            managerArn(model.managerArn);
        }

        public final String getManagerArn() {
            return managerArn;
        }

        public final void setManagerArn(String managerArn) {
            this.managerArn = managerArn;
        }

        @Override
        public final Builder managerArn(String managerArn) {
            this.managerArn = managerArn;
            return this;
        }

        @Override
        public CreateConfigurationManagerResponse build() {
            return new CreateConfigurationManagerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
