/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmquicksetup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the preferences and options for a configuration definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationDefinitionInput implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationDefinitionInput.Builder, ConfigurationDefinitionInput> {
    private static final SdkField<String> LOCAL_DEPLOYMENT_ADMINISTRATION_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalDeploymentAdministrationRoleArn")
            .getter(getter(ConfigurationDefinitionInput::localDeploymentAdministrationRoleArn))
            .setter(setter(Builder::localDeploymentAdministrationRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LocalDeploymentAdministrationRoleArn").build()).build();

    private static final SdkField<String> LOCAL_DEPLOYMENT_EXECUTION_ROLE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalDeploymentExecutionRoleName")
            .getter(getter(ConfigurationDefinitionInput::localDeploymentExecutionRoleName))
            .setter(setter(Builder::localDeploymentExecutionRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalDeploymentExecutionRoleName")
                    .build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(ConfigurationDefinitionInput::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ConfigurationDefinitionInput::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> TYPE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeVersion").getter(getter(ConfigurationDefinitionInput::typeVersion))
            .setter(setter(Builder::typeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LOCAL_DEPLOYMENT_ADMINISTRATION_ROLE_ARN_FIELD, LOCAL_DEPLOYMENT_EXECUTION_ROLE_NAME_FIELD, PARAMETERS_FIELD,
            TYPE_FIELD, TYPE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String localDeploymentAdministrationRoleArn;

    private final String localDeploymentExecutionRoleName;

    private final Map<String, String> parameters;

    private final String type;

    private final String typeVersion;

    private ConfigurationDefinitionInput(BuilderImpl builder) {
        this.localDeploymentAdministrationRoleArn = builder.localDeploymentAdministrationRoleArn;
        this.localDeploymentExecutionRoleName = builder.localDeploymentExecutionRoleName;
        this.parameters = builder.parameters;
        this.type = builder.type;
        this.typeVersion = builder.typeVersion;
    }

    /**
     * <p>
     * The ARN of the IAM role used to administrate local configuration deployments.
     * </p>
     * 
     * @return The ARN of the IAM role used to administrate local configuration deployments.
     */
    public final String localDeploymentAdministrationRoleArn() {
        return localDeploymentAdministrationRoleArn;
    }

    /**
     * <p>
     * The name of the IAM role used to deploy local configurations.
     * </p>
     * 
     * @return The name of the IAM role used to deploy local configurations.
     */
    public final String localDeploymentExecutionRoleName() {
        return localDeploymentExecutionRoleName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The parameters for the configuration definition type. Parameters for configuration definitions vary based the
     * configuration type. The following tables outline the parameters for each configuration type.
     * </p>
     * <dl>
     * <dt>OpsCenter (Type: Amazon Web ServicesQuickSetupType-SSMOpsCenter)</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>DelegatedAccountId</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) The ID of the delegated administrator account.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetOrganizationalUnits</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration
     * to.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetRegions</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
     * configuration to.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>Resource Scheduler (Type: Amazon Web ServicesQuickSetupType-Scheduler)</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>TargetTagKey</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) The tag key assigned to the instances you want to target.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetTagValue</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) The value of the tag key assigned to the instances you want to target.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ICalendarString</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) An iCalendar formatted string containing the schedule you want Change Manager to use.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetAccounts</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) The ID of the Amazon Web Services account initiating the configuration deployment. You
     * only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be
     * provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetOrganizationalUnits</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration
     * to.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetRegions</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
     * configuration to.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>Default Host Management Configuration (Type: Amazon Web ServicesQuickSetupType-DHMC)</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>UpdateSSMAgent</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A boolean value that determines whether the SSM Agent is updated on the target instances
     * every 2 weeks. The default value is "<code>true</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetOrganizationalUnits</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration
     * to.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetRegions</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
     * configuration to.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>Resource Explorer (Type: Amazon Web ServicesQuickSetupType-ResourceExplorer)</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>SelectedAggregatorRegion</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) The Amazon Web Services Region where you want to create the aggregator index.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ReplaceExistingAggregator</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) A boolean value that determines whether to demote an existing aggregator if it is in a
     * Region that differs from the value you specify for the <code>SelectedAggregatorRegion</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetOrganizationalUnits</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration
     * to.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetRegions</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
     * configuration to.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>Change Manager (Type: Amazon Web ServicesQuickSetupType-SSMChangeMgr)</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>DelegatedAccountId</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) The ID of the delegated administrator account.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>JobFunction</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) The name for the Change Manager job function.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>PermissionType</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) Specifies whether you want to use default administrator permissions for the job function
     * role, or provide a custom IAM policy. The valid values are <code>CustomPermissions</code> and
     * <code>AdminPermissions</code>. The default value for the parameter is <code>CustomerPermissions</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>CustomPermissions</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A JSON string containing the IAM policy you want your job function to use. You must
     * provide a value for this parameter if you specify <code>CustomPermissions</code> for the
     * <code>PermissionType</code> parameter.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetOrganizationalUnits</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration
     * to.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetRegions</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
     * configuration to.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>DevOps Guru (Type: Amazon Web ServicesQuickSetupType-DevOpsGuru)</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>AnalyseAllResources</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A boolean value that determines whether DevOps Guru analyzes all CloudFormation stacks in
     * the account. The default value is "<code>false</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>EnableSnsNotifications</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A boolean value that determines whether DevOps Guru sends notifications when an insight
     * is created. The default value is "<code>true</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>EnableSsmOpsItems</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A boolean value that determines whether DevOps Guru creates an OpsCenter OpsItem when an
     * insight is created. The default value is "<code>true</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>EnableDriftRemediation</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A boolean value that determines whether a drift remediation schedule is used. The default
     * value is "<code>false</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>RemediationSchedule</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are
     * <code>rate(30 days)</code>, <code>rate(14 days)</code>, <code>rate(1 days)</code>, and <code>none</code>. The
     * default value is "<code>none</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetAccounts</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) The ID of the Amazon Web Services account initiating the configuration deployment. You
     * only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be
     * provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetOrganizationalUnits</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration
     * to.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetRegions</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
     * configuration to.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>Conformance Packs (Type: Amazon Web ServicesQuickSetupType-CFGCPacks)</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>DelegatedAccountId</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) The ID of the delegated administrator account. This parameter is required for
     * Organization deployments.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>RemediationSchedule</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are
     * <code>rate(30 days)</code>, <code>rate(14 days)</code>, <code>rate(2 days)</code>, and <code>none</code>. The
     * default value is "<code>none</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>CPackNames</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) A comma separated list of Config conformance packs.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetAccounts</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) The ID of the Amazon Web Services account initiating the configuration deployment. You
     * only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be
     * provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetOrganizationalUnits</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) The ID of the root of your Organization. This configuration type doesn't currently
     * support choosing specific OUs. The configuration will be deployed to all the OUs in the Organization.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetRegions</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
     * configuration to.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>Config Recording (Type: Amazon Web ServicesQuickSetupType-CFGRecording)</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>RecordAllResources</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A boolean value that determines whether all supported resources are recorded. The default
     * value is "<code>true</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ResourceTypesToRecord</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A comma separated list of resource types you want to record.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>RecordGlobalResourceTypes</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A boolean value that determines whether global resources are recorded with all resource
     * configurations. The default value is "<code>false</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>GlobalResourceTypesRegion</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) Determines the Amazon Web Services Region where global resources are recorded.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>UseCustomBucket</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A boolean value that determines whether a custom Amazon S3 bucket is used for delivery.
     * The default value is "<code>false</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>DeliveryBucketName</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) The name of the Amazon S3 bucket you want Config to deliver configuration snapshots and
     * configuration history files to.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>DeliveryBucketPrefix</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) The key prefix you want to use in the custom Amazon S3 bucket.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>NotificationOptions</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) Determines the notification configuration for the recorder. The valid values are
     * <code>NoStreaming</code>, <code>UseExistingTopic</code>, and <code>CreateTopic</code>. The default value is
     * <code>NoStreaming</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>CustomDeliveryTopicAccountId</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) The ID of the Amazon Web Services account where the Amazon SNS topic you want to use for
     * notifications resides. You must specify a value for this parameter if you use the <code>UseExistingTopic</code>
     * notification option.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>CustomDeliveryTopicName</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) The name of the Amazon SNS topic you want to use for notifications. You must specify a
     * value for this parameter if you use the <code>UseExistingTopic</code> notification option.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>RemediationSchedule</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are
     * <code>rate(30 days)</code>, <code>rate(7 days)</code>, <code>rate(1 days)</code>, and <code>none</code>. The
     * default value is "<code>none</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetAccounts</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) The ID of the Amazon Web Services account initiating the configuration deployment. You
     * only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be
     * provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetOrganizationalUnits</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) The ID of the root of your Organization. This configuration type doesn't currently
     * support choosing specific OUs. The configuration will be deployed to all the OUs in the Organization.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetRegions</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
     * configuration to.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>Host Management (Type: Amazon Web ServicesQuickSetupType-SSMHostMgmt)</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>UpdateSSMAgent</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A boolean value that determines whether the SSM Agent is updated on the target instances
     * every 2 weeks. The default value is "<code>true</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>UpdateEc2LaunchAgent</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A boolean value that determines whether the EC2 Launch agent is updated on the target
     * instances every month. The default value is "<code>false</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>CollectInventory</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A boolean value that determines whether the EC2 Launch agent is updated on the target
     * instances every month. The default value is "<code>true</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ScanInstances</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A boolean value that determines whether the target instances are scanned daily for
     * available patches. The default value is "<code>true</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>InstallCloudWatchAgent</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A boolean value that determines whether the Amazon CloudWatch agent is installed on the
     * target instances. The default value is "<code>false</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>UpdateCloudWatchAgent</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A boolean value that determines whether the Amazon CloudWatch agent is updated on the
     * target instances every month. The default value is "<code>false</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>IsPolicyAttachAllowed</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to instances
     * profiles already associated with the target instances. The default value is "<code>false</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetType</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) Determines how instances are targeted for local account deployments. Don't specify a
     * value for this parameter if you're deploying to OUs. The valid values are <code>*</code>,
     * <code>InstanceIds</code>, <code>ResourceGroups</code>, and <code>Tags</code>. Use <code>*</code> to target all
     * instances in the account.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetInstances</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A comma separated list of instance IDs. You must provide a value for this parameter if
     * you specify <code>InstanceIds</code> for the <code>TargetType</code> parameter.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetTagKey</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) The tag key assigned to the instances you want to target. You must provide a value for
     * this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetTagValue</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) The value of the tag key assigned to the instances you want to target. You must provide a
     * value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ResourceGroupName</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) The name of the resource group associated with the instances you want to target. You must
     * provide a value for this parameter if you specify <code>ResourceGroups</code> for the <code>TargetType</code>
     * parameter.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetAccounts</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) The ID of the Amazon Web Services account initiating the configuration deployment. You
     * only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be
     * provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetOrganizationalUnits</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration
     * to.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetRegions</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
     * configuration to.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>Distributor (Type: Amazon Web ServicesQuickSetupType-Distributor)</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>PackagesToInstall</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) A comma separated list of packages you want to install on the target instances. The valid
     * values are <code>AWSEFSTools</code>, <code>AWSCWAgent</code>, and <code>AWSEC2LaunchAgent</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>RemediationSchedule</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are
     * <code>rate(30 days)</code>, <code>rate(14 days)</code>, <code>rate(2 days)</code>, and <code>none</code>. The
     * default value is "<code>rate(30 days)</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>IsPolicyAttachAllowed</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to instances
     * profiles already associated with the target instances. The default value is "<code>false</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetType</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) Determines how instances are targeted for local account deployments. Don't specify a
     * value for this parameter if you're deploying to OUs. The valid values are <code>*</code>,
     * <code>InstanceIds</code>, <code>ResourceGroups</code>, and <code>Tags</code>. Use <code>*</code> to target all
     * instances in the account.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetInstances</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A comma separated list of instance IDs. You must provide a value for this parameter if
     * you specify <code>InstanceIds</code> for the <code>TargetType</code> parameter.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetTagKey</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) The tag key assigned to the instances you want to target. You must provide a value for
     * this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetTagValue</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) The value of the tag key assigned to the instances you want to target. You must provide a
     * value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ResourceGroupName</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) The name of the resource group associated with the instances you want to target. You must
     * provide a value for this parameter if you specify <code>ResourceGroups</code> for the <code>TargetType</code>
     * parameter.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetAccounts</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) The ID of the Amazon Web Services account initiating the configuration deployment. You
     * only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be
     * provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetOrganizationalUnits</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration
     * to.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetRegions</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
     * configuration to.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * <dt>Patch Policy (Type: Amazon Web ServicesQuickSetupType-PatchPolicy)</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * <code>PatchPolicyName</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) A name for the patch policy. The value you provide is applied to target Amazon EC2
     * instances as a tag.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>SelectedPatchBaselines</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) An array of JSON objects containing the information for the patch baselines to include in
     * your patch policy.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>PatchBaselineUseDefault</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A boolean value that determines whether the selected patch baselines are all Amazon Web
     * Services provided.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ConfigurationOptionsPatchOperation</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) Determines whether target instances scan for available patches, or scan and install
     * available patches. The valid values are <code>Scan</code> and <code>ScanAndInstall</code>. The default value for
     * the parameter is <code>Scan</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ConfigurationOptionsScanValue</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A cron expression that is used as the schedule for when instances scan for available
     * patches.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ConfigurationOptionsInstallValue</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A cron expression that is used as the schedule for when instances install available
     * patches.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ConfigurationOptionsScanNextInterval</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A boolean value that determines whether instances should scan for available patches at
     * the next cron interval. The default value is "<code>false</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ConfigurationOptionsInstallNextInterval</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A boolean value that determines whether instances should scan for available patches at
     * the next cron interval. The default value is "<code>false</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>RebootOption</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) Determines whether instances are rebooted after patches are installed. Valid values are
     * <code>RebootIfNeeded</code> and <code>NoReboot</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>IsPolicyAttachAllowed</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to instances
     * profiles already associated with the target instances. The default value is "<code>false</code>".
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>OutputLogEnableS3</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A boolean value that determines whether command output logs are sent to Amazon S3.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>OutputS3Location</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A JSON string containing information about the Amazon S3 bucket where you want to store
     * the output details of the request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>OutputS3BucketRegion</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) The Amazon Web Services Region where the Amazon S3 bucket you want Config to deliver
     * command output to is located.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>OutputS3BucketName</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) The name of the Amazon S3 bucket you want Config to deliver command output to.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>OutputS3KeyPrefix</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) The key prefix you want to use in the custom Amazon S3 bucket.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetType</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) Determines how instances are targeted for local account deployments. Don't specify a
     * value for this parameter if you're deploying to OUs. The valid values are <code>*</code>,
     * <code>InstanceIds</code>, <code>ResourceGroups</code>, and <code>Tags</code>. Use <code>*</code> to target all
     * instances in the account.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetInstances</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A comma separated list of instance IDs. You must provide a value for this parameter if
     * you specify <code>InstanceIds</code> for the <code>TargetType</code> parameter.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetTagKey</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) The tag key assigned to the instances you want to target. You must provide a value for
     * this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetTagValue</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) The value of the tag key assigned to the instances you want to target. You must provide a
     * value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ResourceGroupName</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) The name of the resource group associated with the instances you want to target. You must
     * provide a value for this parameter if you specify <code>ResourceGroups</code> for the <code>TargetType</code>
     * parameter.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetAccounts</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) The ID of the Amazon Web Services account initiating the configuration deployment. You
     * only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be
     * provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetOrganizationalUnits</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration
     * to.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>TargetRegions</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
     * configuration to.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The parameters for the configuration definition type. Parameters for configuration definitions vary based
     *         the configuration type. The following tables outline the parameters for each configuration type.</p>
     *         <dl>
     *         <dt>OpsCenter (Type: Amazon Web ServicesQuickSetupType-SSMOpsCenter)</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DelegatedAccountId</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) The ID of the delegated administrator account.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetOrganizationalUnits</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the
     *         configuration to.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetRegions</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
     *         configuration to.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>Resource Scheduler (Type: Amazon Web ServicesQuickSetupType-Scheduler)</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TargetTagKey</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) The tag key assigned to the instances you want to target.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetTagValue</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) The value of the tag key assigned to the instances you want to target.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ICalendarString</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) An iCalendar formatted string containing the schedule you want Change Manager to
     *         use.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetAccounts</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) The ID of the Amazon Web Services account initiating the configuration
     *         deployment. You only need to provide a value for this parameter if you want to deploy the configuration
     *         locally. A value must be provided for either <code>TargetAccounts</code> or
     *         <code>TargetOrganizationalUnits</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetOrganizationalUnits</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the
     *         configuration to.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetRegions</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
     *         configuration to.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>Default Host Management Configuration (Type: Amazon Web ServicesQuickSetupType-DHMC)</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>UpdateSSMAgent</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A boolean value that determines whether the SSM Agent is updated on the target
     *         instances every 2 weeks. The default value is "<code>true</code>".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetOrganizationalUnits</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the
     *         configuration to.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetRegions</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
     *         configuration to.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>Resource Explorer (Type: Amazon Web ServicesQuickSetupType-ResourceExplorer)</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SelectedAggregatorRegion</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) The Amazon Web Services Region where you want to create the aggregator index.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReplaceExistingAggregator</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) A boolean value that determines whether to demote an existing aggregator if it is
     *         in a Region that differs from the value you specify for the <code>SelectedAggregatorRegion</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetOrganizationalUnits</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the
     *         configuration to.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetRegions</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
     *         configuration to.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>Change Manager (Type: Amazon Web ServicesQuickSetupType-SSMChangeMgr)</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DelegatedAccountId</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) The ID of the delegated administrator account.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JobFunction</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) The name for the Change Manager job function.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PermissionType</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) Specifies whether you want to use default administrator permissions for the job
     *         function role, or provide a custom IAM policy. The valid values are <code>CustomPermissions</code> and
     *         <code>AdminPermissions</code>. The default value for the parameter is <code>CustomerPermissions</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CustomPermissions</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A JSON string containing the IAM policy you want your job function to use. You
     *         must provide a value for this parameter if you specify <code>CustomPermissions</code> for the
     *         <code>PermissionType</code> parameter.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetOrganizationalUnits</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the
     *         configuration to.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetRegions</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
     *         configuration to.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>DevOps Guru (Type: Amazon Web ServicesQuickSetupType-DevOpsGuru)</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AnalyseAllResources</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A boolean value that determines whether DevOps Guru analyzes all CloudFormation
     *         stacks in the account. The default value is "<code>false</code>".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EnableSnsNotifications</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A boolean value that determines whether DevOps Guru sends notifications when an
     *         insight is created. The default value is "<code>true</code>".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EnableSsmOpsItems</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A boolean value that determines whether DevOps Guru creates an OpsCenter OpsItem
     *         when an insight is created. The default value is "<code>true</code>".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EnableDriftRemediation</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A boolean value that determines whether a drift remediation schedule is used. The
     *         default value is "<code>false</code>".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RemediationSchedule</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid
     *         values are <code>rate(30 days)</code>, <code>rate(14 days)</code>, <code>rate(1 days)</code>, and
     *         <code>none</code>. The default value is "<code>none</code>".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetAccounts</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) The ID of the Amazon Web Services account initiating the configuration
     *         deployment. You only need to provide a value for this parameter if you want to deploy the configuration
     *         locally. A value must be provided for either <code>TargetAccounts</code> or
     *         <code>TargetOrganizationalUnits</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetOrganizationalUnits</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the
     *         configuration to.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetRegions</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
     *         configuration to.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>Conformance Packs (Type: Amazon Web ServicesQuickSetupType-CFGCPacks)</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DelegatedAccountId</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) The ID of the delegated administrator account. This parameter is required for
     *         Organization deployments.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RemediationSchedule</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid
     *         values are <code>rate(30 days)</code>, <code>rate(14 days)</code>, <code>rate(2 days)</code>, and
     *         <code>none</code>. The default value is "<code>none</code>".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CPackNames</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) A comma separated list of Config conformance packs.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetAccounts</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) The ID of the Amazon Web Services account initiating the configuration
     *         deployment. You only need to provide a value for this parameter if you want to deploy the configuration
     *         locally. A value must be provided for either <code>TargetAccounts</code> or
     *         <code>TargetOrganizationalUnits</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetOrganizationalUnits</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) The ID of the root of your Organization. This configuration type doesn't
     *         currently support choosing specific OUs. The configuration will be deployed to all the OUs in the
     *         Organization.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetRegions</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
     *         configuration to.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>Config Recording (Type: Amazon Web ServicesQuickSetupType-CFGRecording)</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RecordAllResources</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A boolean value that determines whether all supported resources are recorded. The
     *         default value is "<code>true</code>".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ResourceTypesToRecord</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A comma separated list of resource types you want to record.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RecordGlobalResourceTypes</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A boolean value that determines whether global resources are recorded with all
     *         resource configurations. The default value is "<code>false</code>".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GlobalResourceTypesRegion</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) Determines the Amazon Web Services Region where global resources are recorded.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UseCustomBucket</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A boolean value that determines whether a custom Amazon S3 bucket is used for
     *         delivery. The default value is "<code>false</code>".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeliveryBucketName</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) The name of the Amazon S3 bucket you want Config to deliver configuration
     *         snapshots and configuration history files to.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeliveryBucketPrefix</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) The key prefix you want to use in the custom Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NotificationOptions</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) Determines the notification configuration for the recorder. The valid values are
     *         <code>NoStreaming</code>, <code>UseExistingTopic</code>, and <code>CreateTopic</code>. The default value
     *         is <code>NoStreaming</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CustomDeliveryTopicAccountId</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) The ID of the Amazon Web Services account where the Amazon SNS topic you want to
     *         use for notifications resides. You must specify a value for this parameter if you use the
     *         <code>UseExistingTopic</code> notification option.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CustomDeliveryTopicName</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) The name of the Amazon SNS topic you want to use for notifications. You must
     *         specify a value for this parameter if you use the <code>UseExistingTopic</code> notification option.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RemediationSchedule</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid
     *         values are <code>rate(30 days)</code>, <code>rate(7 days)</code>, <code>rate(1 days)</code>, and
     *         <code>none</code>. The default value is "<code>none</code>".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetAccounts</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) The ID of the Amazon Web Services account initiating the configuration
     *         deployment. You only need to provide a value for this parameter if you want to deploy the configuration
     *         locally. A value must be provided for either <code>TargetAccounts</code> or
     *         <code>TargetOrganizationalUnits</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetOrganizationalUnits</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) The ID of the root of your Organization. This configuration type doesn't
     *         currently support choosing specific OUs. The configuration will be deployed to all the OUs in the
     *         Organization.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetRegions</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
     *         configuration to.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>Host Management (Type: Amazon Web ServicesQuickSetupType-SSMHostMgmt)</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>UpdateSSMAgent</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A boolean value that determines whether the SSM Agent is updated on the target
     *         instances every 2 weeks. The default value is "<code>true</code>".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UpdateEc2LaunchAgent</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A boolean value that determines whether the EC2 Launch agent is updated on the
     *         target instances every month. The default value is "<code>false</code>".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CollectInventory</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A boolean value that determines whether the EC2 Launch agent is updated on the
     *         target instances every month. The default value is "<code>true</code>".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ScanInstances</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A boolean value that determines whether the target instances are scanned daily
     *         for available patches. The default value is "<code>true</code>".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InstallCloudWatchAgent</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A boolean value that determines whether the Amazon CloudWatch agent is installed
     *         on the target instances. The default value is "<code>false</code>".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UpdateCloudWatchAgent</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A boolean value that determines whether the Amazon CloudWatch agent is updated on
     *         the target instances every month. The default value is "<code>false</code>".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IsPolicyAttachAllowed</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to
     *         instances profiles already associated with the target instances. The default value is "<code>false</code>
     *         ".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetType</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) Determines how instances are targeted for local account deployments. Don't
     *         specify a value for this parameter if you're deploying to OUs. The valid values are <code>*</code>,
     *         <code>InstanceIds</code>, <code>ResourceGroups</code>, and <code>Tags</code>. Use <code>*</code> to
     *         target all instances in the account.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetInstances</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A comma separated list of instance IDs. You must provide a value for this
     *         parameter if you specify <code>InstanceIds</code> for the <code>TargetType</code> parameter.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetTagKey</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) The tag key assigned to the instances you want to target. You must provide a
     *         value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetTagValue</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) The value of the tag key assigned to the instances you want to target. You must
     *         provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code>
     *         parameter.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ResourceGroupName</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) The name of the resource group associated with the instances you want to target.
     *         You must provide a value for this parameter if you specify <code>ResourceGroups</code> for the
     *         <code>TargetType</code> parameter.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetAccounts</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) The ID of the Amazon Web Services account initiating the configuration
     *         deployment. You only need to provide a value for this parameter if you want to deploy the configuration
     *         locally. A value must be provided for either <code>TargetAccounts</code> or
     *         <code>TargetOrganizationalUnits</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetOrganizationalUnits</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the
     *         configuration to.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetRegions</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
     *         configuration to.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>Distributor (Type: Amazon Web ServicesQuickSetupType-Distributor)</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PackagesToInstall</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) A comma separated list of packages you want to install on the target instances.
     *         The valid values are <code>AWSEFSTools</code>, <code>AWSCWAgent</code>, and
     *         <code>AWSEC2LaunchAgent</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RemediationSchedule</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid
     *         values are <code>rate(30 days)</code>, <code>rate(14 days)</code>, <code>rate(2 days)</code>, and
     *         <code>none</code>. The default value is "<code>rate(30 days)</code>".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IsPolicyAttachAllowed</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to
     *         instances profiles already associated with the target instances. The default value is "<code>false</code>
     *         ".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetType</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) Determines how instances are targeted for local account deployments. Don't
     *         specify a value for this parameter if you're deploying to OUs. The valid values are <code>*</code>,
     *         <code>InstanceIds</code>, <code>ResourceGroups</code>, and <code>Tags</code>. Use <code>*</code> to
     *         target all instances in the account.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetInstances</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A comma separated list of instance IDs. You must provide a value for this
     *         parameter if you specify <code>InstanceIds</code> for the <code>TargetType</code> parameter.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetTagKey</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) The tag key assigned to the instances you want to target. You must provide a
     *         value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetTagValue</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) The value of the tag key assigned to the instances you want to target. You must
     *         provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code>
     *         parameter.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ResourceGroupName</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) The name of the resource group associated with the instances you want to target.
     *         You must provide a value for this parameter if you specify <code>ResourceGroups</code> for the
     *         <code>TargetType</code> parameter.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetAccounts</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) The ID of the Amazon Web Services account initiating the configuration
     *         deployment. You only need to provide a value for this parameter if you want to deploy the configuration
     *         locally. A value must be provided for either <code>TargetAccounts</code> or
     *         <code>TargetOrganizationalUnits</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetOrganizationalUnits</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the
     *         configuration to.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetRegions</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
     *         configuration to.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>Patch Policy (Type: Amazon Web ServicesQuickSetupType-PatchPolicy)</dt>
     *         <dd>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PatchPolicyName</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) A name for the patch policy. The value you provide is applied to target Amazon
     *         EC2 instances as a tag.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SelectedPatchBaselines</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) An array of JSON objects containing the information for the patch baselines to
     *         include in your patch policy.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PatchBaselineUseDefault</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A boolean value that determines whether the selected patch baselines are all
     *         Amazon Web Services provided.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ConfigurationOptionsPatchOperation</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) Determines whether target instances scan for available patches, or scan and
     *         install available patches. The valid values are <code>Scan</code> and <code>ScanAndInstall</code>. The
     *         default value for the parameter is <code>Scan</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ConfigurationOptionsScanValue</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A cron expression that is used as the schedule for when instances scan for
     *         available patches.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ConfigurationOptionsInstallValue</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A cron expression that is used as the schedule for when instances install
     *         available patches.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ConfigurationOptionsScanNextInterval</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A boolean value that determines whether instances should scan for available
     *         patches at the next cron interval. The default value is "<code>false</code>".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ConfigurationOptionsInstallNextInterval</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A boolean value that determines whether instances should scan for available
     *         patches at the next cron interval. The default value is "<code>false</code>".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RebootOption</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) Determines whether instances are rebooted after patches are installed. Valid
     *         values are <code>RebootIfNeeded</code> and <code>NoReboot</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IsPolicyAttachAllowed</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to
     *         instances profiles already associated with the target instances. The default value is "<code>false</code>
     *         ".
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OutputLogEnableS3</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A boolean value that determines whether command output logs are sent to Amazon
     *         S3.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OutputS3Location</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A JSON string containing information about the Amazon S3 bucket where you want to
     *         store the output details of the request.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>OutputS3BucketRegion</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) The Amazon Web Services Region where the Amazon S3 bucket you want Config to
     *         deliver command output to is located.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OutputS3BucketName</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) The name of the Amazon S3 bucket you want Config to deliver command output to.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OutputS3KeyPrefix</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) The key prefix you want to use in the custom Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetType</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) Determines how instances are targeted for local account deployments. Don't
     *         specify a value for this parameter if you're deploying to OUs. The valid values are <code>*</code>,
     *         <code>InstanceIds</code>, <code>ResourceGroups</code>, and <code>Tags</code>. Use <code>*</code> to
     *         target all instances in the account.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetInstances</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A comma separated list of instance IDs. You must provide a value for this
     *         parameter if you specify <code>InstanceIds</code> for the <code>TargetType</code> parameter.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetTagKey</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) The tag key assigned to the instances you want to target. You must provide a
     *         value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetTagValue</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) The value of the tag key assigned to the instances you want to target. You must
     *         provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code>
     *         parameter.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ResourceGroupName</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) The name of the resource group associated with the instances you want to target.
     *         You must provide a value for this parameter if you specify <code>ResourceGroups</code> for the
     *         <code>TargetType</code> parameter.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetAccounts</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) The ID of the Amazon Web Services account initiating the configuration
     *         deployment. You only need to provide a value for this parameter if you want to deploy the configuration
     *         locally. A value must be provided for either <code>TargetAccounts</code> or
     *         <code>TargetOrganizationalUnits</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetOrganizationalUnits</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the
     *         configuration to.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TargetRegions</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
     *         configuration to.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </dd>
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The type of the Quick Setup configuration.
     * </p>
     * 
     * @return The type of the Quick Setup configuration.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The version of the Quick Setup type to use.
     * </p>
     * 
     * @return The version of the Quick Setup type to use.
     */
    public final String typeVersion() {
        return typeVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localDeploymentAdministrationRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(localDeploymentExecutionRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(typeVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationDefinitionInput)) {
            return false;
        }
        ConfigurationDefinitionInput other = (ConfigurationDefinitionInput) obj;
        return Objects.equals(localDeploymentAdministrationRoleArn(), other.localDeploymentAdministrationRoleArn())
                && Objects.equals(localDeploymentExecutionRoleName(), other.localDeploymentExecutionRoleName())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(type(), other.type()) && Objects.equals(typeVersion(), other.typeVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationDefinitionInput")
                .add("LocalDeploymentAdministrationRoleArn", localDeploymentAdministrationRoleArn())
                .add("LocalDeploymentExecutionRoleName", localDeploymentExecutionRoleName())
                .add("Parameters", hasParameters() ? parameters() : null).add("Type", type()).add("TypeVersion", typeVersion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalDeploymentAdministrationRoleArn":
            return Optional.ofNullable(clazz.cast(localDeploymentAdministrationRoleArn()));
        case "LocalDeploymentExecutionRoleName":
            return Optional.ofNullable(clazz.cast(localDeploymentExecutionRoleName()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "TypeVersion":
            return Optional.ofNullable(clazz.cast(typeVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LocalDeploymentAdministrationRoleArn", LOCAL_DEPLOYMENT_ADMINISTRATION_ROLE_ARN_FIELD);
        map.put("LocalDeploymentExecutionRoleName", LOCAL_DEPLOYMENT_EXECUTION_ROLE_NAME_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("TypeVersion", TYPE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationDefinitionInput, T> g) {
        return obj -> g.apply((ConfigurationDefinitionInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationDefinitionInput> {
        /**
         * <p>
         * The ARN of the IAM role used to administrate local configuration deployments.
         * </p>
         * 
         * @param localDeploymentAdministrationRoleArn
         *        The ARN of the IAM role used to administrate local configuration deployments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localDeploymentAdministrationRoleArn(String localDeploymentAdministrationRoleArn);

        /**
         * <p>
         * The name of the IAM role used to deploy local configurations.
         * </p>
         * 
         * @param localDeploymentExecutionRoleName
         *        The name of the IAM role used to deploy local configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localDeploymentExecutionRoleName(String localDeploymentExecutionRoleName);

        /**
         * <p>
         * The parameters for the configuration definition type. Parameters for configuration definitions vary based the
         * configuration type. The following tables outline the parameters for each configuration type.
         * </p>
         * <dl>
         * <dt>OpsCenter (Type: Amazon Web ServicesQuickSetupType-SSMOpsCenter)</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>DelegatedAccountId</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) The ID of the delegated administrator account.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetOrganizationalUnits</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the
         * configuration to.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetRegions</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
         * configuration to.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </dd>
         * <dt>Resource Scheduler (Type: Amazon Web ServicesQuickSetupType-Scheduler)</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>TargetTagKey</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) The tag key assigned to the instances you want to target.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetTagValue</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) The value of the tag key assigned to the instances you want to target.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ICalendarString</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) An iCalendar formatted string containing the schedule you want Change Manager to use.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetAccounts</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) The ID of the Amazon Web Services account initiating the configuration deployment.
         * You only need to provide a value for this parameter if you want to deploy the configuration locally. A value
         * must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetOrganizationalUnits</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the
         * configuration to.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetRegions</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
         * configuration to.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </dd>
         * <dt>Default Host Management Configuration (Type: Amazon Web ServicesQuickSetupType-DHMC)</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>UpdateSSMAgent</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A boolean value that determines whether the SSM Agent is updated on the target
         * instances every 2 weeks. The default value is "<code>true</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetOrganizationalUnits</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the
         * configuration to.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetRegions</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
         * configuration to.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </dd>
         * <dt>Resource Explorer (Type: Amazon Web ServicesQuickSetupType-ResourceExplorer)</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>SelectedAggregatorRegion</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) The Amazon Web Services Region where you want to create the aggregator index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ReplaceExistingAggregator</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) A boolean value that determines whether to demote an existing aggregator if it is in
         * a Region that differs from the value you specify for the <code>SelectedAggregatorRegion</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetOrganizationalUnits</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the
         * configuration to.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetRegions</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
         * configuration to.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </dd>
         * <dt>Change Manager (Type: Amazon Web ServicesQuickSetupType-SSMChangeMgr)</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>DelegatedAccountId</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) The ID of the delegated administrator account.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>JobFunction</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) The name for the Change Manager job function.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>PermissionType</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) Specifies whether you want to use default administrator permissions for the job
         * function role, or provide a custom IAM policy. The valid values are <code>CustomPermissions</code> and
         * <code>AdminPermissions</code>. The default value for the parameter is <code>CustomerPermissions</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>CustomPermissions</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A JSON string containing the IAM policy you want your job function to use. You must
         * provide a value for this parameter if you specify <code>CustomPermissions</code> for the
         * <code>PermissionType</code> parameter.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetOrganizationalUnits</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the
         * configuration to.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetRegions</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
         * configuration to.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </dd>
         * <dt>DevOps Guru (Type: Amazon Web ServicesQuickSetupType-DevOpsGuru)</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>AnalyseAllResources</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A boolean value that determines whether DevOps Guru analyzes all CloudFormation
         * stacks in the account. The default value is "<code>false</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>EnableSnsNotifications</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A boolean value that determines whether DevOps Guru sends notifications when an
         * insight is created. The default value is "<code>true</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>EnableSsmOpsItems</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A boolean value that determines whether DevOps Guru creates an OpsCenter OpsItem when
         * an insight is created. The default value is "<code>true</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>EnableDriftRemediation</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A boolean value that determines whether a drift remediation schedule is used. The
         * default value is "<code>false</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>RemediationSchedule</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values
         * are <code>rate(30 days)</code>, <code>rate(14 days)</code>, <code>rate(1 days)</code>, and <code>none</code>.
         * The default value is "<code>none</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetAccounts</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) The ID of the Amazon Web Services account initiating the configuration deployment.
         * You only need to provide a value for this parameter if you want to deploy the configuration locally. A value
         * must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetOrganizationalUnits</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the
         * configuration to.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetRegions</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
         * configuration to.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </dd>
         * <dt>Conformance Packs (Type: Amazon Web ServicesQuickSetupType-CFGCPacks)</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>DelegatedAccountId</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) The ID of the delegated administrator account. This parameter is required for
         * Organization deployments.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>RemediationSchedule</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values
         * are <code>rate(30 days)</code>, <code>rate(14 days)</code>, <code>rate(2 days)</code>, and <code>none</code>.
         * The default value is "<code>none</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>CPackNames</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) A comma separated list of Config conformance packs.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetAccounts</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) The ID of the Amazon Web Services account initiating the configuration deployment.
         * You only need to provide a value for this parameter if you want to deploy the configuration locally. A value
         * must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetOrganizationalUnits</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) The ID of the root of your Organization. This configuration type doesn't currently
         * support choosing specific OUs. The configuration will be deployed to all the OUs in the Organization.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetRegions</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
         * configuration to.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </dd>
         * <dt>Config Recording (Type: Amazon Web ServicesQuickSetupType-CFGRecording)</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>RecordAllResources</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A boolean value that determines whether all supported resources are recorded. The
         * default value is "<code>true</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ResourceTypesToRecord</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A comma separated list of resource types you want to record.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>RecordGlobalResourceTypes</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A boolean value that determines whether global resources are recorded with all
         * resource configurations. The default value is "<code>false</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>GlobalResourceTypesRegion</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) Determines the Amazon Web Services Region where global resources are recorded.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>UseCustomBucket</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A boolean value that determines whether a custom Amazon S3 bucket is used for
         * delivery. The default value is "<code>false</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>DeliveryBucketName</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) The name of the Amazon S3 bucket you want Config to deliver configuration snapshots
         * and configuration history files to.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>DeliveryBucketPrefix</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) The key prefix you want to use in the custom Amazon S3 bucket.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NotificationOptions</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) Determines the notification configuration for the recorder. The valid values are
         * <code>NoStreaming</code>, <code>UseExistingTopic</code>, and <code>CreateTopic</code>. The default value is
         * <code>NoStreaming</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>CustomDeliveryTopicAccountId</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) The ID of the Amazon Web Services account where the Amazon SNS topic you want to use
         * for notifications resides. You must specify a value for this parameter if you use the
         * <code>UseExistingTopic</code> notification option.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>CustomDeliveryTopicName</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) The name of the Amazon SNS topic you want to use for notifications. You must specify
         * a value for this parameter if you use the <code>UseExistingTopic</code> notification option.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>RemediationSchedule</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values
         * are <code>rate(30 days)</code>, <code>rate(7 days)</code>, <code>rate(1 days)</code>, and <code>none</code>.
         * The default value is "<code>none</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetAccounts</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) The ID of the Amazon Web Services account initiating the configuration deployment.
         * You only need to provide a value for this parameter if you want to deploy the configuration locally. A value
         * must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetOrganizationalUnits</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) The ID of the root of your Organization. This configuration type doesn't currently
         * support choosing specific OUs. The configuration will be deployed to all the OUs in the Organization.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetRegions</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
         * configuration to.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </dd>
         * <dt>Host Management (Type: Amazon Web ServicesQuickSetupType-SSMHostMgmt)</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>UpdateSSMAgent</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A boolean value that determines whether the SSM Agent is updated on the target
         * instances every 2 weeks. The default value is "<code>true</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>UpdateEc2LaunchAgent</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A boolean value that determines whether the EC2 Launch agent is updated on the target
         * instances every month. The default value is "<code>false</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>CollectInventory</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A boolean value that determines whether the EC2 Launch agent is updated on the target
         * instances every month. The default value is "<code>true</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ScanInstances</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A boolean value that determines whether the target instances are scanned daily for
         * available patches. The default value is "<code>true</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>InstallCloudWatchAgent</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A boolean value that determines whether the Amazon CloudWatch agent is installed on
         * the target instances. The default value is "<code>false</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>UpdateCloudWatchAgent</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A boolean value that determines whether the Amazon CloudWatch agent is updated on the
         * target instances every month. The default value is "<code>false</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>IsPolicyAttachAllowed</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to instances
         * profiles already associated with the target instances. The default value is "<code>false</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetType</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) Determines how instances are targeted for local account deployments. Don't specify a
         * value for this parameter if you're deploying to OUs. The valid values are <code>*</code>,
         * <code>InstanceIds</code>, <code>ResourceGroups</code>, and <code>Tags</code>. Use <code>*</code> to target
         * all instances in the account.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetInstances</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A comma separated list of instance IDs. You must provide a value for this parameter
         * if you specify <code>InstanceIds</code> for the <code>TargetType</code> parameter.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetTagKey</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) The tag key assigned to the instances you want to target. You must provide a value
         * for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetTagValue</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) The value of the tag key assigned to the instances you want to target. You must
         * provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code>
         * parameter.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ResourceGroupName</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) The name of the resource group associated with the instances you want to target. You
         * must provide a value for this parameter if you specify <code>ResourceGroups</code> for the
         * <code>TargetType</code> parameter.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetAccounts</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) The ID of the Amazon Web Services account initiating the configuration deployment.
         * You only need to provide a value for this parameter if you want to deploy the configuration locally. A value
         * must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetOrganizationalUnits</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the
         * configuration to.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetRegions</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
         * configuration to.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </dd>
         * <dt>Distributor (Type: Amazon Web ServicesQuickSetupType-Distributor)</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>PackagesToInstall</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) A comma separated list of packages you want to install on the target instances. The
         * valid values are <code>AWSEFSTools</code>, <code>AWSCWAgent</code>, and <code>AWSEC2LaunchAgent</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>RemediationSchedule</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values
         * are <code>rate(30 days)</code>, <code>rate(14 days)</code>, <code>rate(2 days)</code>, and <code>none</code>.
         * The default value is "<code>rate(30 days)</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>IsPolicyAttachAllowed</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to instances
         * profiles already associated with the target instances. The default value is "<code>false</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetType</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) Determines how instances are targeted for local account deployments. Don't specify a
         * value for this parameter if you're deploying to OUs. The valid values are <code>*</code>,
         * <code>InstanceIds</code>, <code>ResourceGroups</code>, and <code>Tags</code>. Use <code>*</code> to target
         * all instances in the account.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetInstances</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A comma separated list of instance IDs. You must provide a value for this parameter
         * if you specify <code>InstanceIds</code> for the <code>TargetType</code> parameter.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetTagKey</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) The tag key assigned to the instances you want to target. You must provide a value
         * for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetTagValue</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) The value of the tag key assigned to the instances you want to target. You must
         * provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code>
         * parameter.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ResourceGroupName</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) The name of the resource group associated with the instances you want to target. You
         * must provide a value for this parameter if you specify <code>ResourceGroups</code> for the
         * <code>TargetType</code> parameter.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetAccounts</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) The ID of the Amazon Web Services account initiating the configuration deployment.
         * You only need to provide a value for this parameter if you want to deploy the configuration locally. A value
         * must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetOrganizationalUnits</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the
         * configuration to.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetRegions</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
         * configuration to.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </dd>
         * <dt>Patch Policy (Type: Amazon Web ServicesQuickSetupType-PatchPolicy)</dt>
         * <dd>
         * <ul>
         * <li>
         * <p>
         * <code>PatchPolicyName</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) A name for the patch policy. The value you provide is applied to target Amazon EC2
         * instances as a tag.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>SelectedPatchBaselines</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) An array of JSON objects containing the information for the patch baselines to
         * include in your patch policy.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>PatchBaselineUseDefault</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A boolean value that determines whether the selected patch baselines are all Amazon
         * Web Services provided.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ConfigurationOptionsPatchOperation</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) Determines whether target instances scan for available patches, or scan and install
         * available patches. The valid values are <code>Scan</code> and <code>ScanAndInstall</code>. The default value
         * for the parameter is <code>Scan</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ConfigurationOptionsScanValue</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A cron expression that is used as the schedule for when instances scan for available
         * patches.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ConfigurationOptionsInstallValue</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A cron expression that is used as the schedule for when instances install available
         * patches.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ConfigurationOptionsScanNextInterval</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A boolean value that determines whether instances should scan for available patches
         * at the next cron interval. The default value is "<code>false</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ConfigurationOptionsInstallNextInterval</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A boolean value that determines whether instances should scan for available patches
         * at the next cron interval. The default value is "<code>false</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>RebootOption</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) Determines whether instances are rebooted after patches are installed. Valid values
         * are <code>RebootIfNeeded</code> and <code>NoReboot</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>IsPolicyAttachAllowed</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to instances
         * profiles already associated with the target instances. The default value is "<code>false</code>".
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>OutputLogEnableS3</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A boolean value that determines whether command output logs are sent to Amazon S3.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>OutputS3Location</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A JSON string containing information about the Amazon S3 bucket where you want to
         * store the output details of the request.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>OutputS3BucketRegion</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) The Amazon Web Services Region where the Amazon S3 bucket you want Config to deliver
         * command output to is located.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>OutputS3BucketName</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) The name of the Amazon S3 bucket you want Config to deliver command output to.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>OutputS3KeyPrefix</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) The key prefix you want to use in the custom Amazon S3 bucket.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetType</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) Determines how instances are targeted for local account deployments. Don't specify a
         * value for this parameter if you're deploying to OUs. The valid values are <code>*</code>,
         * <code>InstanceIds</code>, <code>ResourceGroups</code>, and <code>Tags</code>. Use <code>*</code> to target
         * all instances in the account.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetInstances</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A comma separated list of instance IDs. You must provide a value for this parameter
         * if you specify <code>InstanceIds</code> for the <code>TargetType</code> parameter.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetTagKey</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) The tag key assigned to the instances you want to target. You must provide a value
         * for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetTagValue</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) The value of the tag key assigned to the instances you want to target. You must
         * provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code>
         * parameter.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ResourceGroupName</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) The name of the resource group associated with the instances you want to target. You
         * must provide a value for this parameter if you specify <code>ResourceGroups</code> for the
         * <code>TargetType</code> parameter.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetAccounts</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) The ID of the Amazon Web Services account initiating the configuration deployment.
         * You only need to provide a value for this parameter if you want to deploy the configuration locally. A value
         * must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetOrganizationalUnits</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the
         * configuration to.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>TargetRegions</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
         * configuration to.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </dd>
         * </dl>
         * 
         * @param parameters
         *        The parameters for the configuration definition type. Parameters for configuration definitions vary
         *        based the configuration type. The following tables outline the parameters for each configuration
         *        type.</p>
         *        <dl>
         *        <dt>OpsCenter (Type: Amazon Web ServicesQuickSetupType-SSMOpsCenter)</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DelegatedAccountId</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) The ID of the delegated administrator account.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetOrganizationalUnits</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the
         *        configuration to.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetRegions</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
         *        configuration to.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>Resource Scheduler (Type: Amazon Web ServicesQuickSetupType-Scheduler)</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TargetTagKey</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) The tag key assigned to the instances you want to target.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetTagValue</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) The value of the tag key assigned to the instances you want to target.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ICalendarString</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) An iCalendar formatted string containing the schedule you want Change Manager
         *        to use.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetAccounts</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) The ID of the Amazon Web Services account initiating the configuration
         *        deployment. You only need to provide a value for this parameter if you want to deploy the
         *        configuration locally. A value must be provided for either <code>TargetAccounts</code> or
         *        <code>TargetOrganizationalUnits</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetOrganizationalUnits</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the
         *        configuration to.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetRegions</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
         *        configuration to.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>Default Host Management Configuration (Type: Amazon Web ServicesQuickSetupType-DHMC)</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>UpdateSSMAgent</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A boolean value that determines whether the SSM Agent is updated on the target
         *        instances every 2 weeks. The default value is "<code>true</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetOrganizationalUnits</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the
         *        configuration to.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetRegions</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
         *        configuration to.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>Resource Explorer (Type: Amazon Web ServicesQuickSetupType-ResourceExplorer)</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SelectedAggregatorRegion</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) The Amazon Web Services Region where you want to create the aggregator index.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReplaceExistingAggregator</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) A boolean value that determines whether to demote an existing aggregator if it
         *        is in a Region that differs from the value you specify for the <code>SelectedAggregatorRegion</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetOrganizationalUnits</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the
         *        configuration to.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetRegions</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
         *        configuration to.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>Change Manager (Type: Amazon Web ServicesQuickSetupType-SSMChangeMgr)</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DelegatedAccountId</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) The ID of the delegated administrator account.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JobFunction</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) The name for the Change Manager job function.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PermissionType</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) Specifies whether you want to use default administrator permissions for the
         *        job function role, or provide a custom IAM policy. The valid values are <code>CustomPermissions</code>
         *        and <code>AdminPermissions</code>. The default value for the parameter is
         *        <code>CustomerPermissions</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CustomPermissions</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A JSON string containing the IAM policy you want your job function to use. You
         *        must provide a value for this parameter if you specify <code>CustomPermissions</code> for the
         *        <code>PermissionType</code> parameter.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetOrganizationalUnits</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the
         *        configuration to.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetRegions</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
         *        configuration to.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>DevOps Guru (Type: Amazon Web ServicesQuickSetupType-DevOpsGuru)</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AnalyseAllResources</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A boolean value that determines whether DevOps Guru analyzes all
         *        CloudFormation stacks in the account. The default value is "<code>false</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EnableSnsNotifications</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A boolean value that determines whether DevOps Guru sends notifications when
         *        an insight is created. The default value is "<code>true</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EnableSsmOpsItems</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A boolean value that determines whether DevOps Guru creates an OpsCenter
         *        OpsItem when an insight is created. The default value is "<code>true</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EnableDriftRemediation</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A boolean value that determines whether a drift remediation schedule is used.
         *        The default value is "<code>false</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RemediationSchedule</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid
         *        values are <code>rate(30 days)</code>, <code>rate(14 days)</code>, <code>rate(1 days)</code>, and
         *        <code>none</code>. The default value is "<code>none</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetAccounts</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) The ID of the Amazon Web Services account initiating the configuration
         *        deployment. You only need to provide a value for this parameter if you want to deploy the
         *        configuration locally. A value must be provided for either <code>TargetAccounts</code> or
         *        <code>TargetOrganizationalUnits</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetOrganizationalUnits</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the
         *        configuration to.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetRegions</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
         *        configuration to.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>Conformance Packs (Type: Amazon Web ServicesQuickSetupType-CFGCPacks)</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DelegatedAccountId</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) The ID of the delegated administrator account. This parameter is required for
         *        Organization deployments.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RemediationSchedule</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid
         *        values are <code>rate(30 days)</code>, <code>rate(14 days)</code>, <code>rate(2 days)</code>, and
         *        <code>none</code>. The default value is "<code>none</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CPackNames</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) A comma separated list of Config conformance packs.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetAccounts</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) The ID of the Amazon Web Services account initiating the configuration
         *        deployment. You only need to provide a value for this parameter if you want to deploy the
         *        configuration locally. A value must be provided for either <code>TargetAccounts</code> or
         *        <code>TargetOrganizationalUnits</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetOrganizationalUnits</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) The ID of the root of your Organization. This configuration type doesn't
         *        currently support choosing specific OUs. The configuration will be deployed to all the OUs in the
         *        Organization.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetRegions</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
         *        configuration to.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>Config Recording (Type: Amazon Web ServicesQuickSetupType-CFGRecording)</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RecordAllResources</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A boolean value that determines whether all supported resources are recorded.
         *        The default value is "<code>true</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ResourceTypesToRecord</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A comma separated list of resource types you want to record.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RecordGlobalResourceTypes</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A boolean value that determines whether global resources are recorded with all
         *        resource configurations. The default value is "<code>false</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GlobalResourceTypesRegion</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) Determines the Amazon Web Services Region where global resources are recorded.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UseCustomBucket</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A boolean value that determines whether a custom Amazon S3 bucket is used for
         *        delivery. The default value is "<code>false</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeliveryBucketName</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) The name of the Amazon S3 bucket you want Config to deliver configuration
         *        snapshots and configuration history files to.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeliveryBucketPrefix</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) The key prefix you want to use in the custom Amazon S3 bucket.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NotificationOptions</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) Determines the notification configuration for the recorder. The valid values
         *        are <code>NoStreaming</code>, <code>UseExistingTopic</code>, and <code>CreateTopic</code>. The default
         *        value is <code>NoStreaming</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CustomDeliveryTopicAccountId</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) The ID of the Amazon Web Services account where the Amazon SNS topic you want
         *        to use for notifications resides. You must specify a value for this parameter if you use the
         *        <code>UseExistingTopic</code> notification option.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CustomDeliveryTopicName</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) The name of the Amazon SNS topic you want to use for notifications. You must
         *        specify a value for this parameter if you use the <code>UseExistingTopic</code> notification option.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RemediationSchedule</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid
         *        values are <code>rate(30 days)</code>, <code>rate(7 days)</code>, <code>rate(1 days)</code>, and
         *        <code>none</code>. The default value is "<code>none</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetAccounts</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) The ID of the Amazon Web Services account initiating the configuration
         *        deployment. You only need to provide a value for this parameter if you want to deploy the
         *        configuration locally. A value must be provided for either <code>TargetAccounts</code> or
         *        <code>TargetOrganizationalUnits</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetOrganizationalUnits</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) The ID of the root of your Organization. This configuration type doesn't
         *        currently support choosing specific OUs. The configuration will be deployed to all the OUs in the
         *        Organization.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetRegions</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
         *        configuration to.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>Host Management (Type: Amazon Web ServicesQuickSetupType-SSMHostMgmt)</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>UpdateSSMAgent</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A boolean value that determines whether the SSM Agent is updated on the target
         *        instances every 2 weeks. The default value is "<code>true</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UpdateEc2LaunchAgent</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A boolean value that determines whether the EC2 Launch agent is updated on the
         *        target instances every month. The default value is "<code>false</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CollectInventory</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A boolean value that determines whether the EC2 Launch agent is updated on the
         *        target instances every month. The default value is "<code>true</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ScanInstances</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A boolean value that determines whether the target instances are scanned daily
         *        for available patches. The default value is "<code>true</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InstallCloudWatchAgent</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A boolean value that determines whether the Amazon CloudWatch agent is
         *        installed on the target instances. The default value is "<code>false</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UpdateCloudWatchAgent</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A boolean value that determines whether the Amazon CloudWatch agent is updated
         *        on the target instances every month. The default value is "<code>false</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IsPolicyAttachAllowed</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to
         *        instances profiles already associated with the target instances. The default value is "
         *        <code>false</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetType</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) Determines how instances are targeted for local account deployments. Don't
         *        specify a value for this parameter if you're deploying to OUs. The valid values are <code>*</code>,
         *        <code>InstanceIds</code>, <code>ResourceGroups</code>, and <code>Tags</code>. Use <code>*</code> to
         *        target all instances in the account.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetInstances</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A comma separated list of instance IDs. You must provide a value for this
         *        parameter if you specify <code>InstanceIds</code> for the <code>TargetType</code> parameter.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetTagKey</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) The tag key assigned to the instances you want to target. You must provide a
         *        value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetTagValue</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) The value of the tag key assigned to the instances you want to target. You
         *        must provide a value for this parameter if you specify <code>Tags</code> for the
         *        <code>TargetType</code> parameter.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ResourceGroupName</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) The name of the resource group associated with the instances you want to
         *        target. You must provide a value for this parameter if you specify <code>ResourceGroups</code> for the
         *        <code>TargetType</code> parameter.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetAccounts</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) The ID of the Amazon Web Services account initiating the configuration
         *        deployment. You only need to provide a value for this parameter if you want to deploy the
         *        configuration locally. A value must be provided for either <code>TargetAccounts</code> or
         *        <code>TargetOrganizationalUnits</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetOrganizationalUnits</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the
         *        configuration to.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetRegions</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
         *        configuration to.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>Distributor (Type: Amazon Web ServicesQuickSetupType-Distributor)</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PackagesToInstall</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) A comma separated list of packages you want to install on the target
         *        instances. The valid values are <code>AWSEFSTools</code>, <code>AWSCWAgent</code>, and
         *        <code>AWSEC2LaunchAgent</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RemediationSchedule</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid
         *        values are <code>rate(30 days)</code>, <code>rate(14 days)</code>, <code>rate(2 days)</code>, and
         *        <code>none</code>. The default value is "<code>rate(30 days)</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IsPolicyAttachAllowed</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to
         *        instances profiles already associated with the target instances. The default value is "
         *        <code>false</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetType</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) Determines how instances are targeted for local account deployments. Don't
         *        specify a value for this parameter if you're deploying to OUs. The valid values are <code>*</code>,
         *        <code>InstanceIds</code>, <code>ResourceGroups</code>, and <code>Tags</code>. Use <code>*</code> to
         *        target all instances in the account.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetInstances</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A comma separated list of instance IDs. You must provide a value for this
         *        parameter if you specify <code>InstanceIds</code> for the <code>TargetType</code> parameter.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetTagKey</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) The tag key assigned to the instances you want to target. You must provide a
         *        value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetTagValue</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) The value of the tag key assigned to the instances you want to target. You
         *        must provide a value for this parameter if you specify <code>Tags</code> for the
         *        <code>TargetType</code> parameter.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ResourceGroupName</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) The name of the resource group associated with the instances you want to
         *        target. You must provide a value for this parameter if you specify <code>ResourceGroups</code> for the
         *        <code>TargetType</code> parameter.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetAccounts</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) The ID of the Amazon Web Services account initiating the configuration
         *        deployment. You only need to provide a value for this parameter if you want to deploy the
         *        configuration locally. A value must be provided for either <code>TargetAccounts</code> or
         *        <code>TargetOrganizationalUnits</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetOrganizationalUnits</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the
         *        configuration to.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetRegions</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
         *        configuration to.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </dd>
         *        <dt>Patch Policy (Type: Amazon Web ServicesQuickSetupType-PatchPolicy)</dt>
         *        <dd>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PatchPolicyName</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) A name for the patch policy. The value you provide is applied to target Amazon
         *        EC2 instances as a tag.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SelectedPatchBaselines</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) An array of JSON objects containing the information for the patch baselines to
         *        include in your patch policy.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PatchBaselineUseDefault</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A boolean value that determines whether the selected patch baselines are all
         *        Amazon Web Services provided.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ConfigurationOptionsPatchOperation</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) Determines whether target instances scan for available patches, or scan and
         *        install available patches. The valid values are <code>Scan</code> and <code>ScanAndInstall</code>. The
         *        default value for the parameter is <code>Scan</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ConfigurationOptionsScanValue</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A cron expression that is used as the schedule for when instances scan for
         *        available patches.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ConfigurationOptionsInstallValue</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A cron expression that is used as the schedule for when instances install
         *        available patches.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ConfigurationOptionsScanNextInterval</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A boolean value that determines whether instances should scan for available
         *        patches at the next cron interval. The default value is "<code>false</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ConfigurationOptionsInstallNextInterval</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A boolean value that determines whether instances should scan for available
         *        patches at the next cron interval. The default value is "<code>false</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RebootOption</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) Determines whether instances are rebooted after patches are installed. Valid
         *        values are <code>RebootIfNeeded</code> and <code>NoReboot</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IsPolicyAttachAllowed</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to
         *        instances profiles already associated with the target instances. The default value is "
         *        <code>false</code>".
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutputLogEnableS3</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A boolean value that determines whether command output logs are sent to Amazon
         *        S3.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutputS3Location</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A JSON string containing information about the Amazon S3 bucket where you want
         *        to store the output details of the request.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>OutputS3BucketRegion</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) The Amazon Web Services Region where the Amazon S3 bucket you want Config to
         *        deliver command output to is located.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutputS3BucketName</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) The name of the Amazon S3 bucket you want Config to deliver command output to.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutputS3KeyPrefix</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) The key prefix you want to use in the custom Amazon S3 bucket.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetType</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) Determines how instances are targeted for local account deployments. Don't
         *        specify a value for this parameter if you're deploying to OUs. The valid values are <code>*</code>,
         *        <code>InstanceIds</code>, <code>ResourceGroups</code>, and <code>Tags</code>. Use <code>*</code> to
         *        target all instances in the account.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetInstances</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A comma separated list of instance IDs. You must provide a value for this
         *        parameter if you specify <code>InstanceIds</code> for the <code>TargetType</code> parameter.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetTagKey</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) The tag key assigned to the instances you want to target. You must provide a
         *        value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetTagValue</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) The value of the tag key assigned to the instances you want to target. You
         *        must provide a value for this parameter if you specify <code>Tags</code> for the
         *        <code>TargetType</code> parameter.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ResourceGroupName</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) The name of the resource group associated with the instances you want to
         *        target. You must provide a value for this parameter if you specify <code>ResourceGroups</code> for the
         *        <code>TargetType</code> parameter.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetAccounts</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) The ID of the Amazon Web Services account initiating the configuration
         *        deployment. You only need to provide a value for this parameter if you want to deploy the
         *        configuration locally. A value must be provided for either <code>TargetAccounts</code> or
         *        <code>TargetOrganizationalUnits</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetOrganizationalUnits</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the
         *        configuration to.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TargetRegions</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Description: (Required) A comma separated list of Amazon Web Services Regions you want to deploy the
         *        configuration to.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * The type of the Quick Setup configuration.
         * </p>
         * 
         * @param type
         *        The type of the Quick Setup configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The version of the Quick Setup type to use.
         * </p>
         * 
         * @param typeVersion
         *        The version of the Quick Setup type to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeVersion(String typeVersion);
    }

    static final class BuilderImpl implements Builder {
        private String localDeploymentAdministrationRoleArn;

        private String localDeploymentExecutionRoleName;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private String typeVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationDefinitionInput model) {
            localDeploymentAdministrationRoleArn(model.localDeploymentAdministrationRoleArn);
            localDeploymentExecutionRoleName(model.localDeploymentExecutionRoleName);
            parameters(model.parameters);
            type(model.type);
            typeVersion(model.typeVersion);
        }

        public final String getLocalDeploymentAdministrationRoleArn() {
            return localDeploymentAdministrationRoleArn;
        }

        public final void setLocalDeploymentAdministrationRoleArn(String localDeploymentAdministrationRoleArn) {
            this.localDeploymentAdministrationRoleArn = localDeploymentAdministrationRoleArn;
        }

        @Override
        public final Builder localDeploymentAdministrationRoleArn(String localDeploymentAdministrationRoleArn) {
            this.localDeploymentAdministrationRoleArn = localDeploymentAdministrationRoleArn;
            return this;
        }

        public final String getLocalDeploymentExecutionRoleName() {
            return localDeploymentExecutionRoleName;
        }

        public final void setLocalDeploymentExecutionRoleName(String localDeploymentExecutionRoleName) {
            this.localDeploymentExecutionRoleName = localDeploymentExecutionRoleName;
        }

        @Override
        public final Builder localDeploymentExecutionRoleName(String localDeploymentExecutionRoleName) {
            this.localDeploymentExecutionRoleName = localDeploymentExecutionRoleName;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ConfigurationParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ConfigurationParametersMapCopier.copy(parameters);
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getTypeVersion() {
            return typeVersion;
        }

        public final void setTypeVersion(String typeVersion) {
            this.typeVersion = typeVersion;
        }

        @Override
        public final Builder typeVersion(String typeVersion) {
            this.typeVersion = typeVersion;
            return this;
        }

        @Override
        public ConfigurationDefinitionInput build() {
            return new ConfigurationDefinitionInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
