/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmquicksetup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConfigurationResponse extends SsmQuickSetupResponse implements
        ToCopyableBuilder<GetConfigurationResponse.Builder, GetConfigurationResponse> {
    private static final SdkField<String> ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Account")
            .getter(getter(GetConfigurationResponse::account)).setter(setter(Builder::account))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Account").build()).build();

    private static final SdkField<String> CONFIGURATION_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationDefinitionId").getter(getter(GetConfigurationResponse::configurationDefinitionId))
            .setter(setter(Builder::configurationDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationDefinitionId").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(GetConfigurationResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetConfigurationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedAt")
            .getter(getter(GetConfigurationResponse::lastModifiedAt))
            .setter(setter(Builder::lastModifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> MANAGER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagerArn").getter(getter(GetConfigurationResponse::managerArn)).setter(setter(Builder::managerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagerArn").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(GetConfigurationResponse::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(GetConfigurationResponse::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<List<StatusSummary>> STATUS_SUMMARIES_FIELD = SdkField
            .<List<StatusSummary>> builder(MarshallingType.LIST)
            .memberName("StatusSummaries")
            .getter(getter(GetConfigurationResponse::statusSummaries))
            .setter(setter(Builder::statusSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StatusSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(StatusSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(GetConfigurationResponse::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> TYPE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeVersion").getter(getter(GetConfigurationResponse::typeVersion)).setter(setter(Builder::typeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_FIELD,
            CONFIGURATION_DEFINITION_ID_FIELD, CREATED_AT_FIELD, ID_FIELD, LAST_MODIFIED_AT_FIELD, MANAGER_ARN_FIELD,
            PARAMETERS_FIELD, REGION_FIELD, STATUS_SUMMARIES_FIELD, TYPE_FIELD, TYPE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String account;

    private final String configurationDefinitionId;

    private final Instant createdAt;

    private final String id;

    private final Instant lastModifiedAt;

    private final String managerArn;

    private final Map<String, String> parameters;

    private final String region;

    private final List<StatusSummary> statusSummaries;

    private final String type;

    private final String typeVersion;

    private GetConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.account = builder.account;
        this.configurationDefinitionId = builder.configurationDefinitionId;
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.managerArn = builder.managerArn;
        this.parameters = builder.parameters;
        this.region = builder.region;
        this.statusSummaries = builder.statusSummaries;
        this.type = builder.type;
        this.typeVersion = builder.typeVersion;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account where the configuration was deployed.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account where the configuration was deployed.
     */
    public final String account() {
        return account;
    }

    /**
     * <p>
     * The ID of the configuration definition.
     * </p>
     * 
     * @return The ID of the configuration definition.
     */
    public final String configurationDefinitionId() {
        return configurationDefinitionId;
    }

    /**
     * <p>
     * The datetime stamp when the configuration manager was created.
     * </p>
     * 
     * @return The datetime stamp when the configuration manager was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * A service generated identifier for the configuration.
     * </p>
     * 
     * @return A service generated identifier for the configuration.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The datetime stamp when the configuration manager was last updated.
     * </p>
     * 
     * @return The datetime stamp when the configuration manager was last updated.
     */
    public final Instant lastModifiedAt() {
        return lastModifiedAt;
    }

    /**
     * <p>
     * The ARN of the configuration manager.
     * </p>
     * 
     * @return The ARN of the configuration manager.
     */
    public final String managerArn() {
        return managerArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The parameters for the configuration definition type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The parameters for the configuration definition type.
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The Amazon Web Services Region where the configuration was deployed.
     * </p>
     * 
     * @return The Amazon Web Services Region where the configuration was deployed.
     */
    public final String region() {
        return region;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatusSummaries() {
        return statusSummaries != null && !(statusSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A summary of the state of the configuration manager. This includes deployment statuses, association statuses,
     * drift statuses, health checks, and more.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusSummaries} method.
     * </p>
     * 
     * @return A summary of the state of the configuration manager. This includes deployment statuses, association
     *         statuses, drift statuses, health checks, and more.
     */
    public final List<StatusSummary> statusSummaries() {
        return statusSummaries;
    }

    /**
     * <p>
     * The type of the Quick Setup configuration.
     * </p>
     * 
     * @return The type of the Quick Setup configuration.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The version of the Quick Setup type used.
     * </p>
     * 
     * @return The version of the Quick Setup type used.
     */
    public final String typeVersion() {
        return typeVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(account());
        hashCode = 31 * hashCode + Objects.hashCode(configurationDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(managerArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusSummaries() ? statusSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(typeVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigurationResponse)) {
            return false;
        }
        GetConfigurationResponse other = (GetConfigurationResponse) obj;
        return Objects.equals(account(), other.account())
                && Objects.equals(configurationDefinitionId(), other.configurationDefinitionId())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(id(), other.id())
                && Objects.equals(lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(managerArn(), other.managerArn())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(region(), other.region()) && hasStatusSummaries() == other.hasStatusSummaries()
                && Objects.equals(statusSummaries(), other.statusSummaries()) && Objects.equals(type(), other.type())
                && Objects.equals(typeVersion(), other.typeVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConfigurationResponse").add("Account", account())
                .add("ConfigurationDefinitionId", configurationDefinitionId()).add("CreatedAt", createdAt()).add("Id", id())
                .add("LastModifiedAt", lastModifiedAt()).add("ManagerArn", managerArn())
                .add("Parameters", hasParameters() ? parameters() : null).add("Region", region())
                .add("StatusSummaries", hasStatusSummaries() ? statusSummaries() : null).add("Type", type())
                .add("TypeVersion", typeVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Account":
            return Optional.ofNullable(clazz.cast(account()));
        case "ConfigurationDefinitionId":
            return Optional.ofNullable(clazz.cast(configurationDefinitionId()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LastModifiedAt":
            return Optional.ofNullable(clazz.cast(lastModifiedAt()));
        case "ManagerArn":
            return Optional.ofNullable(clazz.cast(managerArn()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "StatusSummaries":
            return Optional.ofNullable(clazz.cast(statusSummaries()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "TypeVersion":
            return Optional.ofNullable(clazz.cast(typeVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Account", ACCOUNT_FIELD);
        map.put("ConfigurationDefinitionId", CONFIGURATION_DEFINITION_ID_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("Id", ID_FIELD);
        map.put("LastModifiedAt", LAST_MODIFIED_AT_FIELD);
        map.put("ManagerArn", MANAGER_ARN_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("StatusSummaries", STATUS_SUMMARIES_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("TypeVersion", TYPE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConfigurationResponse, T> g) {
        return obj -> g.apply((GetConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmQuickSetupResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetConfigurationResponse> {
        /**
         * <p>
         * The ID of the Amazon Web Services account where the configuration was deployed.
         * </p>
         * 
         * @param account
         *        The ID of the Amazon Web Services account where the configuration was deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder account(String account);

        /**
         * <p>
         * The ID of the configuration definition.
         * </p>
         * 
         * @param configurationDefinitionId
         *        The ID of the configuration definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationDefinitionId(String configurationDefinitionId);

        /**
         * <p>
         * The datetime stamp when the configuration manager was created.
         * </p>
         * 
         * @param createdAt
         *        The datetime stamp when the configuration manager was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A service generated identifier for the configuration.
         * </p>
         * 
         * @param id
         *        A service generated identifier for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The datetime stamp when the configuration manager was last updated.
         * </p>
         * 
         * @param lastModifiedAt
         *        The datetime stamp when the configuration manager was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedAt(Instant lastModifiedAt);

        /**
         * <p>
         * The ARN of the configuration manager.
         * </p>
         * 
         * @param managerArn
         *        The ARN of the configuration manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managerArn(String managerArn);

        /**
         * <p>
         * The parameters for the configuration definition type.
         * </p>
         * 
         * @param parameters
         *        The parameters for the configuration definition type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * The Amazon Web Services Region where the configuration was deployed.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region where the configuration was deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * A summary of the state of the configuration manager. This includes deployment statuses, association statuses,
         * drift statuses, health checks, and more.
         * </p>
         * 
         * @param statusSummaries
         *        A summary of the state of the configuration manager. This includes deployment statuses, association
         *        statuses, drift statuses, health checks, and more.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusSummaries(Collection<StatusSummary> statusSummaries);

        /**
         * <p>
         * A summary of the state of the configuration manager. This includes deployment statuses, association statuses,
         * drift statuses, health checks, and more.
         * </p>
         * 
         * @param statusSummaries
         *        A summary of the state of the configuration manager. This includes deployment statuses, association
         *        statuses, drift statuses, health checks, and more.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusSummaries(StatusSummary... statusSummaries);

        /**
         * <p>
         * A summary of the state of the configuration manager. This includes deployment statuses, association statuses,
         * drift statuses, health checks, and more.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.StatusSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ssmquicksetup.model.StatusSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.StatusSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #statusSummaries(List<StatusSummary>)}.
         * 
         * @param statusSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmquicksetup.model.StatusSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusSummaries(java.util.Collection<StatusSummary>)
         */
        Builder statusSummaries(Consumer<StatusSummary.Builder>... statusSummaries);

        /**
         * <p>
         * The type of the Quick Setup configuration.
         * </p>
         * 
         * @param type
         *        The type of the Quick Setup configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The version of the Quick Setup type used.
         * </p>
         * 
         * @param typeVersion
         *        The version of the Quick Setup type used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeVersion(String typeVersion);
    }

    static final class BuilderImpl extends SsmQuickSetupResponse.BuilderImpl implements Builder {
        private String account;

        private String configurationDefinitionId;

        private Instant createdAt;

        private String id;

        private Instant lastModifiedAt;

        private String managerArn;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private String region;

        private List<StatusSummary> statusSummaries = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private String typeVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigurationResponse model) {
            super(model);
            account(model.account);
            configurationDefinitionId(model.configurationDefinitionId);
            createdAt(model.createdAt);
            id(model.id);
            lastModifiedAt(model.lastModifiedAt);
            managerArn(model.managerArn);
            parameters(model.parameters);
            region(model.region);
            statusSummaries(model.statusSummaries);
            type(model.type);
            typeVersion(model.typeVersion);
        }

        public final String getAccount() {
            return account;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final String getConfigurationDefinitionId() {
            return configurationDefinitionId;
        }

        public final void setConfigurationDefinitionId(String configurationDefinitionId) {
            this.configurationDefinitionId = configurationDefinitionId;
        }

        @Override
        public final Builder configurationDefinitionId(String configurationDefinitionId) {
            this.configurationDefinitionId = configurationDefinitionId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getManagerArn() {
            return managerArn;
        }

        public final void setManagerArn(String managerArn) {
            this.managerArn = managerArn;
        }

        @Override
        public final Builder managerArn(String managerArn) {
            this.managerArn = managerArn;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ConfigurationParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ConfigurationParametersMapCopier.copy(parameters);
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final List<StatusSummary.Builder> getStatusSummaries() {
            List<StatusSummary.Builder> result = StatusSummariesListCopier.copyToBuilder(this.statusSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatusSummaries(Collection<StatusSummary.BuilderImpl> statusSummaries) {
            this.statusSummaries = StatusSummariesListCopier.copyFromBuilder(statusSummaries);
        }

        @Override
        public final Builder statusSummaries(Collection<StatusSummary> statusSummaries) {
            this.statusSummaries = StatusSummariesListCopier.copy(statusSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusSummaries(StatusSummary... statusSummaries) {
            statusSummaries(Arrays.asList(statusSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusSummaries(Consumer<StatusSummary.Builder>... statusSummaries) {
            statusSummaries(Stream.of(statusSummaries).map(c -> StatusSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getTypeVersion() {
            return typeVersion;
        }

        public final void setTypeVersion(String typeVersion) {
            this.typeVersion = typeVersion;
        }

        @Override
        public final Builder typeVersion(String typeVersion) {
            this.typeVersion = typeVersion;
            return this;
        }

        @Override
        public GetConfigurationResponse build() {
            return new GetConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
