/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmquicksetup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConfigurationDefinitionRequest extends SsmQuickSetupRequest implements
        ToCopyableBuilder<UpdateConfigurationDefinitionRequest.Builder, UpdateConfigurationDefinitionRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateConfigurationDefinitionRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()).build();

    private static final SdkField<String> LOCAL_DEPLOYMENT_ADMINISTRATION_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalDeploymentAdministrationRoleArn")
            .getter(getter(UpdateConfigurationDefinitionRequest::localDeploymentAdministrationRoleArn))
            .setter(setter(Builder::localDeploymentAdministrationRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LocalDeploymentAdministrationRoleArn").build()).build();

    private static final SdkField<String> LOCAL_DEPLOYMENT_EXECUTION_ROLE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalDeploymentExecutionRoleName")
            .getter(getter(UpdateConfigurationDefinitionRequest::localDeploymentExecutionRoleName))
            .setter(setter(Builder::localDeploymentExecutionRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalDeploymentExecutionRoleName")
                    .build()).build();

    private static final SdkField<String> MANAGER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagerArn").getter(getter(UpdateConfigurationDefinitionRequest::managerArn))
            .setter(setter(Builder::managerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ManagerArn").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(UpdateConfigurationDefinitionRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeVersion").getter(getter(UpdateConfigurationDefinitionRequest::typeVersion))
            .setter(setter(Builder::typeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            LOCAL_DEPLOYMENT_ADMINISTRATION_ROLE_ARN_FIELD, LOCAL_DEPLOYMENT_EXECUTION_ROLE_NAME_FIELD, MANAGER_ARN_FIELD,
            PARAMETERS_FIELD, TYPE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String localDeploymentAdministrationRoleArn;

    private final String localDeploymentExecutionRoleName;

    private final String managerArn;

    private final Map<String, String> parameters;

    private final String typeVersion;

    private UpdateConfigurationDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.localDeploymentAdministrationRoleArn = builder.localDeploymentAdministrationRoleArn;
        this.localDeploymentExecutionRoleName = builder.localDeploymentExecutionRoleName;
        this.managerArn = builder.managerArn;
        this.parameters = builder.parameters;
        this.typeVersion = builder.typeVersion;
    }

    /**
     * <p>
     * The ID of the configuration definition you want to update.
     * </p>
     * 
     * @return The ID of the configuration definition you want to update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN of the IAM role used to administrate local configuration deployments.
     * </p>
     * 
     * @return The ARN of the IAM role used to administrate local configuration deployments.
     */
    public final String localDeploymentAdministrationRoleArn() {
        return localDeploymentAdministrationRoleArn;
    }

    /**
     * <p>
     * The name of the IAM role used to deploy local configurations.
     * </p>
     * 
     * @return The name of the IAM role used to deploy local configurations.
     */
    public final String localDeploymentExecutionRoleName() {
        return localDeploymentExecutionRoleName;
    }

    /**
     * <p>
     * The ARN of the configuration manager associated with the definition to update.
     * </p>
     * 
     * @return The ARN of the configuration manager associated with the definition to update.
     */
    public final String managerArn() {
        return managerArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The parameters for the configuration definition type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The parameters for the configuration definition type.
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The version of the Quick Setup type to use.
     * </p>
     * 
     * @return The version of the Quick Setup type to use.
     */
    public final String typeVersion() {
        return typeVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(localDeploymentAdministrationRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(localDeploymentExecutionRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(managerArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationDefinitionRequest)) {
            return false;
        }
        UpdateConfigurationDefinitionRequest other = (UpdateConfigurationDefinitionRequest) obj;
        return Objects.equals(id(), other.id())
                && Objects.equals(localDeploymentAdministrationRoleArn(), other.localDeploymentAdministrationRoleArn())
                && Objects.equals(localDeploymentExecutionRoleName(), other.localDeploymentExecutionRoleName())
                && Objects.equals(managerArn(), other.managerArn()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(typeVersion(), other.typeVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConfigurationDefinitionRequest").add("Id", id())
                .add("LocalDeploymentAdministrationRoleArn", localDeploymentAdministrationRoleArn())
                .add("LocalDeploymentExecutionRoleName", localDeploymentExecutionRoleName()).add("ManagerArn", managerArn())
                .add("Parameters", hasParameters() ? parameters() : null).add("TypeVersion", typeVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LocalDeploymentAdministrationRoleArn":
            return Optional.ofNullable(clazz.cast(localDeploymentAdministrationRoleArn()));
        case "LocalDeploymentExecutionRoleName":
            return Optional.ofNullable(clazz.cast(localDeploymentExecutionRoleName()));
        case "ManagerArn":
            return Optional.ofNullable(clazz.cast(managerArn()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "TypeVersion":
            return Optional.ofNullable(clazz.cast(typeVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("LocalDeploymentAdministrationRoleArn", LOCAL_DEPLOYMENT_ADMINISTRATION_ROLE_ARN_FIELD);
        map.put("LocalDeploymentExecutionRoleName", LOCAL_DEPLOYMENT_EXECUTION_ROLE_NAME_FIELD);
        map.put("ManagerArn", MANAGER_ARN_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("TypeVersion", TYPE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfigurationDefinitionRequest, T> g) {
        return obj -> g.apply((UpdateConfigurationDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmQuickSetupRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateConfigurationDefinitionRequest> {
        /**
         * <p>
         * The ID of the configuration definition you want to update.
         * </p>
         * 
         * @param id
         *        The ID of the configuration definition you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN of the IAM role used to administrate local configuration deployments.
         * </p>
         * 
         * @param localDeploymentAdministrationRoleArn
         *        The ARN of the IAM role used to administrate local configuration deployments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localDeploymentAdministrationRoleArn(String localDeploymentAdministrationRoleArn);

        /**
         * <p>
         * The name of the IAM role used to deploy local configurations.
         * </p>
         * 
         * @param localDeploymentExecutionRoleName
         *        The name of the IAM role used to deploy local configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localDeploymentExecutionRoleName(String localDeploymentExecutionRoleName);

        /**
         * <p>
         * The ARN of the configuration manager associated with the definition to update.
         * </p>
         * 
         * @param managerArn
         *        The ARN of the configuration manager associated with the definition to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managerArn(String managerArn);

        /**
         * <p>
         * The parameters for the configuration definition type.
         * </p>
         * 
         * @param parameters
         *        The parameters for the configuration definition type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * The version of the Quick Setup type to use.
         * </p>
         * 
         * @param typeVersion
         *        The version of the Quick Setup type to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeVersion(String typeVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmQuickSetupRequest.BuilderImpl implements Builder {
        private String id;

        private String localDeploymentAdministrationRoleArn;

        private String localDeploymentExecutionRoleName;

        private String managerArn;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private String typeVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationDefinitionRequest model) {
            super(model);
            id(model.id);
            localDeploymentAdministrationRoleArn(model.localDeploymentAdministrationRoleArn);
            localDeploymentExecutionRoleName(model.localDeploymentExecutionRoleName);
            managerArn(model.managerArn);
            parameters(model.parameters);
            typeVersion(model.typeVersion);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLocalDeploymentAdministrationRoleArn() {
            return localDeploymentAdministrationRoleArn;
        }

        public final void setLocalDeploymentAdministrationRoleArn(String localDeploymentAdministrationRoleArn) {
            this.localDeploymentAdministrationRoleArn = localDeploymentAdministrationRoleArn;
        }

        @Override
        public final Builder localDeploymentAdministrationRoleArn(String localDeploymentAdministrationRoleArn) {
            this.localDeploymentAdministrationRoleArn = localDeploymentAdministrationRoleArn;
            return this;
        }

        public final String getLocalDeploymentExecutionRoleName() {
            return localDeploymentExecutionRoleName;
        }

        public final void setLocalDeploymentExecutionRoleName(String localDeploymentExecutionRoleName) {
            this.localDeploymentExecutionRoleName = localDeploymentExecutionRoleName;
        }

        @Override
        public final Builder localDeploymentExecutionRoleName(String localDeploymentExecutionRoleName) {
            this.localDeploymentExecutionRoleName = localDeploymentExecutionRoleName;
            return this;
        }

        public final String getManagerArn() {
            return managerArn;
        }

        public final void setManagerArn(String managerArn) {
            this.managerArn = managerArn;
        }

        @Override
        public final Builder managerArn(String managerArn) {
            this.managerArn = managerArn;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ConfigurationParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ConfigurationParametersMapCopier.copy(parameters);
            return this;
        }

        public final String getTypeVersion() {
            return typeVersion;
        }

        public final void setTypeVersion(String typeVersion) {
            this.typeVersion = typeVersion;
        }

        @Override
        public final Builder typeVersion(String typeVersion) {
            this.typeVersion = typeVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfigurationDefinitionRequest build() {
            return new UpdateConfigurationDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
