/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmquicksetup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationParametersMapCopier;
import software.amazon.awssdk.services.ssmquicksetup.model.SsmQuickSetupResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.StatusSummariesListCopier;
import software.amazon.awssdk.services.ssmquicksetup.model.StatusSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConfigurationResponse
extends SsmQuickSetupResponse
implements ToCopyableBuilder<Builder, GetConfigurationResponse> {
    private static final SdkField<String> ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Account").getter(GetConfigurationResponse.getter(GetConfigurationResponse::account)).setter(GetConfigurationResponse.setter(Builder::account)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Account").build()}).build();
    private static final SdkField<String> CONFIGURATION_DEFINITION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationDefinitionId").getter(GetConfigurationResponse.getter(GetConfigurationResponse::configurationDefinitionId)).setter(GetConfigurationResponse.setter(Builder::configurationDefinitionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationDefinitionId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetConfigurationResponse.getter(GetConfigurationResponse::createdAt)).setter(GetConfigurationResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetConfigurationResponse.getter(GetConfigurationResponse::id)).setter(GetConfigurationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedAt").getter(GetConfigurationResponse.getter(GetConfigurationResponse::lastModifiedAt)).setter(GetConfigurationResponse.setter(Builder::lastModifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> MANAGER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagerArn").getter(GetConfigurationResponse.getter(GetConfigurationResponse::managerArn)).setter(GetConfigurationResponse.setter(Builder::managerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagerArn").build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(GetConfigurationResponse.getter(GetConfigurationResponse::parameters)).setter(GetConfigurationResponse.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(GetConfigurationResponse.getter(GetConfigurationResponse::region)).setter(GetConfigurationResponse.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<List<StatusSummary>> STATUS_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatusSummaries").getter(GetConfigurationResponse.getter(GetConfigurationResponse::statusSummaries)).setter(GetConfigurationResponse.setter(Builder::statusSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StatusSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(GetConfigurationResponse.getter(GetConfigurationResponse::type)).setter(GetConfigurationResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> TYPE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeVersion").getter(GetConfigurationResponse.getter(GetConfigurationResponse::typeVersion)).setter(GetConfigurationResponse.setter(Builder::typeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_FIELD, CONFIGURATION_DEFINITION_ID_FIELD, CREATED_AT_FIELD, ID_FIELD, LAST_MODIFIED_AT_FIELD, MANAGER_ARN_FIELD, PARAMETERS_FIELD, REGION_FIELD, STATUS_SUMMARIES_FIELD, TYPE_FIELD, TYPE_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetConfigurationResponse.memberNameToFieldInitializer();
    private final String account;
    private final String configurationDefinitionId;
    private final Instant createdAt;
    private final String id;
    private final Instant lastModifiedAt;
    private final String managerArn;
    private final Map<String, String> parameters;
    private final String region;
    private final List<StatusSummary> statusSummaries;
    private final String type;
    private final String typeVersion;

    private GetConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.account = builder.account;
        this.configurationDefinitionId = builder.configurationDefinitionId;
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.managerArn = builder.managerArn;
        this.parameters = builder.parameters;
        this.region = builder.region;
        this.statusSummaries = builder.statusSummaries;
        this.type = builder.type;
        this.typeVersion = builder.typeVersion;
    }

    public final String account() {
        return this.account;
    }

    public final String configurationDefinitionId() {
        return this.configurationDefinitionId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastModifiedAt() {
        return this.lastModifiedAt;
    }

    public final String managerArn() {
        return this.managerArn;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public final String region() {
        return this.region;
    }

    public final boolean hasStatusSummaries() {
        return this.statusSummaries != null && !(this.statusSummaries instanceof SdkAutoConstructList);
    }

    public final List<StatusSummary> statusSummaries() {
        return this.statusSummaries;
    }

    public final String type() {
        return this.type;
    }

    public final String typeVersion() {
        return this.typeVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.account());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.managerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusSummaries() ? this.statusSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigurationResponse)) {
            return false;
        }
        GetConfigurationResponse other = (GetConfigurationResponse)((Object)obj);
        return Objects.equals(this.account(), other.account()) && Objects.equals(this.configurationDefinitionId(), other.configurationDefinitionId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(this.managerArn(), other.managerArn()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.region(), other.region()) && this.hasStatusSummaries() == other.hasStatusSummaries() && Objects.equals(this.statusSummaries(), other.statusSummaries()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.typeVersion(), other.typeVersion());
    }

    public final String toString() {
        return ToString.builder((String)"GetConfigurationResponse").add("Account", (Object)this.account()).add("ConfigurationDefinitionId", (Object)this.configurationDefinitionId()).add("CreatedAt", (Object)this.createdAt()).add("Id", (Object)this.id()).add("LastModifiedAt", (Object)this.lastModifiedAt()).add("ManagerArn", (Object)this.managerArn()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("Region", (Object)this.region()).add("StatusSummaries", this.hasStatusSummaries() ? this.statusSummaries() : null).add("Type", (Object)this.type()).add("TypeVersion", (Object)this.typeVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Account": {
                return Optional.ofNullable(clazz.cast(this.account()));
            }
            case "ConfigurationDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.configurationDefinitionId()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "LastModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedAt()));
            }
            case "ManagerArn": {
                return Optional.ofNullable(clazz.cast(this.managerArn()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "StatusSummaries": {
                return Optional.ofNullable(clazz.cast(this.statusSummaries()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "TypeVersion": {
                return Optional.ofNullable(clazz.cast(this.typeVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Account", ACCOUNT_FIELD);
        map.put("ConfigurationDefinitionId", CONFIGURATION_DEFINITION_ID_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("Id", ID_FIELD);
        map.put("LastModifiedAt", LAST_MODIFIED_AT_FIELD);
        map.put("ManagerArn", MANAGER_ARN_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("StatusSummaries", STATUS_SUMMARIES_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("TypeVersion", TYPE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConfigurationResponse, T> g) {
        return obj -> g.apply((GetConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmQuickSetupResponse.BuilderImpl
    implements Builder {
        private String account;
        private String configurationDefinitionId;
        private Instant createdAt;
        private String id;
        private Instant lastModifiedAt;
        private String managerArn;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String region;
        private List<StatusSummary> statusSummaries = DefaultSdkAutoConstructList.getInstance();
        private String type;
        private String typeVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigurationResponse model) {
            super(model);
            this.account(model.account);
            this.configurationDefinitionId(model.configurationDefinitionId);
            this.createdAt(model.createdAt);
            this.id(model.id);
            this.lastModifiedAt(model.lastModifiedAt);
            this.managerArn(model.managerArn);
            this.parameters(model.parameters);
            this.region(model.region);
            this.statusSummaries(model.statusSummaries);
            this.type(model.type);
            this.typeVersion(model.typeVersion);
        }

        public final String getAccount() {
            return this.account;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final String getConfigurationDefinitionId() {
            return this.configurationDefinitionId;
        }

        public final void setConfigurationDefinitionId(String configurationDefinitionId) {
            this.configurationDefinitionId = configurationDefinitionId;
        }

        @Override
        public final Builder configurationDefinitionId(String configurationDefinitionId) {
            this.configurationDefinitionId = configurationDefinitionId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getManagerArn() {
            return this.managerArn;
        }

        public final void setManagerArn(String managerArn) {
            this.managerArn = managerArn;
        }

        @Override
        public final Builder managerArn(String managerArn) {
            this.managerArn = managerArn;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ConfigurationParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ConfigurationParametersMapCopier.copy(parameters);
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final List<StatusSummary.Builder> getStatusSummaries() {
            List<StatusSummary.Builder> result = StatusSummariesListCopier.copyToBuilder(this.statusSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatusSummaries(Collection<StatusSummary.BuilderImpl> statusSummaries) {
            this.statusSummaries = StatusSummariesListCopier.copyFromBuilder(statusSummaries);
        }

        @Override
        public final Builder statusSummaries(Collection<StatusSummary> statusSummaries) {
            this.statusSummaries = StatusSummariesListCopier.copy(statusSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusSummaries(StatusSummary ... statusSummaries) {
            this.statusSummaries(Arrays.asList(statusSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusSummaries(Consumer<StatusSummary.Builder> ... statusSummaries) {
            this.statusSummaries(Stream.of(statusSummaries).map(c -> (StatusSummary)((StatusSummary.Builder)StatusSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getTypeVersion() {
            return this.typeVersion;
        }

        public final void setTypeVersion(String typeVersion) {
            this.typeVersion = typeVersion;
        }

        @Override
        public final Builder typeVersion(String typeVersion) {
            this.typeVersion = typeVersion;
            return this;
        }

        @Override
        public GetConfigurationResponse build() {
            return new GetConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmQuickSetupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConfigurationResponse> {
        public Builder account(String var1);

        public Builder configurationDefinitionId(String var1);

        public Builder createdAt(Instant var1);

        public Builder id(String var1);

        public Builder lastModifiedAt(Instant var1);

        public Builder managerArn(String var1);

        public Builder parameters(Map<String, String> var1);

        public Builder region(String var1);

        public Builder statusSummaries(Collection<StatusSummary> var1);

        public Builder statusSummaries(StatusSummary ... var1);

        public Builder statusSummaries(Consumer<StatusSummary.Builder> ... var1);

        public Builder type(String var1);

        public Builder typeVersion(String var1);
    }
}

