/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmquicksetup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmquicksetup.SsmQuickSetupAsyncClient;
import software.amazon.awssdk.services.ssmquicksetup.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationManagerSummary;
import software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersResponse;

public class ListConfigurationManagersPublisher
implements SdkPublisher<ListConfigurationManagersResponse> {
    private final SsmQuickSetupAsyncClient client;
    private final ListConfigurationManagersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConfigurationManagersPublisher(SsmQuickSetupAsyncClient client, ListConfigurationManagersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConfigurationManagersPublisher(SsmQuickSetupAsyncClient client, ListConfigurationManagersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConfigurationManagersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConfigurationManagersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConfigurationManagerSummary> configurationManagersList() {
        Function<ListConfigurationManagersResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurationManagersList() != null) {
                return response.configurationManagersList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListConfigurationManagersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListConfigurationManagersResponseFetcher
    implements AsyncPageFetcher<ListConfigurationManagersResponse> {
        private ListConfigurationManagersResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigurationManagersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConfigurationManagersResponse> nextPage(ListConfigurationManagersResponse previousPage) {
            if (previousPage == null) {
                return ListConfigurationManagersPublisher.this.client.listConfigurationManagers(ListConfigurationManagersPublisher.this.firstRequest);
            }
            return ListConfigurationManagersPublisher.this.client.listConfigurationManagers((ListConfigurationManagersRequest)((Object)ListConfigurationManagersPublisher.this.firstRequest.toBuilder().startingToken(previousPage.nextToken()).build()));
        }
    }
}

