/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmquicksetup;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.ssmquicksetup.model.CreateConfigurationManagerRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.CreateConfigurationManagerResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.DeleteConfigurationManagerRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.DeleteConfigurationManagerResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.GetConfigurationManagerRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.GetConfigurationManagerResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.GetConfigurationRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.GetConfigurationResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.GetServiceSettingsRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.GetServiceSettingsResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationsRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationsResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.ListQuickSetupTypesRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.ListQuickSetupTypesResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.TagResourceRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.TagResourceResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.UntagResourceRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.UntagResourceResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.UpdateConfigurationDefinitionRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.UpdateConfigurationDefinitionResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.UpdateConfigurationManagerRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.UpdateConfigurationManagerResponse;
import software.amazon.awssdk.services.ssmquicksetup.model.UpdateServiceSettingsRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.UpdateServiceSettingsResponse;
import software.amazon.awssdk.services.ssmquicksetup.paginators.ListConfigurationManagersPublisher;
import software.amazon.awssdk.services.ssmquicksetup.paginators.ListConfigurationsPublisher;

/**
 * Service client for accessing AWS Systems Manager QuickSetup asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Quick Setup helps you quickly configure frequently used services and features with recommended best practices. Quick
 * Setup simplifies setting up services, including Systems Manager, by automating common or recommended tasks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SsmQuickSetupAsyncClient extends AwsClient {
    String SERVICE_NAME = "ssm-quicksetup";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "ssm-quicksetup";

    /**
     * <p>
     * Creates a Quick Setup configuration manager resource. This object is a collection of desired state configurations
     * for multiple configuration definitions and summaries describing the deployments of those definitions.
     * </p>
     *
     * @param createConfigurationManagerRequest
     * @return A Java Future containing the result of the CreateConfigurationManager operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.CreateConfigurationManager
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/CreateConfigurationManager"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfigurationManagerResponse> createConfigurationManager(
            CreateConfigurationManagerRequest createConfigurationManagerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Quick Setup configuration manager resource. This object is a collection of desired state configurations
     * for multiple configuration definitions and summaries describing the deployments of those definitions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfigurationManagerRequest.Builder} avoiding
     * the need to create one manually via {@link CreateConfigurationManagerRequest#builder()}
     * </p>
     *
     * @param createConfigurationManagerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.CreateConfigurationManagerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateConfigurationManager operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.CreateConfigurationManager
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/CreateConfigurationManager"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfigurationManagerResponse> createConfigurationManager(
            Consumer<CreateConfigurationManagerRequest.Builder> createConfigurationManagerRequest) {
        return createConfigurationManager(CreateConfigurationManagerRequest.builder()
                .applyMutation(createConfigurationManagerRequest).build());
    }

    /**
     * <p>
     * Deletes a configuration manager.
     * </p>
     *
     * @param deleteConfigurationManagerRequest
     * @return A Java Future containing the result of the DeleteConfigurationManager operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found. Check the ID or name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.DeleteConfigurationManager
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/DeleteConfigurationManager"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationManagerResponse> deleteConfigurationManager(
            DeleteConfigurationManagerRequest deleteConfigurationManagerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a configuration manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigurationManagerRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteConfigurationManagerRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationManagerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.DeleteConfigurationManagerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteConfigurationManager operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found. Check the ID or name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.DeleteConfigurationManager
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/DeleteConfigurationManager"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationManagerResponse> deleteConfigurationManager(
            Consumer<DeleteConfigurationManagerRequest.Builder> deleteConfigurationManagerRequest) {
        return deleteConfigurationManager(DeleteConfigurationManagerRequest.builder()
                .applyMutation(deleteConfigurationManagerRequest).build());
    }

    /**
     * <p>
     * Returns details about the specified configuration.
     * </p>
     *
     * @param getConfigurationRequest
     * @return A Java Future containing the result of the GetConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found. Check the ID or name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.GetConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/GetConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfigurationResponse> getConfiguration(GetConfigurationRequest getConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about the specified configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfigurationRequest.Builder} avoiding the need
     * to create one manually via {@link GetConfigurationRequest#builder()}
     * </p>
     *
     * @param getConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.GetConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found. Check the ID or name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.GetConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/GetConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfigurationResponse> getConfiguration(
            Consumer<GetConfigurationRequest.Builder> getConfigurationRequest) {
        return getConfiguration(GetConfigurationRequest.builder().applyMutation(getConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns a configuration manager.
     * </p>
     *
     * @param getConfigurationManagerRequest
     * @return A Java Future containing the result of the GetConfigurationManager operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found. Check the ID or name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.GetConfigurationManager
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/GetConfigurationManager"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfigurationManagerResponse> getConfigurationManager(
            GetConfigurationManagerRequest getConfigurationManagerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a configuration manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfigurationManagerRequest.Builder} avoiding
     * the need to create one manually via {@link GetConfigurationManagerRequest#builder()}
     * </p>
     *
     * @param getConfigurationManagerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.GetConfigurationManagerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetConfigurationManager operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found. Check the ID or name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.GetConfigurationManager
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/GetConfigurationManager"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfigurationManagerResponse> getConfigurationManager(
            Consumer<GetConfigurationManagerRequest.Builder> getConfigurationManagerRequest) {
        return getConfigurationManager(GetConfigurationManagerRequest.builder().applyMutation(getConfigurationManagerRequest)
                .build());
    }

    /**
     * <p>
     * Returns settings configured for Quick Setup in the requesting Amazon Web Services account and Amazon Web Services
     * Region.
     * </p>
     *
     * @param getServiceSettingsRequest
     * @return A Java Future containing the result of the GetServiceSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.GetServiceSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/GetServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceSettingsResponse> getServiceSettings(GetServiceSettingsRequest getServiceSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns settings configured for Quick Setup in the requesting Amazon Web Services account and Amazon Web Services
     * Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetServiceSettingsRequest#builder()}
     * </p>
     *
     * @param getServiceSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.GetServiceSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetServiceSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.GetServiceSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/GetServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceSettingsResponse> getServiceSettings(
            Consumer<GetServiceSettingsRequest.Builder> getServiceSettingsRequest) {
        return getServiceSettings(GetServiceSettingsRequest.builder().applyMutation(getServiceSettingsRequest).build());
    }

    /**
     * <p>
     * Returns Quick Setup configuration managers.
     * </p>
     *
     * @param listConfigurationManagersRequest
     * @return A Java Future containing the result of the ListConfigurationManagers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.ListConfigurationManagers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/ListConfigurationManagers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConfigurationManagersResponse> listConfigurationManagers(
            ListConfigurationManagersRequest listConfigurationManagersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns Quick Setup configuration managers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationManagersRequest.Builder} avoiding
     * the need to create one manually via {@link ListConfigurationManagersRequest#builder()}
     * </p>
     *
     * @param listConfigurationManagersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListConfigurationManagers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.ListConfigurationManagers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/ListConfigurationManagers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConfigurationManagersResponse> listConfigurationManagers(
            Consumer<ListConfigurationManagersRequest.Builder> listConfigurationManagersRequest) {
        return listConfigurationManagers(ListConfigurationManagersRequest.builder()
                .applyMutation(listConfigurationManagersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurationManagers(software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmquicksetup.paginators.ListConfigurationManagersPublisher publisher = client.listConfigurationManagersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmquicksetup.paginators.ListConfigurationManagersPublisher publisher = client.listConfigurationManagersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationManagers(software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfigurationManagersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.ListConfigurationManagers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/ListConfigurationManagers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationManagersPublisher listConfigurationManagersPaginator(
            ListConfigurationManagersRequest listConfigurationManagersRequest) {
        return new ListConfigurationManagersPublisher(this, listConfigurationManagersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurationManagers(software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmquicksetup.paginators.ListConfigurationManagersPublisher publisher = client.listConfigurationManagersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmquicksetup.paginators.ListConfigurationManagersPublisher publisher = client.listConfigurationManagersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationManagers(software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationManagersRequest.Builder} avoiding
     * the need to create one manually via {@link ListConfigurationManagersRequest#builder()}
     * </p>
     *
     * @param listConfigurationManagersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationManagersRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.ListConfigurationManagers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/ListConfigurationManagers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationManagersPublisher listConfigurationManagersPaginator(
            Consumer<ListConfigurationManagersRequest.Builder> listConfigurationManagersRequest) {
        return listConfigurationManagersPaginator(ListConfigurationManagersRequest.builder()
                .applyMutation(listConfigurationManagersRequest).build());
    }

    /**
     * <p>
     * Returns configurations deployed by Quick Setup in the requesting Amazon Web Services account and Amazon Web
     * Services Region.
     * </p>
     *
     * @param listConfigurationsRequest
     * @return A Java Future containing the result of the ListConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found. Check the ID or name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.ListConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/ListConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConfigurationsResponse> listConfigurations(ListConfigurationsRequest listConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns configurations deployed by Quick Setup in the requesting Amazon Web Services account and Amazon Web
     * Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListConfigurationsRequest#builder()}
     * </p>
     *
     * @param listConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found. Check the ID or name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.ListConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/ListConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConfigurationsResponse> listConfigurations(
            Consumer<ListConfigurationsRequest.Builder> listConfigurationsRequest) {
        return listConfigurations(ListConfigurationsRequest.builder().applyMutation(listConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurations(software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmquicksetup.paginators.ListConfigurationsPublisher publisher = client.listConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmquicksetup.paginators.ListConfigurationsPublisher publisher = client.listConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurations(software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found. Check the ID or name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.ListConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/ListConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationsPublisher listConfigurationsPaginator(ListConfigurationsRequest listConfigurationsRequest) {
        return new ListConfigurationsPublisher(this, listConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurations(software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmquicksetup.paginators.ListConfigurationsPublisher publisher = client.listConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmquicksetup.paginators.ListConfigurationsPublisher publisher = client.listConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurations(software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListConfigurationsRequest#builder()}
     * </p>
     *
     * @param listConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found. Check the ID or name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.ListConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/ListConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationsPublisher listConfigurationsPaginator(
            Consumer<ListConfigurationsRequest.Builder> listConfigurationsRequest) {
        return listConfigurationsPaginator(ListConfigurationsRequest.builder().applyMutation(listConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns the available Quick Setup types.
     * </p>
     *
     * @param listQuickSetupTypesRequest
     * @return A Java Future containing the result of the ListQuickSetupTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.ListQuickSetupTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/ListQuickSetupTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListQuickSetupTypesResponse> listQuickSetupTypes(
            ListQuickSetupTypesRequest listQuickSetupTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the available Quick Setup types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQuickSetupTypesRequest.Builder} avoiding the
     * need to create one manually via {@link ListQuickSetupTypesRequest#builder()}
     * </p>
     *
     * @param listQuickSetupTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.ListQuickSetupTypesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListQuickSetupTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.ListQuickSetupTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/ListQuickSetupTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListQuickSetupTypesResponse> listQuickSetupTypes(
            Consumer<ListQuickSetupTypesRequest.Builder> listQuickSetupTypesRequest) {
        return listQuickSetupTypes(ListQuickSetupTypesRequest.builder().applyMutation(listQuickSetupTypesRequest).build());
    }

    /**
     * <p>
     * Returns tags assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found. Check the ID or name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns tags assigned to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found. Check the ID or name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Assigns key-value pairs of metadata to Amazon Web Services resources.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found. Check the ID or name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns key-value pairs of metadata to Amazon Web Services resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found. Check the ID or name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found. Check the ID or name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found. Check the ID or name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a Quick Setup configuration definition.
     * </p>
     *
     * @param updateConfigurationDefinitionRequest
     * @return A Java Future containing the result of the UpdateConfigurationDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found. Check the ID or name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.UpdateConfigurationDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/UpdateConfigurationDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationDefinitionResponse> updateConfigurationDefinition(
            UpdateConfigurationDefinitionRequest updateConfigurationDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Quick Setup configuration definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfigurationDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateConfigurationDefinitionRequest#builder()}
     * </p>
     *
     * @param updateConfigurationDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.UpdateConfigurationDefinitionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateConfigurationDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found. Check the ID or name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.UpdateConfigurationDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/UpdateConfigurationDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationDefinitionResponse> updateConfigurationDefinition(
            Consumer<UpdateConfigurationDefinitionRequest.Builder> updateConfigurationDefinitionRequest) {
        return updateConfigurationDefinition(UpdateConfigurationDefinitionRequest.builder()
                .applyMutation(updateConfigurationDefinitionRequest).build());
    }

    /**
     * <p>
     * Updates a Quick Setup configuration manager.
     * </p>
     *
     * @param updateConfigurationManagerRequest
     * @return A Java Future containing the result of the UpdateConfigurationManager operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found. Check the ID or name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.UpdateConfigurationManager
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/UpdateConfigurationManager"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationManagerResponse> updateConfigurationManager(
            UpdateConfigurationManagerRequest updateConfigurationManagerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Quick Setup configuration manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfigurationManagerRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateConfigurationManagerRequest#builder()}
     * </p>
     *
     * @param updateConfigurationManagerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.UpdateConfigurationManagerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateConfigurationManager operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found. Check the ID or name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.UpdateConfigurationManager
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/UpdateConfigurationManager"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationManagerResponse> updateConfigurationManager(
            Consumer<UpdateConfigurationManagerRequest.Builder> updateConfigurationManagerRequest) {
        return updateConfigurationManager(UpdateConfigurationManagerRequest.builder()
                .applyMutation(updateConfigurationManagerRequest).build());
    }

    /**
     * <p>
     * Updates settings configured for Quick Setup.
     * </p>
     *
     * @param updateServiceSettingsRequest
     * @return A Java Future containing the result of the UpdateServiceSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.UpdateServiceSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/UpdateServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServiceSettingsResponse> updateServiceSettings(
            UpdateServiceSettingsRequest updateServiceSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates settings configured for Quick Setup.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateServiceSettingsRequest#builder()}
     * </p>
     *
     * @param updateServiceSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmquicksetup.model.UpdateServiceSettingsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateServiceSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request is invalid. Verify the values provided for the request parameters are
     *         accurate.</li>
     *         <li>ConflictException Another request is being processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerException An error occurred on the server side.</li>
     *         <li>AccessDeniedException The requester has insufficient permissions to perform the operation.</li>
     *         <li>ThrottlingException The request or operation exceeds the maximum allowed request rate per Amazon Web
     *         Services account and Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmQuickSetupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmQuickSetupAsyncClient.UpdateServiceSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-quicksetup-2018-05-10/UpdateServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServiceSettingsResponse> updateServiceSettings(
            Consumer<UpdateServiceSettingsRequest.Builder> updateServiceSettingsRequest) {
        return updateServiceSettings(UpdateServiceSettingsRequest.builder().applyMutation(updateServiceSettingsRequest).build());
    }

    @Override
    default SsmQuickSetupServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link SsmQuickSetupAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SsmQuickSetupAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SsmQuickSetupAsyncClient}.
     */
    static SsmQuickSetupAsyncClientBuilder builder() {
        return new DefaultSsmQuickSetupAsyncClientBuilder();
    }
}
