/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmquicksetup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConfigurationManagerRequest extends SsmQuickSetupRequest implements
        ToCopyableBuilder<CreateConfigurationManagerRequest.Builder, CreateConfigurationManagerRequest> {
    private static final SdkField<List<ConfigurationDefinitionInput>> CONFIGURATION_DEFINITIONS_FIELD = SdkField
            .<List<ConfigurationDefinitionInput>> builder(MarshallingType.LIST)
            .memberName("ConfigurationDefinitions")
            .getter(getter(CreateConfigurationManagerRequest::configurationDefinitions))
            .setter(setter(Builder::configurationDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationDefinitionInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationDefinitionInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateConfigurationManagerRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateConfigurationManagerRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateConfigurationManagerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_DEFINITIONS_FIELD, DESCRIPTION_FIELD, NAME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ConfigurationDefinitionInput> configurationDefinitions;

    private final String description;

    private final String name;

    private final Map<String, String> tags;

    private CreateConfigurationManagerRequest(BuilderImpl builder) {
        super(builder);
        this.configurationDefinitions = builder.configurationDefinitions;
        this.description = builder.description;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfigurationDefinitions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConfigurationDefinitions() {
        return configurationDefinitions != null && !(configurationDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The definition of the Quick Setup configuration that the configuration manager deploys.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurationDefinitions} method.
     * </p>
     * 
     * @return The definition of the Quick Setup configuration that the configuration manager deploys.
     */
    public final List<ConfigurationDefinitionInput> configurationDefinitions() {
        return configurationDefinitions;
    }

    /**
     * <p>
     * A description of the configuration manager.
     * </p>
     * 
     * @return A description of the configuration manager.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A name for the configuration manager.
     * </p>
     * 
     * @return A name for the configuration manager.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Key-value pairs of metadata to assign to the configuration manager.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Key-value pairs of metadata to assign to the configuration manager.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurationDefinitions() ? configurationDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationManagerRequest)) {
            return false;
        }
        CreateConfigurationManagerRequest other = (CreateConfigurationManagerRequest) obj;
        return hasConfigurationDefinitions() == other.hasConfigurationDefinitions()
                && Objects.equals(configurationDefinitions(), other.configurationDefinitions())
                && Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConfigurationManagerRequest")
                .add("ConfigurationDefinitions", hasConfigurationDefinitions() ? configurationDefinitions() : null)
                .add("Description", description()).add("Name", name())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationDefinitions":
            return Optional.ofNullable(clazz.cast(configurationDefinitions()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationDefinitions", CONFIGURATION_DEFINITIONS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConfigurationManagerRequest, T> g) {
        return obj -> g.apply((CreateConfigurationManagerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsmQuickSetupRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateConfigurationManagerRequest> {
        /**
         * <p>
         * The definition of the Quick Setup configuration that the configuration manager deploys.
         * </p>
         * 
         * @param configurationDefinitions
         *        The definition of the Quick Setup configuration that the configuration manager deploys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationDefinitions(Collection<ConfigurationDefinitionInput> configurationDefinitions);

        /**
         * <p>
         * The definition of the Quick Setup configuration that the configuration manager deploys.
         * </p>
         * 
         * @param configurationDefinitions
         *        The definition of the Quick Setup configuration that the configuration manager deploys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationDefinitions(ConfigurationDefinitionInput... configurationDefinitions);

        /**
         * <p>
         * The definition of the Quick Setup configuration that the configuration manager deploys.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationDefinitionInput.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationDefinitionInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationDefinitionInput.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #configurationDefinitions(List<ConfigurationDefinitionInput>)}.
         * 
         * @param configurationDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationDefinitionInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationDefinitions(java.util.Collection<ConfigurationDefinitionInput>)
         */
        Builder configurationDefinitions(Consumer<ConfigurationDefinitionInput.Builder>... configurationDefinitions);

        /**
         * <p>
         * A description of the configuration manager.
         * </p>
         * 
         * @param description
         *        A description of the configuration manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A name for the configuration manager.
         * </p>
         * 
         * @param name
         *        A name for the configuration manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Key-value pairs of metadata to assign to the configuration manager.
         * </p>
         * 
         * @param tags
         *        Key-value pairs of metadata to assign to the configuration manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmQuickSetupRequest.BuilderImpl implements Builder {
        private List<ConfigurationDefinitionInput> configurationDefinitions = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationManagerRequest model) {
            super(model);
            configurationDefinitions(model.configurationDefinitions);
            description(model.description);
            name(model.name);
            tags(model.tags);
        }

        public final List<ConfigurationDefinitionInput.Builder> getConfigurationDefinitions() {
            List<ConfigurationDefinitionInput.Builder> result = ConfigurationDefinitionsInputListCopier
                    .copyToBuilder(this.configurationDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationDefinitions(
                Collection<ConfigurationDefinitionInput.BuilderImpl> configurationDefinitions) {
            this.configurationDefinitions = ConfigurationDefinitionsInputListCopier.copyFromBuilder(configurationDefinitions);
        }

        @Override
        public final Builder configurationDefinitions(Collection<ConfigurationDefinitionInput> configurationDefinitions) {
            this.configurationDefinitions = ConfigurationDefinitionsInputListCopier.copy(configurationDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationDefinitions(ConfigurationDefinitionInput... configurationDefinitions) {
            configurationDefinitions(Arrays.asList(configurationDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationDefinitions(Consumer<ConfigurationDefinitionInput.Builder>... configurationDefinitions) {
            configurationDefinitions(Stream.of(configurationDefinitions)
                    .map(c -> ConfigurationDefinitionInput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfigurationManagerRequest build() {
            return new CreateConfigurationManagerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
