/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmquicksetup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceSettingsResponse extends SsmQuickSetupResponse implements
        ToCopyableBuilder<GetServiceSettingsResponse.Builder, GetServiceSettingsResponse> {
    private static final SdkField<ServiceSettings> SERVICE_SETTINGS_FIELD = SdkField
            .<ServiceSettings> builder(MarshallingType.SDK_POJO).memberName("ServiceSettings")
            .getter(getter(GetServiceSettingsResponse::serviceSettings)).setter(setter(Builder::serviceSettings))
            .constructor(ServiceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ServiceSettings serviceSettings;

    private GetServiceSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.serviceSettings = builder.serviceSettings;
    }

    /**
     * <p>
     * Returns details about the settings for Quick Setup in the requesting Amazon Web Services account and Amazon Web
     * Services Region.
     * </p>
     * 
     * @return Returns details about the settings for Quick Setup in the requesting Amazon Web Services account and
     *         Amazon Web Services Region.
     */
    public final ServiceSettings serviceSettings() {
        return serviceSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceSettingsResponse)) {
            return false;
        }
        GetServiceSettingsResponse other = (GetServiceSettingsResponse) obj;
        return Objects.equals(serviceSettings(), other.serviceSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetServiceSettingsResponse").add("ServiceSettings", serviceSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceSettings":
            return Optional.ofNullable(clazz.cast(serviceSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServiceSettings", SERVICE_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetServiceSettingsResponse, T> g) {
        return obj -> g.apply((GetServiceSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsmQuickSetupResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetServiceSettingsResponse> {
        /**
         * <p>
         * Returns details about the settings for Quick Setup in the requesting Amazon Web Services account and Amazon
         * Web Services Region.
         * </p>
         * 
         * @param serviceSettings
         *        Returns details about the settings for Quick Setup in the requesting Amazon Web Services account and
         *        Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSettings(ServiceSettings serviceSettings);

        /**
         * <p>
         * Returns details about the settings for Quick Setup in the requesting Amazon Web Services account and Amazon
         * Web Services Region.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceSettings.Builder} avoiding the
         * need to create one manually via {@link ServiceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceSettings(ServiceSettings)}.
         * 
         * @param serviceSettings
         *        a consumer that will call methods on {@link ServiceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceSettings(ServiceSettings)
         */
        default Builder serviceSettings(Consumer<ServiceSettings.Builder> serviceSettings) {
            return serviceSettings(ServiceSettings.builder().applyMutation(serviceSettings).build());
        }
    }

    static final class BuilderImpl extends SsmQuickSetupResponse.BuilderImpl implements Builder {
        private ServiceSettings serviceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceSettingsResponse model) {
            super(model);
            serviceSettings(model.serviceSettings);
        }

        public final ServiceSettings.Builder getServiceSettings() {
            return serviceSettings != null ? serviceSettings.toBuilder() : null;
        }

        public final void setServiceSettings(ServiceSettings.BuilderImpl serviceSettings) {
            this.serviceSettings = serviceSettings != null ? serviceSettings.build() : null;
        }

        @Override
        public final Builder serviceSettings(ServiceSettings serviceSettings) {
            this.serviceSettings = serviceSettings;
            return this;
        }

        @Override
        public GetServiceSettingsResponse build() {
            return new GetServiceSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
