/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmquicksetup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a Quick Setup configuration manager.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationManagerSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationManagerSummary.Builder, ConfigurationManagerSummary> {
    private static final SdkField<List<ConfigurationDefinitionSummary>> CONFIGURATION_DEFINITION_SUMMARIES_FIELD = SdkField
            .<List<ConfigurationDefinitionSummary>> builder(MarshallingType.LIST)
            .memberName("ConfigurationDefinitionSummaries")
            .getter(getter(ConfigurationManagerSummary::configurationDefinitionSummaries))
            .setter(setter(Builder::configurationDefinitionSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationDefinitionSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationDefinitionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationDefinitionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ConfigurationManagerSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> MANAGER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagerArn").getter(getter(ConfigurationManagerSummary::managerArn)).setter(setter(Builder::managerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagerArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ConfigurationManagerSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<StatusSummary>> STATUS_SUMMARIES_FIELD = SdkField
            .<List<StatusSummary>> builder(MarshallingType.LIST)
            .memberName("StatusSummaries")
            .getter(getter(ConfigurationManagerSummary::statusSummaries))
            .setter(setter(Builder::statusSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StatusSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(StatusSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_DEFINITION_SUMMARIES_FIELD, DESCRIPTION_FIELD, MANAGER_ARN_FIELD, NAME_FIELD, STATUS_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ConfigurationDefinitionSummary> configurationDefinitionSummaries;

    private final String description;

    private final String managerArn;

    private final String name;

    private final List<StatusSummary> statusSummaries;

    private ConfigurationManagerSummary(BuilderImpl builder) {
        this.configurationDefinitionSummaries = builder.configurationDefinitionSummaries;
        this.description = builder.description;
        this.managerArn = builder.managerArn;
        this.name = builder.name;
        this.statusSummaries = builder.statusSummaries;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfigurationDefinitionSummaries
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasConfigurationDefinitionSummaries() {
        return configurationDefinitionSummaries != null && !(configurationDefinitionSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A summary of the Quick Setup configuration definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurationDefinitionSummaries}
     * method.
     * </p>
     * 
     * @return A summary of the Quick Setup configuration definition.
     */
    public final List<ConfigurationDefinitionSummary> configurationDefinitionSummaries() {
        return configurationDefinitionSummaries;
    }

    /**
     * <p>
     * The description of the configuration.
     * </p>
     * 
     * @return The description of the configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ARN of the Quick Setup configuration.
     * </p>
     * 
     * @return The ARN of the Quick Setup configuration.
     */
    public final String managerArn() {
        return managerArn;
    }

    /**
     * <p>
     * The name of the configuration
     * </p>
     * 
     * @return The name of the configuration
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatusSummaries() {
        return statusSummaries != null && !(statusSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summaries of the state of the configuration manager. These summaries include an aggregate of the statuses from
     * the configuration definition associated with the configuration manager. This includes deployment statuses,
     * association statuses, drift statuses, health checks, and more.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusSummaries} method.
     * </p>
     * 
     * @return Summaries of the state of the configuration manager. These summaries include an aggregate of the statuses
     *         from the configuration definition associated with the configuration manager. This includes deployment
     *         statuses, association statuses, drift statuses, health checks, and more.
     */
    public final List<StatusSummary> statusSummaries() {
        return statusSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + Objects.hashCode(hasConfigurationDefinitionSummaries() ? configurationDefinitionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(managerArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusSummaries() ? statusSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationManagerSummary)) {
            return false;
        }
        ConfigurationManagerSummary other = (ConfigurationManagerSummary) obj;
        return hasConfigurationDefinitionSummaries() == other.hasConfigurationDefinitionSummaries()
                && Objects.equals(configurationDefinitionSummaries(), other.configurationDefinitionSummaries())
                && Objects.equals(description(), other.description()) && Objects.equals(managerArn(), other.managerArn())
                && Objects.equals(name(), other.name()) && hasStatusSummaries() == other.hasStatusSummaries()
                && Objects.equals(statusSummaries(), other.statusSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ConfigurationManagerSummary")
                .add("ConfigurationDefinitionSummaries",
                        hasConfigurationDefinitionSummaries() ? configurationDefinitionSummaries() : null)
                .add("Description", description()).add("ManagerArn", managerArn()).add("Name", name())
                .add("StatusSummaries", hasStatusSummaries() ? statusSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationDefinitionSummaries":
            return Optional.ofNullable(clazz.cast(configurationDefinitionSummaries()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ManagerArn":
            return Optional.ofNullable(clazz.cast(managerArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "StatusSummaries":
            return Optional.ofNullable(clazz.cast(statusSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationDefinitionSummaries", CONFIGURATION_DEFINITION_SUMMARIES_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ManagerArn", MANAGER_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("StatusSummaries", STATUS_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationManagerSummary, T> g) {
        return obj -> g.apply((ConfigurationManagerSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationManagerSummary> {
        /**
         * <p>
         * A summary of the Quick Setup configuration definition.
         * </p>
         * 
         * @param configurationDefinitionSummaries
         *        A summary of the Quick Setup configuration definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationDefinitionSummaries(Collection<ConfigurationDefinitionSummary> configurationDefinitionSummaries);

        /**
         * <p>
         * A summary of the Quick Setup configuration definition.
         * </p>
         * 
         * @param configurationDefinitionSummaries
         *        A summary of the Quick Setup configuration definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationDefinitionSummaries(ConfigurationDefinitionSummary... configurationDefinitionSummaries);

        /**
         * <p>
         * A summary of the Quick Setup configuration definition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationDefinitionSummary.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationDefinitionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationDefinitionSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #configurationDefinitionSummaries(List<ConfigurationDefinitionSummary>)}.
         * 
         * @param configurationDefinitionSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationDefinitionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationDefinitionSummaries(java.util.Collection<ConfigurationDefinitionSummary>)
         */
        Builder configurationDefinitionSummaries(
                Consumer<ConfigurationDefinitionSummary.Builder>... configurationDefinitionSummaries);

        /**
         * <p>
         * The description of the configuration.
         * </p>
         * 
         * @param description
         *        The description of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ARN of the Quick Setup configuration.
         * </p>
         * 
         * @param managerArn
         *        The ARN of the Quick Setup configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managerArn(String managerArn);

        /**
         * <p>
         * The name of the configuration
         * </p>
         * 
         * @param name
         *        The name of the configuration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Summaries of the state of the configuration manager. These summaries include an aggregate of the statuses
         * from the configuration definition associated with the configuration manager. This includes deployment
         * statuses, association statuses, drift statuses, health checks, and more.
         * </p>
         * 
         * @param statusSummaries
         *        Summaries of the state of the configuration manager. These summaries include an aggregate of the
         *        statuses from the configuration definition associated with the configuration manager. This includes
         *        deployment statuses, association statuses, drift statuses, health checks, and more.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusSummaries(Collection<StatusSummary> statusSummaries);

        /**
         * <p>
         * Summaries of the state of the configuration manager. These summaries include an aggregate of the statuses
         * from the configuration definition associated with the configuration manager. This includes deployment
         * statuses, association statuses, drift statuses, health checks, and more.
         * </p>
         * 
         * @param statusSummaries
         *        Summaries of the state of the configuration manager. These summaries include an aggregate of the
         *        statuses from the configuration definition associated with the configuration manager. This includes
         *        deployment statuses, association statuses, drift statuses, health checks, and more.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusSummaries(StatusSummary... statusSummaries);

        /**
         * <p>
         * Summaries of the state of the configuration manager. These summaries include an aggregate of the statuses
         * from the configuration definition associated with the configuration manager. This includes deployment
         * statuses, association statuses, drift statuses, health checks, and more.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.StatusSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ssmquicksetup.model.StatusSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.StatusSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #statusSummaries(List<StatusSummary>)}.
         * 
         * @param statusSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmquicksetup.model.StatusSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusSummaries(java.util.Collection<StatusSummary>)
         */
        Builder statusSummaries(Consumer<StatusSummary.Builder>... statusSummaries);
    }

    static final class BuilderImpl implements Builder {
        private List<ConfigurationDefinitionSummary> configurationDefinitionSummaries = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String managerArn;

        private String name;

        private List<StatusSummary> statusSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationManagerSummary model) {
            configurationDefinitionSummaries(model.configurationDefinitionSummaries);
            description(model.description);
            managerArn(model.managerArn);
            name(model.name);
            statusSummaries(model.statusSummaries);
        }

        public final List<ConfigurationDefinitionSummary.Builder> getConfigurationDefinitionSummaries() {
            List<ConfigurationDefinitionSummary.Builder> result = ConfigurationDefinitionSummariesListCopier
                    .copyToBuilder(this.configurationDefinitionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationDefinitionSummaries(
                Collection<ConfigurationDefinitionSummary.BuilderImpl> configurationDefinitionSummaries) {
            this.configurationDefinitionSummaries = ConfigurationDefinitionSummariesListCopier
                    .copyFromBuilder(configurationDefinitionSummaries);
        }

        @Override
        public final Builder configurationDefinitionSummaries(
                Collection<ConfigurationDefinitionSummary> configurationDefinitionSummaries) {
            this.configurationDefinitionSummaries = ConfigurationDefinitionSummariesListCopier
                    .copy(configurationDefinitionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationDefinitionSummaries(ConfigurationDefinitionSummary... configurationDefinitionSummaries) {
            configurationDefinitionSummaries(Arrays.asList(configurationDefinitionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationDefinitionSummaries(
                Consumer<ConfigurationDefinitionSummary.Builder>... configurationDefinitionSummaries) {
            configurationDefinitionSummaries(Stream.of(configurationDefinitionSummaries)
                    .map(c -> ConfigurationDefinitionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getManagerArn() {
            return managerArn;
        }

        public final void setManagerArn(String managerArn) {
            this.managerArn = managerArn;
        }

        @Override
        public final Builder managerArn(String managerArn) {
            this.managerArn = managerArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<StatusSummary.Builder> getStatusSummaries() {
            List<StatusSummary.Builder> result = StatusSummariesListCopier.copyToBuilder(this.statusSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatusSummaries(Collection<StatusSummary.BuilderImpl> statusSummaries) {
            this.statusSummaries = StatusSummariesListCopier.copyFromBuilder(statusSummaries);
        }

        @Override
        public final Builder statusSummaries(Collection<StatusSummary> statusSummaries) {
            this.statusSummaries = StatusSummariesListCopier.copy(statusSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusSummaries(StatusSummary... statusSummaries) {
            statusSummaries(Arrays.asList(statusSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusSummaries(Consumer<StatusSummary.Builder>... statusSummaries) {
            statusSummaries(Stream.of(statusSummaries).map(c -> StatusSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ConfigurationManagerSummary build() {
            return new ConfigurationManagerSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
