/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmquicksetup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConfigurationManagersResponse extends SsmQuickSetupResponse implements
        ToCopyableBuilder<ListConfigurationManagersResponse.Builder, ListConfigurationManagersResponse> {
    private static final SdkField<List<ConfigurationManagerSummary>> CONFIGURATION_MANAGERS_LIST_FIELD = SdkField
            .<List<ConfigurationManagerSummary>> builder(MarshallingType.LIST)
            .memberName("ConfigurationManagersList")
            .getter(getter(ListConfigurationManagersResponse::configurationManagersList))
            .setter(setter(Builder::configurationManagersList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationManagersList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationManagerSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationManagerSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListConfigurationManagersResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_MANAGERS_LIST_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ConfigurationManagerSummary> configurationManagersList;

    private final String nextToken;

    private ListConfigurationManagersResponse(BuilderImpl builder) {
        super(builder);
        this.configurationManagersList = builder.configurationManagersList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfigurationManagersList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConfigurationManagersList() {
        return configurationManagersList != null && !(configurationManagersList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration managers returned by the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurationManagersList} method.
     * </p>
     * 
     * @return The configuration managers returned by the request.
     */
    public final List<ConfigurationManagerSummary> configurationManagersList() {
        return configurationManagersList;
    }

    /**
     * <p>
     * The token to use when requesting the next set of configuration managers. If there are no additional operations to
     * return, the string is empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of configuration managers. If there are no additional
     *         operations to return, the string is empty.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurationManagersList() ? configurationManagersList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationManagersResponse)) {
            return false;
        }
        ListConfigurationManagersResponse other = (ListConfigurationManagersResponse) obj;
        return hasConfigurationManagersList() == other.hasConfigurationManagersList()
                && Objects.equals(configurationManagersList(), other.configurationManagersList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConfigurationManagersResponse")
                .add("ConfigurationManagersList", hasConfigurationManagersList() ? configurationManagersList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationManagersList":
            return Optional.ofNullable(clazz.cast(configurationManagersList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationManagersList", CONFIGURATION_MANAGERS_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationManagersResponse, T> g) {
        return obj -> g.apply((ListConfigurationManagersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsmQuickSetupResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListConfigurationManagersResponse> {
        /**
         * <p>
         * The configuration managers returned by the request.
         * </p>
         * 
         * @param configurationManagersList
         *        The configuration managers returned by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationManagersList(Collection<ConfigurationManagerSummary> configurationManagersList);

        /**
         * <p>
         * The configuration managers returned by the request.
         * </p>
         * 
         * @param configurationManagersList
         *        The configuration managers returned by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationManagersList(ConfigurationManagerSummary... configurationManagersList);

        /**
         * <p>
         * The configuration managers returned by the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationManagerSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationManagerSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationManagerSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #configurationManagersList(List<ConfigurationManagerSummary>)}.
         * 
         * @param configurationManagersList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationManagerSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationManagersList(java.util.Collection<ConfigurationManagerSummary>)
         */
        Builder configurationManagersList(Consumer<ConfigurationManagerSummary.Builder>... configurationManagersList);

        /**
         * <p>
         * The token to use when requesting the next set of configuration managers. If there are no additional
         * operations to return, the string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of configuration managers. If there are no additional
         *        operations to return, the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmQuickSetupResponse.BuilderImpl implements Builder {
        private List<ConfigurationManagerSummary> configurationManagersList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationManagersResponse model) {
            super(model);
            configurationManagersList(model.configurationManagersList);
            nextToken(model.nextToken);
        }

        public final List<ConfigurationManagerSummary.Builder> getConfigurationManagersList() {
            List<ConfigurationManagerSummary.Builder> result = ConfigurationManagerListCopier
                    .copyToBuilder(this.configurationManagersList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationManagersList(
                Collection<ConfigurationManagerSummary.BuilderImpl> configurationManagersList) {
            this.configurationManagersList = ConfigurationManagerListCopier.copyFromBuilder(configurationManagersList);
        }

        @Override
        public final Builder configurationManagersList(Collection<ConfigurationManagerSummary> configurationManagersList) {
            this.configurationManagersList = ConfigurationManagerListCopier.copy(configurationManagersList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationManagersList(ConfigurationManagerSummary... configurationManagersList) {
            configurationManagersList(Arrays.asList(configurationManagersList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationManagersList(Consumer<ConfigurationManagerSummary.Builder>... configurationManagersList) {
            configurationManagersList(Stream.of(configurationManagersList)
                    .map(c -> ConfigurationManagerSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConfigurationManagersResponse build() {
            return new ListConfigurationManagersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
