/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmquicksetup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListQuickSetupTypesResponse extends SsmQuickSetupResponse implements
        ToCopyableBuilder<ListQuickSetupTypesResponse.Builder, ListQuickSetupTypesResponse> {
    private static final SdkField<List<QuickSetupTypeOutput>> QUICK_SETUP_TYPE_LIST_FIELD = SdkField
            .<List<QuickSetupTypeOutput>> builder(MarshallingType.LIST)
            .memberName("QuickSetupTypeList")
            .getter(getter(ListQuickSetupTypesResponse::quickSetupTypeList))
            .setter(setter(Builder::quickSetupTypeList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickSetupTypeList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QuickSetupTypeOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(QuickSetupTypeOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUICK_SETUP_TYPE_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<QuickSetupTypeOutput> quickSetupTypeList;

    private ListQuickSetupTypesResponse(BuilderImpl builder) {
        super(builder);
        this.quickSetupTypeList = builder.quickSetupTypeList;
    }

    /**
     * For responses, this returns true if the service returned a value for the QuickSetupTypeList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQuickSetupTypeList() {
        return quickSetupTypeList != null && !(quickSetupTypeList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of Quick Setup types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQuickSetupTypeList} method.
     * </p>
     * 
     * @return An array of Quick Setup types.
     */
    public final List<QuickSetupTypeOutput> quickSetupTypeList() {
        return quickSetupTypeList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasQuickSetupTypeList() ? quickSetupTypeList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQuickSetupTypesResponse)) {
            return false;
        }
        ListQuickSetupTypesResponse other = (ListQuickSetupTypesResponse) obj;
        return hasQuickSetupTypeList() == other.hasQuickSetupTypeList()
                && Objects.equals(quickSetupTypeList(), other.quickSetupTypeList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListQuickSetupTypesResponse")
                .add("QuickSetupTypeList", hasQuickSetupTypeList() ? quickSetupTypeList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QuickSetupTypeList":
            return Optional.ofNullable(clazz.cast(quickSetupTypeList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QuickSetupTypeList", QUICK_SETUP_TYPE_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListQuickSetupTypesResponse, T> g) {
        return obj -> g.apply((ListQuickSetupTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsmQuickSetupResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListQuickSetupTypesResponse> {
        /**
         * <p>
         * An array of Quick Setup types.
         * </p>
         * 
         * @param quickSetupTypeList
         *        An array of Quick Setup types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickSetupTypeList(Collection<QuickSetupTypeOutput> quickSetupTypeList);

        /**
         * <p>
         * An array of Quick Setup types.
         * </p>
         * 
         * @param quickSetupTypeList
         *        An array of Quick Setup types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickSetupTypeList(QuickSetupTypeOutput... quickSetupTypeList);

        /**
         * <p>
         * An array of Quick Setup types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.QuickSetupTypeOutput.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.QuickSetupTypeOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.QuickSetupTypeOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #quickSetupTypeList(List<QuickSetupTypeOutput>)}.
         * 
         * @param quickSetupTypeList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmquicksetup.model.QuickSetupTypeOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quickSetupTypeList(java.util.Collection<QuickSetupTypeOutput>)
         */
        Builder quickSetupTypeList(Consumer<QuickSetupTypeOutput.Builder>... quickSetupTypeList);
    }

    static final class BuilderImpl extends SsmQuickSetupResponse.BuilderImpl implements Builder {
        private List<QuickSetupTypeOutput> quickSetupTypeList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListQuickSetupTypesResponse model) {
            super(model);
            quickSetupTypeList(model.quickSetupTypeList);
        }

        public final List<QuickSetupTypeOutput.Builder> getQuickSetupTypeList() {
            List<QuickSetupTypeOutput.Builder> result = QuickSetupTypeListCopier.copyToBuilder(this.quickSetupTypeList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQuickSetupTypeList(Collection<QuickSetupTypeOutput.BuilderImpl> quickSetupTypeList) {
            this.quickSetupTypeList = QuickSetupTypeListCopier.copyFromBuilder(quickSetupTypeList);
        }

        @Override
        public final Builder quickSetupTypeList(Collection<QuickSetupTypeOutput> quickSetupTypeList) {
            this.quickSetupTypeList = QuickSetupTypeListCopier.copy(quickSetupTypeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quickSetupTypeList(QuickSetupTypeOutput... quickSetupTypeList) {
            quickSetupTypeList(Arrays.asList(quickSetupTypeList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quickSetupTypeList(Consumer<QuickSetupTypeOutput.Builder>... quickSetupTypeList) {
            quickSetupTypeList(Stream.of(quickSetupTypeList).map(c -> QuickSetupTypeOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListQuickSetupTypesResponse build() {
            return new ListQuickSetupTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
