/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmquicksetup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition of a Quick Setup configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationDefinition.Builder, ConfigurationDefinition> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ConfigurationDefinition::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> LOCAL_DEPLOYMENT_ADMINISTRATION_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalDeploymentAdministrationRoleArn")
            .getter(getter(ConfigurationDefinition::localDeploymentAdministrationRoleArn))
            .setter(setter(Builder::localDeploymentAdministrationRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LocalDeploymentAdministrationRoleArn").build()).build();

    private static final SdkField<String> LOCAL_DEPLOYMENT_EXECUTION_ROLE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalDeploymentExecutionRoleName")
            .getter(getter(ConfigurationDefinition::localDeploymentExecutionRoleName))
            .setter(setter(Builder::localDeploymentExecutionRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalDeploymentExecutionRoleName")
                    .build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(ConfigurationDefinition::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ConfigurationDefinition::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> TYPE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeVersion").getter(getter(ConfigurationDefinition::typeVersion)).setter(setter(Builder::typeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            LOCAL_DEPLOYMENT_ADMINISTRATION_ROLE_ARN_FIELD, LOCAL_DEPLOYMENT_EXECUTION_ROLE_NAME_FIELD, PARAMETERS_FIELD,
            TYPE_FIELD, TYPE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String localDeploymentAdministrationRoleArn;

    private final String localDeploymentExecutionRoleName;

    private final Map<String, String> parameters;

    private final String type;

    private final String typeVersion;

    private ConfigurationDefinition(BuilderImpl builder) {
        this.id = builder.id;
        this.localDeploymentAdministrationRoleArn = builder.localDeploymentAdministrationRoleArn;
        this.localDeploymentExecutionRoleName = builder.localDeploymentExecutionRoleName;
        this.parameters = builder.parameters;
        this.type = builder.type;
        this.typeVersion = builder.typeVersion;
    }

    /**
     * <p>
     * The ID of the configuration definition.
     * </p>
     * 
     * @return The ID of the configuration definition.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN of the IAM role used to administrate local configuration deployments.
     * </p>
     * 
     * @return The ARN of the IAM role used to administrate local configuration deployments.
     */
    public final String localDeploymentAdministrationRoleArn() {
        return localDeploymentAdministrationRoleArn;
    }

    /**
     * <p>
     * The name of the IAM role used to deploy local configurations.
     * </p>
     * 
     * @return The name of the IAM role used to deploy local configurations.
     */
    public final String localDeploymentExecutionRoleName() {
        return localDeploymentExecutionRoleName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs containing the required parameters for the configuration type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return A list of key-value pairs containing the required parameters for the configuration type.
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The type of the Quick Setup configuration.
     * </p>
     * 
     * @return The type of the Quick Setup configuration.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The version of the Quick Setup type used.
     * </p>
     * 
     * @return The version of the Quick Setup type used.
     */
    public final String typeVersion() {
        return typeVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(localDeploymentAdministrationRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(localDeploymentExecutionRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(typeVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationDefinition)) {
            return false;
        }
        ConfigurationDefinition other = (ConfigurationDefinition) obj;
        return Objects.equals(id(), other.id())
                && Objects.equals(localDeploymentAdministrationRoleArn(), other.localDeploymentAdministrationRoleArn())
                && Objects.equals(localDeploymentExecutionRoleName(), other.localDeploymentExecutionRoleName())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(type(), other.type()) && Objects.equals(typeVersion(), other.typeVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationDefinition").add("Id", id())
                .add("LocalDeploymentAdministrationRoleArn", localDeploymentAdministrationRoleArn())
                .add("LocalDeploymentExecutionRoleName", localDeploymentExecutionRoleName())
                .add("Parameters", hasParameters() ? parameters() : null).add("Type", type()).add("TypeVersion", typeVersion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LocalDeploymentAdministrationRoleArn":
            return Optional.ofNullable(clazz.cast(localDeploymentAdministrationRoleArn()));
        case "LocalDeploymentExecutionRoleName":
            return Optional.ofNullable(clazz.cast(localDeploymentExecutionRoleName()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "TypeVersion":
            return Optional.ofNullable(clazz.cast(typeVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("LocalDeploymentAdministrationRoleArn", LOCAL_DEPLOYMENT_ADMINISTRATION_ROLE_ARN_FIELD);
        map.put("LocalDeploymentExecutionRoleName", LOCAL_DEPLOYMENT_EXECUTION_ROLE_NAME_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("TypeVersion", TYPE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationDefinition, T> g) {
        return obj -> g.apply((ConfigurationDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationDefinition> {
        /**
         * <p>
         * The ID of the configuration definition.
         * </p>
         * 
         * @param id
         *        The ID of the configuration definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN of the IAM role used to administrate local configuration deployments.
         * </p>
         * 
         * @param localDeploymentAdministrationRoleArn
         *        The ARN of the IAM role used to administrate local configuration deployments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localDeploymentAdministrationRoleArn(String localDeploymentAdministrationRoleArn);

        /**
         * <p>
         * The name of the IAM role used to deploy local configurations.
         * </p>
         * 
         * @param localDeploymentExecutionRoleName
         *        The name of the IAM role used to deploy local configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localDeploymentExecutionRoleName(String localDeploymentExecutionRoleName);

        /**
         * <p>
         * A list of key-value pairs containing the required parameters for the configuration type.
         * </p>
         * 
         * @param parameters
         *        A list of key-value pairs containing the required parameters for the configuration type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * The type of the Quick Setup configuration.
         * </p>
         * 
         * @param type
         *        The type of the Quick Setup configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The version of the Quick Setup type used.
         * </p>
         * 
         * @param typeVersion
         *        The version of the Quick Setup type used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeVersion(String typeVersion);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String localDeploymentAdministrationRoleArn;

        private String localDeploymentExecutionRoleName;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private String typeVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationDefinition model) {
            id(model.id);
            localDeploymentAdministrationRoleArn(model.localDeploymentAdministrationRoleArn);
            localDeploymentExecutionRoleName(model.localDeploymentExecutionRoleName);
            parameters(model.parameters);
            type(model.type);
            typeVersion(model.typeVersion);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLocalDeploymentAdministrationRoleArn() {
            return localDeploymentAdministrationRoleArn;
        }

        public final void setLocalDeploymentAdministrationRoleArn(String localDeploymentAdministrationRoleArn) {
            this.localDeploymentAdministrationRoleArn = localDeploymentAdministrationRoleArn;
        }

        @Override
        public final Builder localDeploymentAdministrationRoleArn(String localDeploymentAdministrationRoleArn) {
            this.localDeploymentAdministrationRoleArn = localDeploymentAdministrationRoleArn;
            return this;
        }

        public final String getLocalDeploymentExecutionRoleName() {
            return localDeploymentExecutionRoleName;
        }

        public final void setLocalDeploymentExecutionRoleName(String localDeploymentExecutionRoleName) {
            this.localDeploymentExecutionRoleName = localDeploymentExecutionRoleName;
        }

        @Override
        public final Builder localDeploymentExecutionRoleName(String localDeploymentExecutionRoleName) {
            this.localDeploymentExecutionRoleName = localDeploymentExecutionRoleName;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ConfigurationParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ConfigurationParametersMapCopier.copy(parameters);
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getTypeVersion() {
            return typeVersion;
        }

        public final void setTypeVersion(String typeVersion) {
            this.typeVersion = typeVersion;
        }

        @Override
        public final Builder typeVersion(String typeVersion) {
            this.typeVersion = typeVersion;
            return this;
        }

        @Override
        public ConfigurationDefinition build() {
            return new ConfigurationDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
