/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmquicksetup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConfigurationManagersRequest extends SsmQuickSetupRequest implements
        ToCopyableBuilder<ListConfigurationManagersRequest.Builder, ListConfigurationManagersRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(ListConfigurationManagersRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems").getter(getter(ListConfigurationManagersRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()).build();

    private static final SdkField<String> STARTING_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartingToken").getter(getter(ListConfigurationManagersRequest::startingToken))
            .setter(setter(Builder::startingToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            MAX_ITEMS_FIELD, STARTING_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Filter> filters;

    private final Integer maxItems;

    private final String startingToken;

    private ListConfigurationManagersRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxItems = builder.maxItems;
        this.startingToken = builder.startingToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the results returned by the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Filters the results returned by the request.
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * Specifies the maximum number of configuration managers that are returned by the request.
     * </p>
     * 
     * @return Specifies the maximum number of configuration managers that are returned by the request.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * The token to use when requesting a specific set of items from a list.
     * </p>
     * 
     * @return The token to use when requesting a specific set of items from a list.
     */
    public final String startingToken() {
        return startingToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(startingToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationManagersRequest)) {
            return false;
        }
        ListConfigurationManagersRequest other = (ListConfigurationManagersRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxItems(), other.maxItems()) && Objects.equals(startingToken(), other.startingToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConfigurationManagersRequest").add("Filters", hasFilters() ? filters() : null)
                .add("MaxItems", maxItems()).add("StartingToken", startingToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "StartingToken":
            return Optional.ofNullable(clazz.cast(startingToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Filters", FILTERS_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("StartingToken", STARTING_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationManagersRequest, T> g) {
        return obj -> g.apply((ListConfigurationManagersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsmQuickSetupRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListConfigurationManagersRequest> {
        /**
         * <p>
         * Filters the results returned by the request.
         * </p>
         * 
         * @param filters
         *        Filters the results returned by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * Filters the results returned by the request.
         * </p>
         * 
         * @param filters
         *        Filters the results returned by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * Filters the results returned by the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.Filter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ssmquicksetup.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.Filter.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmquicksetup.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * Specifies the maximum number of configuration managers that are returned by the request.
         * </p>
         * 
         * @param maxItems
         *        Specifies the maximum number of configuration managers that are returned by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * The token to use when requesting a specific set of items from a list.
         * </p>
         * 
         * @param startingToken
         *        The token to use when requesting a specific set of items from a list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingToken(String startingToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmQuickSetupRequest.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxItems;

        private String startingToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationManagersRequest model) {
            super(model);
            filters(model.filters);
            maxItems(model.maxItems);
            startingToken(model.startingToken);
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FiltersListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FiltersListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FiltersListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getStartingToken() {
            return startingToken;
        }

        public final void setStartingToken(String startingToken) {
            this.startingToken = startingToken;
        }

        @Override
        public final Builder startingToken(String startingToken) {
            this.startingToken = startingToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListConfigurationManagersRequest build() {
            return new ListConfigurationManagersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
