/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ssmsap.DefaultSsmSapAsyncClient;
import software.amazon.awssdk.services.ssmsap.DefaultSsmSapBaseClientBuilder;
import software.amazon.awssdk.services.ssmsap.SsmSapAsyncClient;
import software.amazon.awssdk.services.ssmsap.SsmSapAsyncClientBuilder;
import software.amazon.awssdk.services.ssmsap.SsmSapServiceClientConfiguration;
import software.amazon.awssdk.services.ssmsap.endpoints.SsmSapEndpointProvider;

@SdkInternalApi
final class DefaultSsmSapAsyncClientBuilder
extends DefaultSsmSapBaseClientBuilder<SsmSapAsyncClientBuilder, SsmSapAsyncClient>
implements SsmSapAsyncClientBuilder {
    DefaultSsmSapAsyncClientBuilder() {
    }

    @Override
    public DefaultSsmSapAsyncClientBuilder endpointProvider(SsmSapEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SsmSapAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSsmSapAsyncClientBuilder.validateClientOptions(clientConfiguration);
        SsmSapServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSsmSapAsyncClient client = new DefaultSsmSapAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SsmSapServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SsmSapServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

