/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DatabaseConnectionMethod {
    DIRECT("DIRECT"),
    OVERLAY("OVERLAY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DatabaseConnectionMethod> VALUE_MAP;
    private final String value;

    private DatabaseConnectionMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DatabaseConnectionMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DatabaseConnectionMethod> knownValues() {
        EnumSet<DatabaseConnectionMethod> knownValues = EnumSet.allOf(DatabaseConnectionMethod.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DatabaseConnectionMethod.class, DatabaseConnectionMethod::toString);
    }
}

