/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReplicationMode {
    PRIMARY("PRIMARY"),
    NONE("NONE"),
    SYNC("SYNC"),
    SYNCMEM("SYNCMEM"),
    ASYNC("ASYNC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReplicationMode> VALUE_MAP;
    private final String value;

    private ReplicationMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReplicationMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReplicationMode> knownValues() {
        EnumSet<ReplicationMode> knownValues = EnumSet.allOf(ReplicationMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReplicationMode.class, ReplicationMode::toString);
    }
}

