/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOperationEventsResponse extends SsmSapResponse implements
        ToCopyableBuilder<ListOperationEventsResponse.Builder, ListOperationEventsResponse> {
    private static final SdkField<List<OperationEvent>> OPERATION_EVENTS_FIELD = SdkField
            .<List<OperationEvent>> builder(MarshallingType.LIST)
            .memberName("OperationEvents")
            .getter(getter(ListOperationEventsResponse::operationEvents))
            .setter(setter(Builder::operationEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OperationEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(OperationEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListOperationEventsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_EVENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<OperationEvent> operationEvents;

    private final String nextToken;

    private ListOperationEventsResponse(BuilderImpl builder) {
        super(builder);
        this.operationEvents = builder.operationEvents;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the OperationEvents property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOperationEvents() {
        return operationEvents != null && !(operationEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A returned list of operation events that meet the filter criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperationEvents} method.
     * </p>
     * 
     * @return A returned list of operation events that meet the filter criteria.
     */
    public final List<OperationEvent> operationEvents() {
        return operationEvents;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is null when there are no more results
     *         to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasOperationEvents() ? operationEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOperationEventsResponse)) {
            return false;
        }
        ListOperationEventsResponse other = (ListOperationEventsResponse) obj;
        return hasOperationEvents() == other.hasOperationEvents() && Objects.equals(operationEvents(), other.operationEvents())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOperationEventsResponse")
                .add("OperationEvents", hasOperationEvents() ? operationEvents() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OperationEvents":
            return Optional.ofNullable(clazz.cast(operationEvents()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOperationEventsResponse, T> g) {
        return obj -> g.apply((ListOperationEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmSapResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListOperationEventsResponse> {
        /**
         * <p>
         * A returned list of operation events that meet the filter criteria.
         * </p>
         * 
         * @param operationEvents
         *        A returned list of operation events that meet the filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationEvents(Collection<OperationEvent> operationEvents);

        /**
         * <p>
         * A returned list of operation events that meet the filter criteria.
         * </p>
         * 
         * @param operationEvents
         *        A returned list of operation events that meet the filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationEvents(OperationEvent... operationEvents);

        /**
         * <p>
         * A returned list of operation events that meet the filter criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmsap.model.OperationEvent.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ssmsap.model.OperationEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmsap.model.OperationEvent.Builder#build()} is called immediately and
         * its result is passed to {@link #operationEvents(List<OperationEvent>)}.
         * 
         * @param operationEvents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmsap.model.OperationEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operationEvents(java.util.Collection<OperationEvent>)
         */
        Builder operationEvents(Consumer<OperationEvent.Builder>... operationEvents);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is null when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmSapResponse.BuilderImpl implements Builder {
        private List<OperationEvent> operationEvents = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOperationEventsResponse model) {
            super(model);
            operationEvents(model.operationEvents);
            nextToken(model.nextToken);
        }

        public final List<OperationEvent.Builder> getOperationEvents() {
            List<OperationEvent.Builder> result = OperationEventListCopier.copyToBuilder(this.operationEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperationEvents(Collection<OperationEvent.BuilderImpl> operationEvents) {
            this.operationEvents = OperationEventListCopier.copyFromBuilder(operationEvents);
        }

        @Override
        public final Builder operationEvents(Collection<OperationEvent> operationEvents) {
            this.operationEvents = OperationEventListCopier.copy(operationEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationEvents(OperationEvent... operationEvents) {
            operationEvents(Arrays.asList(operationEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationEvents(Consumer<OperationEvent.Builder>... operationEvents) {
            operationEvents(Stream.of(operationEvents).map(c -> OperationEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOperationEventsResponse build() {
            return new ListOperationEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
