/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopApplicationRequest extends SsmSapRequest implements
        ToCopyableBuilder<StopApplicationRequest.Builder, StopApplicationRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(StopApplicationRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> STOP_CONNECTED_ENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StopConnectedEntity").getter(getter(StopApplicationRequest::stopConnectedEntityAsString))
            .setter(setter(Builder::stopConnectedEntity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopConnectedEntity").build())
            .build();

    private static final SdkField<Boolean> INCLUDE_EC2_INSTANCE_SHUTDOWN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeEc2InstanceShutdown")
            .getter(getter(StopApplicationRequest::includeEc2InstanceShutdown))
            .setter(setter(Builder::includeEc2InstanceShutdown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeEc2InstanceShutdown").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            STOP_CONNECTED_ENTITY_FIELD, INCLUDE_EC2_INSTANCE_SHUTDOWN_FIELD));

    private final String applicationId;

    private final String stopConnectedEntity;

    private final Boolean includeEc2InstanceShutdown;

    private StopApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.stopConnectedEntity = builder.stopConnectedEntity;
        this.includeEc2InstanceShutdown = builder.includeEc2InstanceShutdown;
    }

    /**
     * <p>
     * The ID of the application.
     * </p>
     * 
     * @return The ID of the application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * Specify the <code>ConnectedEntityType</code>. Accepted type is <code>DBMS</code>.
     * </p>
     * <p>
     * If this parameter is included, the connected DBMS (Database Management System) will be stopped.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #stopConnectedEntity} will return {@link ConnectedEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #stopConnectedEntityAsString}.
     * </p>
     * 
     * @return Specify the <code>ConnectedEntityType</code>. Accepted type is <code>DBMS</code>.</p>
     *         <p>
     *         If this parameter is included, the connected DBMS (Database Management System) will be stopped.
     * @see ConnectedEntityType
     */
    public final ConnectedEntityType stopConnectedEntity() {
        return ConnectedEntityType.fromValue(stopConnectedEntity);
    }

    /**
     * <p>
     * Specify the <code>ConnectedEntityType</code>. Accepted type is <code>DBMS</code>.
     * </p>
     * <p>
     * If this parameter is included, the connected DBMS (Database Management System) will be stopped.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #stopConnectedEntity} will return {@link ConnectedEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #stopConnectedEntityAsString}.
     * </p>
     * 
     * @return Specify the <code>ConnectedEntityType</code>. Accepted type is <code>DBMS</code>.</p>
     *         <p>
     *         If this parameter is included, the connected DBMS (Database Management System) will be stopped.
     * @see ConnectedEntityType
     */
    public final String stopConnectedEntityAsString() {
        return stopConnectedEntity;
    }

    /**
     * <p>
     * Boolean. If included and if set to <code>True</code>, the StopApplication operation will shut down the associated
     * Amazon EC2 instance in addition to the application.
     * </p>
     * 
     * @return Boolean. If included and if set to <code>True</code>, the StopApplication operation will shut down the
     *         associated Amazon EC2 instance in addition to the application.
     */
    public final Boolean includeEc2InstanceShutdown() {
        return includeEc2InstanceShutdown;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(stopConnectedEntityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(includeEc2InstanceShutdown());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopApplicationRequest)) {
            return false;
        }
        StopApplicationRequest other = (StopApplicationRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(stopConnectedEntityAsString(), other.stopConnectedEntityAsString())
                && Objects.equals(includeEc2InstanceShutdown(), other.includeEc2InstanceShutdown());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopApplicationRequest").add("ApplicationId", applicationId())
                .add("StopConnectedEntity", stopConnectedEntityAsString())
                .add("IncludeEc2InstanceShutdown", includeEc2InstanceShutdown()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "StopConnectedEntity":
            return Optional.ofNullable(clazz.cast(stopConnectedEntityAsString()));
        case "IncludeEc2InstanceShutdown":
            return Optional.ofNullable(clazz.cast(includeEc2InstanceShutdown()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopApplicationRequest, T> g) {
        return obj -> g.apply((StopApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmSapRequest.Builder, SdkPojo, CopyableBuilder<Builder, StopApplicationRequest> {
        /**
         * <p>
         * The ID of the application.
         * </p>
         * 
         * @param applicationId
         *        The ID of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * Specify the <code>ConnectedEntityType</code>. Accepted type is <code>DBMS</code>.
         * </p>
         * <p>
         * If this parameter is included, the connected DBMS (Database Management System) will be stopped.
         * </p>
         * 
         * @param stopConnectedEntity
         *        Specify the <code>ConnectedEntityType</code>. Accepted type is <code>DBMS</code>.</p>
         *        <p>
         *        If this parameter is included, the connected DBMS (Database Management System) will be stopped.
         * @see ConnectedEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectedEntityType
         */
        Builder stopConnectedEntity(String stopConnectedEntity);

        /**
         * <p>
         * Specify the <code>ConnectedEntityType</code>. Accepted type is <code>DBMS</code>.
         * </p>
         * <p>
         * If this parameter is included, the connected DBMS (Database Management System) will be stopped.
         * </p>
         * 
         * @param stopConnectedEntity
         *        Specify the <code>ConnectedEntityType</code>. Accepted type is <code>DBMS</code>.</p>
         *        <p>
         *        If this parameter is included, the connected DBMS (Database Management System) will be stopped.
         * @see ConnectedEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectedEntityType
         */
        Builder stopConnectedEntity(ConnectedEntityType stopConnectedEntity);

        /**
         * <p>
         * Boolean. If included and if set to <code>True</code>, the StopApplication operation will shut down the
         * associated Amazon EC2 instance in addition to the application.
         * </p>
         * 
         * @param includeEc2InstanceShutdown
         *        Boolean. If included and if set to <code>True</code>, the StopApplication operation will shut down the
         *        associated Amazon EC2 instance in addition to the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeEc2InstanceShutdown(Boolean includeEc2InstanceShutdown);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmSapRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String stopConnectedEntity;

        private Boolean includeEc2InstanceShutdown;

        private BuilderImpl() {
        }

        private BuilderImpl(StopApplicationRequest model) {
            super(model);
            applicationId(model.applicationId);
            stopConnectedEntity(model.stopConnectedEntity);
            includeEc2InstanceShutdown(model.includeEc2InstanceShutdown);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getStopConnectedEntity() {
            return stopConnectedEntity;
        }

        public final void setStopConnectedEntity(String stopConnectedEntity) {
            this.stopConnectedEntity = stopConnectedEntity;
        }

        @Override
        public final Builder stopConnectedEntity(String stopConnectedEntity) {
            this.stopConnectedEntity = stopConnectedEntity;
            return this;
        }

        @Override
        public final Builder stopConnectedEntity(ConnectedEntityType stopConnectedEntity) {
            this.stopConnectedEntity(stopConnectedEntity == null ? null : stopConnectedEntity.toString());
            return this;
        }

        public final Boolean getIncludeEc2InstanceShutdown() {
            return includeEc2InstanceShutdown;
        }

        public final void setIncludeEc2InstanceShutdown(Boolean includeEc2InstanceShutdown) {
            this.includeEc2InstanceShutdown = includeEc2InstanceShutdown;
        }

        @Override
        public final Builder includeEc2InstanceShutdown(Boolean includeEc2InstanceShutdown) {
            this.includeEc2InstanceShutdown = includeEc2InstanceShutdown;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopApplicationRequest build() {
            return new StopApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
