/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmsap.model.ClusterStatus;
import software.amazon.awssdk.services.ssmsap.model.OperationMode;
import software.amazon.awssdk.services.ssmsap.model.ReplicationMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Resilience
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Resilience> {
    private static final SdkField<String> HSR_TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsrTier").getter(Resilience.getter(Resilience::hsrTier)).setter(Resilience.setter(Builder::hsrTier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsrTier").build()}).build();
    private static final SdkField<String> HSR_REPLICATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsrReplicationMode").getter(Resilience.getter(Resilience::hsrReplicationModeAsString)).setter(Resilience.setter(Builder::hsrReplicationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsrReplicationMode").build()}).build();
    private static final SdkField<String> HSR_OPERATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsrOperationMode").getter(Resilience.getter(Resilience::hsrOperationModeAsString)).setter(Resilience.setter(Builder::hsrOperationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsrOperationMode").build()}).build();
    private static final SdkField<String> CLUSTER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterStatus").getter(Resilience.getter(Resilience::clusterStatusAsString)).setter(Resilience.setter(Builder::clusterStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterStatus").build()}).build();
    private static final SdkField<Boolean> ENQUEUE_REPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnqueueReplication").getter(Resilience.getter(Resilience::enqueueReplication)).setter(Resilience.setter(Builder::enqueueReplication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnqueueReplication").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HSR_TIER_FIELD, HSR_REPLICATION_MODE_FIELD, HSR_OPERATION_MODE_FIELD, CLUSTER_STATUS_FIELD, ENQUEUE_REPLICATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("HsrTier", HSR_TIER_FIELD);
            this.put("HsrReplicationMode", HSR_REPLICATION_MODE_FIELD);
            this.put("HsrOperationMode", HSR_OPERATION_MODE_FIELD);
            this.put("ClusterStatus", CLUSTER_STATUS_FIELD);
            this.put("EnqueueReplication", ENQUEUE_REPLICATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String hsrTier;
    private final String hsrReplicationMode;
    private final String hsrOperationMode;
    private final String clusterStatus;
    private final Boolean enqueueReplication;

    private Resilience(BuilderImpl builder) {
        this.hsrTier = builder.hsrTier;
        this.hsrReplicationMode = builder.hsrReplicationMode;
        this.hsrOperationMode = builder.hsrOperationMode;
        this.clusterStatus = builder.clusterStatus;
        this.enqueueReplication = builder.enqueueReplication;
    }

    public final String hsrTier() {
        return this.hsrTier;
    }

    public final ReplicationMode hsrReplicationMode() {
        return ReplicationMode.fromValue(this.hsrReplicationMode);
    }

    public final String hsrReplicationModeAsString() {
        return this.hsrReplicationMode;
    }

    public final OperationMode hsrOperationMode() {
        return OperationMode.fromValue(this.hsrOperationMode);
    }

    public final String hsrOperationModeAsString() {
        return this.hsrOperationMode;
    }

    public final ClusterStatus clusterStatus() {
        return ClusterStatus.fromValue(this.clusterStatus);
    }

    public final String clusterStatusAsString() {
        return this.clusterStatus;
    }

    public final Boolean enqueueReplication() {
        return this.enqueueReplication;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hsrTier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsrReplicationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsrOperationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enqueueReplication());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resilience)) {
            return false;
        }
        Resilience other = (Resilience)obj;
        return Objects.equals(this.hsrTier(), other.hsrTier()) && Objects.equals(this.hsrReplicationModeAsString(), other.hsrReplicationModeAsString()) && Objects.equals(this.hsrOperationModeAsString(), other.hsrOperationModeAsString()) && Objects.equals(this.clusterStatusAsString(), other.clusterStatusAsString()) && Objects.equals(this.enqueueReplication(), other.enqueueReplication());
    }

    public final String toString() {
        return ToString.builder((String)"Resilience").add("HsrTier", (Object)this.hsrTier()).add("HsrReplicationMode", (Object)this.hsrReplicationModeAsString()).add("HsrOperationMode", (Object)this.hsrOperationModeAsString()).add("ClusterStatus", (Object)this.clusterStatusAsString()).add("EnqueueReplication", (Object)this.enqueueReplication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HsrTier": {
                return Optional.ofNullable(clazz.cast(this.hsrTier()));
            }
            case "HsrReplicationMode": {
                return Optional.ofNullable(clazz.cast(this.hsrReplicationModeAsString()));
            }
            case "HsrOperationMode": {
                return Optional.ofNullable(clazz.cast(this.hsrOperationModeAsString()));
            }
            case "ClusterStatus": {
                return Optional.ofNullable(clazz.cast(this.clusterStatusAsString()));
            }
            case "EnqueueReplication": {
                return Optional.ofNullable(clazz.cast(this.enqueueReplication()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Resilience, T> g) {
        return obj -> g.apply((Resilience)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hsrTier;
        private String hsrReplicationMode;
        private String hsrOperationMode;
        private String clusterStatus;
        private Boolean enqueueReplication;

        private BuilderImpl() {
        }

        private BuilderImpl(Resilience model) {
            this.hsrTier(model.hsrTier);
            this.hsrReplicationMode(model.hsrReplicationMode);
            this.hsrOperationMode(model.hsrOperationMode);
            this.clusterStatus(model.clusterStatus);
            this.enqueueReplication(model.enqueueReplication);
        }

        public final String getHsrTier() {
            return this.hsrTier;
        }

        public final void setHsrTier(String hsrTier) {
            this.hsrTier = hsrTier;
        }

        @Override
        public final Builder hsrTier(String hsrTier) {
            this.hsrTier = hsrTier;
            return this;
        }

        public final String getHsrReplicationMode() {
            return this.hsrReplicationMode;
        }

        public final void setHsrReplicationMode(String hsrReplicationMode) {
            this.hsrReplicationMode = hsrReplicationMode;
        }

        @Override
        public final Builder hsrReplicationMode(String hsrReplicationMode) {
            this.hsrReplicationMode = hsrReplicationMode;
            return this;
        }

        @Override
        public final Builder hsrReplicationMode(ReplicationMode hsrReplicationMode) {
            this.hsrReplicationMode(hsrReplicationMode == null ? null : hsrReplicationMode.toString());
            return this;
        }

        public final String getHsrOperationMode() {
            return this.hsrOperationMode;
        }

        public final void setHsrOperationMode(String hsrOperationMode) {
            this.hsrOperationMode = hsrOperationMode;
        }

        @Override
        public final Builder hsrOperationMode(String hsrOperationMode) {
            this.hsrOperationMode = hsrOperationMode;
            return this;
        }

        @Override
        public final Builder hsrOperationMode(OperationMode hsrOperationMode) {
            this.hsrOperationMode(hsrOperationMode == null ? null : hsrOperationMode.toString());
            return this;
        }

        public final String getClusterStatus() {
            return this.clusterStatus;
        }

        public final void setClusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
        }

        @Override
        public final Builder clusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
            return this;
        }

        @Override
        public final Builder clusterStatus(ClusterStatus clusterStatus) {
            this.clusterStatus(clusterStatus == null ? null : clusterStatus.toString());
            return this;
        }

        public final Boolean getEnqueueReplication() {
            return this.enqueueReplication;
        }

        public final void setEnqueueReplication(Boolean enqueueReplication) {
            this.enqueueReplication = enqueueReplication;
        }

        @Override
        public final Builder enqueueReplication(Boolean enqueueReplication) {
            this.enqueueReplication = enqueueReplication;
            return this;
        }

        public Resilience build() {
            return new Resilience(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Resilience> {
        public Builder hsrTier(String var1);

        public Builder hsrReplicationMode(String var1);

        public Builder hsrReplicationMode(ReplicationMode var1);

        public Builder hsrOperationMode(String var1);

        public Builder hsrOperationMode(OperationMode var1);

        public Builder clusterStatus(String var1);

        public Builder clusterStatus(ClusterStatus var1);

        public Builder enqueueReplication(Boolean var1);
    }
}

