/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterApplicationResponse extends SsmSapResponse implements
        ToCopyableBuilder<RegisterApplicationResponse.Builder, RegisterApplicationResponse> {
    private static final SdkField<Application> APPLICATION_FIELD = SdkField.<Application> builder(MarshallingType.SDK_POJO)
            .memberName("Application").getter(getter(RegisterApplicationResponse::application))
            .setter(setter(Builder::application)).constructor(Application::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Application").build()).build();

    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationId").getter(getter(RegisterApplicationResponse::operationId))
            .setter(setter(Builder::operationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD,
            OPERATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Application application;

    private final String operationId;

    private RegisterApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.application = builder.application;
        this.operationId = builder.operationId;
    }

    /**
     * <p>
     * The application registered with AWS Systems Manager for SAP.
     * </p>
     * 
     * @return The application registered with AWS Systems Manager for SAP.
     */
    public final Application application() {
        return application;
    }

    /**
     * <p>
     * The ID of the operation.
     * </p>
     * 
     * @return The ID of the operation.
     */
    public final String operationId() {
        return operationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(application());
        hashCode = 31 * hashCode + Objects.hashCode(operationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterApplicationResponse)) {
            return false;
        }
        RegisterApplicationResponse other = (RegisterApplicationResponse) obj;
        return Objects.equals(application(), other.application()) && Objects.equals(operationId(), other.operationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterApplicationResponse").add("Application", application())
                .add("OperationId", operationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Application":
            return Optional.ofNullable(clazz.cast(application()));
        case "OperationId":
            return Optional.ofNullable(clazz.cast(operationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Application", APPLICATION_FIELD);
        map.put("OperationId", OPERATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterApplicationResponse, T> g) {
        return obj -> g.apply((RegisterApplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmSapResponse.Builder, SdkPojo, CopyableBuilder<Builder, RegisterApplicationResponse> {
        /**
         * <p>
         * The application registered with AWS Systems Manager for SAP.
         * </p>
         * 
         * @param application
         *        The application registered with AWS Systems Manager for SAP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder application(Application application);

        /**
         * <p>
         * The application registered with AWS Systems Manager for SAP.
         * </p>
         * This is a convenience method that creates an instance of the {@link Application.Builder} avoiding the need to
         * create one manually via {@link Application#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Application.Builder#build()} is called immediately and its result
         * is passed to {@link #application(Application)}.
         * 
         * @param application
         *        a consumer that will call methods on {@link Application.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #application(Application)
         */
        default Builder application(Consumer<Application.Builder> application) {
            return application(Application.builder().applyMutation(application).build());
        }

        /**
         * <p>
         * The ID of the operation.
         * </p>
         * 
         * @param operationId
         *        The ID of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);
    }

    static final class BuilderImpl extends SsmSapResponse.BuilderImpl implements Builder {
        private Application application;

        private String operationId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterApplicationResponse model) {
            super(model);
            application(model.application);
            operationId(model.operationId);
        }

        public final Application.Builder getApplication() {
            return application != null ? application.toBuilder() : null;
        }

        public final void setApplication(Application.BuilderImpl application) {
            this.application = application != null ? application.build() : null;
        }

        @Override
        public final Builder application(Application application) {
            this.application = application;
            return this;
        }

        public final String getOperationId() {
            return operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        @Override
        public RegisterApplicationResponse build() {
            return new RegisterApplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
