/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the SAP application registered with AWS Systems Manager for SAP.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationSummary.Builder, ApplicationSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ApplicationSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> DISCOVERY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiscoveryStatus").getter(getter(ApplicationSummary::discoveryStatusAsString))
            .setter(setter(Builder::discoveryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryStatus").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ApplicationSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ApplicationSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(ApplicationSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            DISCOVERY_STATUS_FIELD, TYPE_FIELD, ARN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String discoveryStatus;

    private final String type;

    private final String arn;

    private final Map<String, String> tags;

    private ApplicationSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.discoveryStatus = builder.discoveryStatus;
        this.type = builder.type;
        this.arn = builder.arn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the application.
     * </p>
     * 
     * @return The ID of the application.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The status of the latest discovery.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #discoveryStatus}
     * will return {@link ApplicationDiscoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #discoveryStatusAsString}.
     * </p>
     * 
     * @return The status of the latest discovery.
     * @see ApplicationDiscoveryStatus
     */
    public final ApplicationDiscoveryStatus discoveryStatus() {
        return ApplicationDiscoveryStatus.fromValue(discoveryStatus);
    }

    /**
     * <p>
     * The status of the latest discovery.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #discoveryStatus}
     * will return {@link ApplicationDiscoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #discoveryStatusAsString}.
     * </p>
     * 
     * @return The status of the latest discovery.
     * @see ApplicationDiscoveryStatus
     */
    public final String discoveryStatusAsString() {
        return discoveryStatus;
    }

    /**
     * <p>
     * The type of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ApplicationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the application.
     * @see ApplicationType
     */
    public final ApplicationType type() {
        return ApplicationType.fromValue(type);
    }

    /**
     * <p>
     * The type of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ApplicationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the application.
     * @see ApplicationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags on the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags on the application.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(discoveryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSummary)) {
            return false;
        }
        ApplicationSummary other = (ApplicationSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(discoveryStatusAsString(), other.discoveryStatusAsString())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(arn(), other.arn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationSummary").add("Id", id()).add("DiscoveryStatus", discoveryStatusAsString())
                .add("Type", typeAsString()).add("Arn", arn()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "DiscoveryStatus":
            return Optional.ofNullable(clazz.cast(discoveryStatusAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("DiscoveryStatus", DISCOVERY_STATUS_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSummary, T> g) {
        return obj -> g.apply((ApplicationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationSummary> {
        /**
         * <p>
         * The ID of the application.
         * </p>
         * 
         * @param id
         *        The ID of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The status of the latest discovery.
         * </p>
         * 
         * @param discoveryStatus
         *        The status of the latest discovery.
         * @see ApplicationDiscoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationDiscoveryStatus
         */
        Builder discoveryStatus(String discoveryStatus);

        /**
         * <p>
         * The status of the latest discovery.
         * </p>
         * 
         * @param discoveryStatus
         *        The status of the latest discovery.
         * @see ApplicationDiscoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationDiscoveryStatus
         */
        Builder discoveryStatus(ApplicationDiscoveryStatus discoveryStatus);

        /**
         * <p>
         * The type of the application.
         * </p>
         * 
         * @param type
         *        The type of the application.
         * @see ApplicationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the application.
         * </p>
         * 
         * @param type
         *        The type of the application.
         * @see ApplicationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationType
         */
        Builder type(ApplicationType type);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The tags on the application.
         * </p>
         * 
         * @param tags
         *        The tags on the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String discoveryStatus;

        private String type;

        private String arn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSummary model) {
            id(model.id);
            discoveryStatus(model.discoveryStatus);
            type(model.type);
            arn(model.arn);
            tags(model.tags);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDiscoveryStatus() {
            return discoveryStatus;
        }

        public final void setDiscoveryStatus(String discoveryStatus) {
            this.discoveryStatus = discoveryStatus;
        }

        @Override
        public final Builder discoveryStatus(String discoveryStatus) {
            this.discoveryStatus = discoveryStatus;
            return this;
        }

        @Override
        public final Builder discoveryStatus(ApplicationDiscoveryStatus discoveryStatus) {
            this.discoveryStatus(discoveryStatus == null ? null : discoveryStatus.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ApplicationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public ApplicationSummary build() {
            return new ApplicationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
