/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information of the IP address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpAddressMember implements SdkPojo, Serializable, ToCopyableBuilder<IpAddressMember.Builder, IpAddressMember> {
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddress").getter(getter(IpAddressMember::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()).build();

    private static final SdkField<Boolean> PRIMARY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Primary").getter(getter(IpAddressMember::primary)).setter(setter(Builder::primary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Primary").build()).build();

    private static final SdkField<String> ALLOCATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AllocationType").getter(getter(IpAddressMember::allocationTypeAsString))
            .setter(setter(Builder::allocationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESS_FIELD,
            PRIMARY_FIELD, ALLOCATION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ipAddress;

    private final Boolean primary;

    private final String allocationType;

    private IpAddressMember(BuilderImpl builder) {
        this.ipAddress = builder.ipAddress;
        this.primary = builder.primary;
        this.allocationType = builder.allocationType;
    }

    /**
     * <p>
     * The IP address.
     * </p>
     * 
     * @return The IP address.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The primary IP address.
     * </p>
     * 
     * @return The primary IP address.
     */
    public final Boolean primary() {
        return primary;
    }

    /**
     * <p>
     * The type of allocation for the IP address.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #allocationType}
     * will return {@link AllocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #allocationTypeAsString}.
     * </p>
     * 
     * @return The type of allocation for the IP address.
     * @see AllocationType
     */
    public final AllocationType allocationType() {
        return AllocationType.fromValue(allocationType);
    }

    /**
     * <p>
     * The type of allocation for the IP address.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #allocationType}
     * will return {@link AllocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #allocationTypeAsString}.
     * </p>
     * 
     * @return The type of allocation for the IP address.
     * @see AllocationType
     */
    public final String allocationTypeAsString() {
        return allocationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(primary());
        hashCode = 31 * hashCode + Objects.hashCode(allocationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpAddressMember)) {
            return false;
        }
        IpAddressMember other = (IpAddressMember) obj;
        return Objects.equals(ipAddress(), other.ipAddress()) && Objects.equals(primary(), other.primary())
                && Objects.equals(allocationTypeAsString(), other.allocationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpAddressMember").add("IpAddress", ipAddress()).add("Primary", primary())
                .add("AllocationType", allocationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "Primary":
            return Optional.ofNullable(clazz.cast(primary()));
        case "AllocationType":
            return Optional.ofNullable(clazz.cast(allocationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IpAddress", IP_ADDRESS_FIELD);
        map.put("Primary", PRIMARY_FIELD);
        map.put("AllocationType", ALLOCATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpAddressMember, T> g) {
        return obj -> g.apply((IpAddressMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpAddressMember> {
        /**
         * <p>
         * The IP address.
         * </p>
         * 
         * @param ipAddress
         *        The IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The primary IP address.
         * </p>
         * 
         * @param primary
         *        The primary IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primary(Boolean primary);

        /**
         * <p>
         * The type of allocation for the IP address.
         * </p>
         * 
         * @param allocationType
         *        The type of allocation for the IP address.
         * @see AllocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllocationType
         */
        Builder allocationType(String allocationType);

        /**
         * <p>
         * The type of allocation for the IP address.
         * </p>
         * 
         * @param allocationType
         *        The type of allocation for the IP address.
         * @see AllocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllocationType
         */
        Builder allocationType(AllocationType allocationType);
    }

    static final class BuilderImpl implements Builder {
        private String ipAddress;

        private Boolean primary;

        private String allocationType;

        private BuilderImpl() {
        }

        private BuilderImpl(IpAddressMember model) {
            ipAddress(model.ipAddress);
            primary(model.primary);
            allocationType(model.allocationType);
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final Boolean getPrimary() {
            return primary;
        }

        public final void setPrimary(Boolean primary) {
            this.primary = primary;
        }

        @Override
        public final Builder primary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        public final String getAllocationType() {
            return allocationType;
        }

        public final void setAllocationType(String allocationType) {
            this.allocationType = allocationType;
        }

        @Override
        public final Builder allocationType(String allocationType) {
            this.allocationType = allocationType;
            return this;
        }

        @Override
        public final Builder allocationType(AllocationType allocationType) {
            this.allocationType(allocationType == null ? null : allocationType.toString());
            return this;
        }

        @Override
        public IpAddressMember build() {
            return new IpAddressMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
