/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmsap.model.ComponentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentInfo> {
    private static final SdkField<String> COMPONENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentType").getter(ComponentInfo.getter(ComponentInfo::componentTypeAsString)).setter(ComponentInfo.setter(Builder::componentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentType").build()}).build();
    private static final SdkField<String> SID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Sid").getter(ComponentInfo.getter(ComponentInfo::sid)).setter(ComponentInfo.setter(Builder::sid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sid").build()}).build();
    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ec2InstanceId").getter(ComponentInfo.getter(ComponentInfo::ec2InstanceId)).setter(ComponentInfo.setter(Builder::ec2InstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_TYPE_FIELD, SID_FIELD, EC2_INSTANCE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComponentInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String componentType;
    private final String sid;
    private final String ec2InstanceId;

    private ComponentInfo(BuilderImpl builder) {
        this.componentType = builder.componentType;
        this.sid = builder.sid;
        this.ec2InstanceId = builder.ec2InstanceId;
    }

    public final ComponentType componentType() {
        return ComponentType.fromValue(this.componentType);
    }

    public final String componentTypeAsString() {
        return this.componentType;
    }

    public final String sid() {
        return this.sid;
    }

    public final String ec2InstanceId() {
        return this.ec2InstanceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sid());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentInfo)) {
            return false;
        }
        ComponentInfo other = (ComponentInfo)obj;
        return Objects.equals(this.componentTypeAsString(), other.componentTypeAsString()) && Objects.equals(this.sid(), other.sid()) && Objects.equals(this.ec2InstanceId(), other.ec2InstanceId());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentInfo").add("ComponentType", (Object)this.componentTypeAsString()).add("Sid", (Object)this.sid()).add("Ec2InstanceId", (Object)this.ec2InstanceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComponentType": {
                return Optional.ofNullable(clazz.cast(this.componentTypeAsString()));
            }
            case "Sid": {
                return Optional.ofNullable(clazz.cast(this.sid()));
            }
            case "Ec2InstanceId": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ComponentType", COMPONENT_TYPE_FIELD);
        map.put("Sid", SID_FIELD);
        map.put("Ec2InstanceId", EC2_INSTANCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentInfo, T> g) {
        return obj -> g.apply((ComponentInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String componentType;
        private String sid;
        private String ec2InstanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentInfo model) {
            this.componentType(model.componentType);
            this.sid(model.sid);
            this.ec2InstanceId(model.ec2InstanceId);
        }

        public final String getComponentType() {
            return this.componentType;
        }

        public final void setComponentType(String componentType) {
            this.componentType = componentType;
        }

        @Override
        public final Builder componentType(String componentType) {
            this.componentType = componentType;
            return this;
        }

        @Override
        public final Builder componentType(ComponentType componentType) {
            this.componentType(componentType == null ? null : componentType.toString());
            return this;
        }

        public final String getSid() {
            return this.sid;
        }

        public final void setSid(String sid) {
            this.sid = sid;
        }

        @Override
        public final Builder sid(String sid) {
            this.sid = sid;
            return this;
        }

        public final String getEc2InstanceId() {
            return this.ec2InstanceId;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public ComponentInfo build() {
            return new ComponentInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentInfo> {
        public Builder componentType(String var1);

        public Builder componentType(ComponentType var1);

        public Builder sid(String var1);

        public Builder ec2InstanceId(String var1);
    }
}

