/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.ssmsap.model.ConflictException;
import software.amazon.awssdk.services.ssmsap.model.DeleteResourcePermissionRequest;
import software.amazon.awssdk.services.ssmsap.model.DeleteResourcePermissionResponse;
import software.amazon.awssdk.services.ssmsap.model.DeregisterApplicationRequest;
import software.amazon.awssdk.services.ssmsap.model.DeregisterApplicationResponse;
import software.amazon.awssdk.services.ssmsap.model.GetApplicationRequest;
import software.amazon.awssdk.services.ssmsap.model.GetApplicationResponse;
import software.amazon.awssdk.services.ssmsap.model.GetComponentRequest;
import software.amazon.awssdk.services.ssmsap.model.GetComponentResponse;
import software.amazon.awssdk.services.ssmsap.model.GetConfigurationCheckOperationRequest;
import software.amazon.awssdk.services.ssmsap.model.GetConfigurationCheckOperationResponse;
import software.amazon.awssdk.services.ssmsap.model.GetDatabaseRequest;
import software.amazon.awssdk.services.ssmsap.model.GetDatabaseResponse;
import software.amazon.awssdk.services.ssmsap.model.GetOperationRequest;
import software.amazon.awssdk.services.ssmsap.model.GetOperationResponse;
import software.amazon.awssdk.services.ssmsap.model.GetResourcePermissionRequest;
import software.amazon.awssdk.services.ssmsap.model.GetResourcePermissionResponse;
import software.amazon.awssdk.services.ssmsap.model.InternalServerException;
import software.amazon.awssdk.services.ssmsap.model.ListApplicationsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListApplicationsResponse;
import software.amazon.awssdk.services.ssmsap.model.ListComponentsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListComponentsResponse;
import software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckDefinitionsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckDefinitionsResponse;
import software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckOperationsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckOperationsResponse;
import software.amazon.awssdk.services.ssmsap.model.ListDatabasesRequest;
import software.amazon.awssdk.services.ssmsap.model.ListDatabasesResponse;
import software.amazon.awssdk.services.ssmsap.model.ListOperationEventsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListOperationEventsResponse;
import software.amazon.awssdk.services.ssmsap.model.ListOperationsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListOperationsResponse;
import software.amazon.awssdk.services.ssmsap.model.ListSubCheckResultsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListSubCheckResultsResponse;
import software.amazon.awssdk.services.ssmsap.model.ListSubCheckRuleResultsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListSubCheckRuleResultsResponse;
import software.amazon.awssdk.services.ssmsap.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ssmsap.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ssmsap.model.PutResourcePermissionRequest;
import software.amazon.awssdk.services.ssmsap.model.PutResourcePermissionResponse;
import software.amazon.awssdk.services.ssmsap.model.RegisterApplicationRequest;
import software.amazon.awssdk.services.ssmsap.model.RegisterApplicationResponse;
import software.amazon.awssdk.services.ssmsap.model.ResourceNotFoundException;
import software.amazon.awssdk.services.ssmsap.model.SsmSapException;
import software.amazon.awssdk.services.ssmsap.model.StartApplicationRefreshRequest;
import software.amazon.awssdk.services.ssmsap.model.StartApplicationRefreshResponse;
import software.amazon.awssdk.services.ssmsap.model.StartApplicationRequest;
import software.amazon.awssdk.services.ssmsap.model.StartApplicationResponse;
import software.amazon.awssdk.services.ssmsap.model.StartConfigurationChecksRequest;
import software.amazon.awssdk.services.ssmsap.model.StartConfigurationChecksResponse;
import software.amazon.awssdk.services.ssmsap.model.StopApplicationRequest;
import software.amazon.awssdk.services.ssmsap.model.StopApplicationResponse;
import software.amazon.awssdk.services.ssmsap.model.TagResourceRequest;
import software.amazon.awssdk.services.ssmsap.model.TagResourceResponse;
import software.amazon.awssdk.services.ssmsap.model.UnauthorizedException;
import software.amazon.awssdk.services.ssmsap.model.UntagResourceRequest;
import software.amazon.awssdk.services.ssmsap.model.UntagResourceResponse;
import software.amazon.awssdk.services.ssmsap.model.UpdateApplicationSettingsRequest;
import software.amazon.awssdk.services.ssmsap.model.UpdateApplicationSettingsResponse;
import software.amazon.awssdk.services.ssmsap.model.ValidationException;
import software.amazon.awssdk.services.ssmsap.paginators.ListApplicationsIterable;
import software.amazon.awssdk.services.ssmsap.paginators.ListComponentsIterable;
import software.amazon.awssdk.services.ssmsap.paginators.ListConfigurationCheckDefinitionsIterable;
import software.amazon.awssdk.services.ssmsap.paginators.ListConfigurationCheckOperationsIterable;
import software.amazon.awssdk.services.ssmsap.paginators.ListDatabasesIterable;
import software.amazon.awssdk.services.ssmsap.paginators.ListOperationEventsIterable;
import software.amazon.awssdk.services.ssmsap.paginators.ListOperationsIterable;
import software.amazon.awssdk.services.ssmsap.paginators.ListSubCheckResultsIterable;
import software.amazon.awssdk.services.ssmsap.paginators.ListSubCheckRuleResultsIterable;

/**
 * Service client for accessing SsmSap. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * This API reference provides descriptions, syntax, and other details about each of the actions and data types for AWS
 * Systems Manager for SAP. The topic for each action shows the API request parameters and responses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SsmSapClient extends AwsClient {
    String SERVICE_NAME = "ssm-sap";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "ssm-sap";

    /**
     * <p>
     * Removes permissions associated with the target database.
     * </p>
     *
     * @param deleteResourcePermissionRequest
     * @return Result of the DeleteResourcePermission operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.DeleteResourcePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/DeleteResourcePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePermissionResponse deleteResourcePermission(
            DeleteResourcePermissionRequest deleteResourcePermissionRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes permissions associated with the target database.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePermissionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteResourcePermissionRequest#builder()}
     * </p>
     *
     * @param deleteResourcePermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.DeleteResourcePermissionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResourcePermission operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.DeleteResourcePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/DeleteResourcePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePermissionResponse deleteResourcePermission(
            Consumer<DeleteResourcePermissionRequest.Builder> deleteResourcePermissionRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return deleteResourcePermission(DeleteResourcePermissionRequest.builder().applyMutation(deleteResourcePermissionRequest)
                .build());
    }

    /**
     * <p>
     * Deregister an SAP application with AWS Systems Manager for SAP. This action does not aﬀect the existing setup of
     * your SAP workloads on Amazon EC2.
     * </p>
     *
     * @param deregisterApplicationRequest
     * @return Result of the DeregisterApplication operation returned by the service.
     * @throws UnauthorizedException
     *         The request is not authorized.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.DeregisterApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/DeregisterApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default DeregisterApplicationResponse deregisterApplication(DeregisterApplicationRequest deregisterApplicationRequest)
            throws UnauthorizedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregister an SAP application with AWS Systems Manager for SAP. This action does not aﬀect the existing setup of
     * your SAP workloads on Amazon EC2.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link DeregisterApplicationRequest#builder()}
     * </p>
     *
     * @param deregisterApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.DeregisterApplicationRequest.Builder} to create a
     *        request.
     * @return Result of the DeregisterApplication operation returned by the service.
     * @throws UnauthorizedException
     *         The request is not authorized.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.DeregisterApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/DeregisterApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default DeregisterApplicationResponse deregisterApplication(
            Consumer<DeregisterApplicationRequest.Builder> deregisterApplicationRequest) throws UnauthorizedException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return deregisterApplication(DeregisterApplicationRequest.builder().applyMutation(deregisterApplicationRequest).build());
    }

    /**
     * <p>
     * Gets an application registered with AWS Systems Manager for SAP. It also returns the components of the
     * application.
     * </p>
     *
     * @param getApplicationRequest
     * @return Result of the GetApplication operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default GetApplicationResponse getApplication(GetApplicationRequest getApplicationRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an application registered with AWS Systems Manager for SAP. It also returns the components of the
     * application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationRequest.Builder} avoiding the need to
     * create one manually via {@link GetApplicationRequest#builder()}
     * </p>
     *
     * @param getApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.GetApplicationRequest.Builder} to create a request.
     * @return Result of the GetApplication operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default GetApplicationResponse getApplication(Consumer<GetApplicationRequest.Builder> getApplicationRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return getApplication(GetApplicationRequest.builder().applyMutation(getApplicationRequest).build());
    }

    /**
     * <p>
     * Gets the component of an application registered with AWS Systems Manager for SAP.
     * </p>
     *
     * @param getComponentRequest
     * @return Result of the GetComponent operation returned by the service.
     * @throws UnauthorizedException
     *         The request is not authorized.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.GetComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/GetComponent" target="_top">AWS API
     *      Documentation</a>
     */
    default GetComponentResponse getComponent(GetComponentRequest getComponentRequest) throws UnauthorizedException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the component of an application registered with AWS Systems Manager for SAP.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComponentRequest.Builder} avoiding the need to
     * create one manually via {@link GetComponentRequest#builder()}
     * </p>
     *
     * @param getComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.GetComponentRequest.Builder} to create a request.
     * @return Result of the GetComponent operation returned by the service.
     * @throws UnauthorizedException
     *         The request is not authorized.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.GetComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/GetComponent" target="_top">AWS API
     *      Documentation</a>
     */
    default GetComponentResponse getComponent(Consumer<GetComponentRequest.Builder> getComponentRequest)
            throws UnauthorizedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            SsmSapException {
        return getComponent(GetComponentRequest.builder().applyMutation(getComponentRequest).build());
    }

    /**
     * <p>
     * Gets the details of a configuration check operation by specifying the operation ID.
     * </p>
     *
     * @param getConfigurationCheckOperationRequest
     * @return Result of the GetConfigurationCheckOperation operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.GetConfigurationCheckOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/GetConfigurationCheckOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfigurationCheckOperationResponse getConfigurationCheckOperation(
            GetConfigurationCheckOperationRequest getConfigurationCheckOperationRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of a configuration check operation by specifying the operation ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfigurationCheckOperationRequest.Builder}
     * avoiding the need to create one manually via {@link GetConfigurationCheckOperationRequest#builder()}
     * </p>
     *
     * @param getConfigurationCheckOperationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.GetConfigurationCheckOperationRequest.Builder} to
     *        create a request.
     * @return Result of the GetConfigurationCheckOperation operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.GetConfigurationCheckOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/GetConfigurationCheckOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfigurationCheckOperationResponse getConfigurationCheckOperation(
            Consumer<GetConfigurationCheckOperationRequest.Builder> getConfigurationCheckOperationRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return getConfigurationCheckOperation(GetConfigurationCheckOperationRequest.builder()
                .applyMutation(getConfigurationCheckOperationRequest).build());
    }

    /**
     * <p>
     * Gets the SAP HANA database of an application registered with AWS Systems Manager for SAP.
     * </p>
     *
     * @param getDatabaseRequest
     * @return Result of the GetDatabase operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.GetDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/GetDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDatabaseResponse getDatabase(GetDatabaseRequest getDatabaseRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the SAP HANA database of an application registered with AWS Systems Manager for SAP.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDatabaseRequest.Builder} avoiding the need to
     * create one manually via {@link GetDatabaseRequest#builder()}
     * </p>
     *
     * @param getDatabaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.GetDatabaseRequest.Builder} to create a request.
     * @return Result of the GetDatabase operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.GetDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/GetDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDatabaseResponse getDatabase(Consumer<GetDatabaseRequest.Builder> getDatabaseRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return getDatabase(GetDatabaseRequest.builder().applyMutation(getDatabaseRequest).build());
    }

    /**
     * <p>
     * Gets the details of an operation by specifying the operation ID.
     * </p>
     *
     * @param getOperationRequest
     * @return Result of the GetOperation operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.GetOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/GetOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOperationResponse getOperation(GetOperationRequest getOperationRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of an operation by specifying the operation ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOperationRequest.Builder} avoiding the need to
     * create one manually via {@link GetOperationRequest#builder()}
     * </p>
     *
     * @param getOperationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.GetOperationRequest.Builder} to create a request.
     * @return Result of the GetOperation operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.GetOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/GetOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOperationResponse getOperation(Consumer<GetOperationRequest.Builder> getOperationRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return getOperation(GetOperationRequest.builder().applyMutation(getOperationRequest).build());
    }

    /**
     * <p>
     * Gets permissions associated with the target database.
     * </p>
     *
     * @param getResourcePermissionRequest
     * @return Result of the GetResourcePermission operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.GetResourcePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/GetResourcePermission" target="_top">AWS
     *      API Documentation</a>
     */
    default GetResourcePermissionResponse getResourcePermission(GetResourcePermissionRequest getResourcePermissionRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets permissions associated with the target database.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePermissionRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourcePermissionRequest#builder()}
     * </p>
     *
     * @param getResourcePermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.GetResourcePermissionRequest.Builder} to create a
     *        request.
     * @return Result of the GetResourcePermission operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.GetResourcePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/GetResourcePermission" target="_top">AWS
     *      API Documentation</a>
     */
    default GetResourcePermissionResponse getResourcePermission(
            Consumer<GetResourcePermissionRequest.Builder> getResourcePermissionRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return getResourcePermission(GetResourcePermissionRequest.builder().applyMutation(getResourcePermissionRequest).build());
    }

    /**
     * <p>
     * Lists all the applications registered with AWS Systems Manager for SAP.
     * </p>
     *
     * @param listApplicationsRequest
     * @return Result of the ListApplications operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListApplications" target="_top">AWS API
     *      Documentation</a>
     */
    default ListApplicationsResponse listApplications(ListApplicationsRequest listApplicationsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the applications registered with AWS Systems Manager for SAP.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.ListApplicationsRequest.Builder} to create a request.
     * @return Result of the ListApplications operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListApplications" target="_top">AWS API
     *      Documentation</a>
     */
    default ListApplicationsResponse listApplications(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmSapException {
        return listApplications(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.ssmsap.model.ListApplicationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmsap.paginators.ListApplicationsIterable responses = client
     *             .listApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmsap.model.ListApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.ssmsap.model.ListApplicationsRequest)} operation.</b>
     * </p>
     *
     * @param listApplicationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListApplications" target="_top">AWS API
     *      Documentation</a>
     */
    default ListApplicationsIterable listApplicationsPaginator(ListApplicationsRequest listApplicationsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmSapException {
        return new ListApplicationsIterable(this, listApplicationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.ssmsap.model.ListApplicationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmsap.paginators.ListApplicationsIterable responses = client
     *             .listApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmsap.model.ListApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.ssmsap.model.ListApplicationsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.ListApplicationsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListApplications" target="_top">AWS API
     *      Documentation</a>
     */
    default ListApplicationsIterable listApplicationsPaginator(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmSapException {
        return listApplicationsPaginator(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Lists all the components registered with AWS Systems Manager for SAP.
     * </p>
     *
     * @param listComponentsRequest
     * @return Result of the ListComponents operation returned by the service.
     * @throws UnauthorizedException
     *         The request is not authorized.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListComponents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComponentsResponse listComponents(ListComponentsRequest listComponentsRequest) throws UnauthorizedException,
            ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the components registered with AWS Systems Manager for SAP.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListComponentsRequest#builder()}
     * </p>
     *
     * @param listComponentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.ListComponentsRequest.Builder} to create a request.
     * @return Result of the ListComponents operation returned by the service.
     * @throws UnauthorizedException
     *         The request is not authorized.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListComponents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComponentsResponse listComponents(Consumer<ListComponentsRequest.Builder> listComponentsRequest)
            throws UnauthorizedException, ResourceNotFoundException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, SsmSapException {
        return listComponents(ListComponentsRequest.builder().applyMutation(listComponentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listComponents(software.amazon.awssdk.services.ssmsap.model.ListComponentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmsap.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmsap.model.ListComponentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponents(software.amazon.awssdk.services.ssmsap.model.ListComponentsRequest)} operation.</b>
     * </p>
     *
     * @param listComponentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         The request is not authorized.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListComponents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComponentsIterable listComponentsPaginator(ListComponentsRequest listComponentsRequest)
            throws UnauthorizedException, ResourceNotFoundException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, SsmSapException {
        return new ListComponentsIterable(this, listComponentsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listComponents(software.amazon.awssdk.services.ssmsap.model.ListComponentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmsap.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmsap.model.ListComponentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponents(software.amazon.awssdk.services.ssmsap.model.ListComponentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListComponentsRequest#builder()}
     * </p>
     *
     * @param listComponentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.ListComponentsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         The request is not authorized.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListComponents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComponentsIterable listComponentsPaginator(Consumer<ListComponentsRequest.Builder> listComponentsRequest)
            throws UnauthorizedException, ResourceNotFoundException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, SsmSapException {
        return listComponentsPaginator(ListComponentsRequest.builder().applyMutation(listComponentsRequest).build());
    }

    /**
     * <p>
     * Lists all configuration check types supported by AWS Systems Manager for SAP.
     * </p>
     *
     * @param listConfigurationCheckDefinitionsRequest
     * @return Result of the ListConfigurationCheckDefinitions operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListConfigurationCheckDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListConfigurationCheckDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationCheckDefinitionsResponse listConfigurationCheckDefinitions(
            ListConfigurationCheckDefinitionsRequest listConfigurationCheckDefinitionsRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all configuration check types supported by AWS Systems Manager for SAP.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationCheckDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConfigurationCheckDefinitionsRequest#builder()}
     * </p>
     *
     * @param listConfigurationCheckDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckDefinitionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListConfigurationCheckDefinitions operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListConfigurationCheckDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListConfigurationCheckDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationCheckDefinitionsResponse listConfigurationCheckDefinitions(
            Consumer<ListConfigurationCheckDefinitionsRequest.Builder> listConfigurationCheckDefinitionsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return listConfigurationCheckDefinitions(ListConfigurationCheckDefinitionsRequest.builder()
                .applyMutation(listConfigurationCheckDefinitionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurationCheckDefinitions(software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListConfigurationCheckDefinitionsIterable responses = client.listConfigurationCheckDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmsap.paginators.ListConfigurationCheckDefinitionsIterable responses = client
     *             .listConfigurationCheckDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListConfigurationCheckDefinitionsIterable responses = client.listConfigurationCheckDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationCheckDefinitions(software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfigurationCheckDefinitionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListConfigurationCheckDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListConfigurationCheckDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationCheckDefinitionsIterable listConfigurationCheckDefinitionsPaginator(
            ListConfigurationCheckDefinitionsRequest listConfigurationCheckDefinitionsRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return new ListConfigurationCheckDefinitionsIterable(this, listConfigurationCheckDefinitionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurationCheckDefinitions(software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListConfigurationCheckDefinitionsIterable responses = client.listConfigurationCheckDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmsap.paginators.ListConfigurationCheckDefinitionsIterable responses = client
     *             .listConfigurationCheckDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListConfigurationCheckDefinitionsIterable responses = client.listConfigurationCheckDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationCheckDefinitions(software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckDefinitionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationCheckDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConfigurationCheckDefinitionsRequest#builder()}
     * </p>
     *
     * @param listConfigurationCheckDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckDefinitionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListConfigurationCheckDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListConfigurationCheckDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationCheckDefinitionsIterable listConfigurationCheckDefinitionsPaginator(
            Consumer<ListConfigurationCheckDefinitionsRequest.Builder> listConfigurationCheckDefinitionsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return listConfigurationCheckDefinitionsPaginator(ListConfigurationCheckDefinitionsRequest.builder()
                .applyMutation(listConfigurationCheckDefinitionsRequest).build());
    }

    /**
     * <p>
     * Lists the configuration check operations performed by AWS Systems Manager for SAP.
     * </p>
     *
     * @param listConfigurationCheckOperationsRequest
     * @return Result of the ListConfigurationCheckOperations operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListConfigurationCheckOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListConfigurationCheckOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationCheckOperationsResponse listConfigurationCheckOperations(
            ListConfigurationCheckOperationsRequest listConfigurationCheckOperationsRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the configuration check operations performed by AWS Systems Manager for SAP.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationCheckOperationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConfigurationCheckOperationsRequest#builder()}
     * </p>
     *
     * @param listConfigurationCheckOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckOperationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListConfigurationCheckOperations operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListConfigurationCheckOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListConfigurationCheckOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationCheckOperationsResponse listConfigurationCheckOperations(
            Consumer<ListConfigurationCheckOperationsRequest.Builder> listConfigurationCheckOperationsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmSapException {
        return listConfigurationCheckOperations(ListConfigurationCheckOperationsRequest.builder()
                .applyMutation(listConfigurationCheckOperationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurationCheckOperations(software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListConfigurationCheckOperationsIterable responses = client.listConfigurationCheckOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmsap.paginators.ListConfigurationCheckOperationsIterable responses = client
     *             .listConfigurationCheckOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListConfigurationCheckOperationsIterable responses = client.listConfigurationCheckOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationCheckOperations(software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckOperationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfigurationCheckOperationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListConfigurationCheckOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListConfigurationCheckOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationCheckOperationsIterable listConfigurationCheckOperationsPaginator(
            ListConfigurationCheckOperationsRequest listConfigurationCheckOperationsRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return new ListConfigurationCheckOperationsIterable(this, listConfigurationCheckOperationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurationCheckOperations(software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListConfigurationCheckOperationsIterable responses = client.listConfigurationCheckOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmsap.paginators.ListConfigurationCheckOperationsIterable responses = client
     *             .listConfigurationCheckOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListConfigurationCheckOperationsIterable responses = client.listConfigurationCheckOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationCheckOperations(software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckOperationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationCheckOperationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConfigurationCheckOperationsRequest#builder()}
     * </p>
     *
     * @param listConfigurationCheckOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckOperationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListConfigurationCheckOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListConfigurationCheckOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationCheckOperationsIterable listConfigurationCheckOperationsPaginator(
            Consumer<ListConfigurationCheckOperationsRequest.Builder> listConfigurationCheckOperationsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmSapException {
        return listConfigurationCheckOperationsPaginator(ListConfigurationCheckOperationsRequest.builder()
                .applyMutation(listConfigurationCheckOperationsRequest).build());
    }

    /**
     * <p>
     * Lists the SAP HANA databases of an application registered with AWS Systems Manager for SAP.
     * </p>
     *
     * @param listDatabasesRequest
     * @return Result of the ListDatabases operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatabasesResponse listDatabases(ListDatabasesRequest listDatabasesRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the SAP HANA databases of an application registered with AWS Systems Manager for SAP.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatabasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatabasesRequest#builder()}
     * </p>
     *
     * @param listDatabasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.ListDatabasesRequest.Builder} to create a request.
     * @return Result of the ListDatabases operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatabasesResponse listDatabases(Consumer<ListDatabasesRequest.Builder> listDatabasesRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmSapException {
        return listDatabases(ListDatabasesRequest.builder().applyMutation(listDatabasesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listDatabases(software.amazon.awssdk.services.ssmsap.model.ListDatabasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListDatabasesIterable responses = client.listDatabasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmsap.paginators.ListDatabasesIterable responses = client.listDatabasesPaginator(request);
     *     for (software.amazon.awssdk.services.ssmsap.model.ListDatabasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListDatabasesIterable responses = client.listDatabasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatabases(software.amazon.awssdk.services.ssmsap.model.ListDatabasesRequest)} operation.</b>
     * </p>
     *
     * @param listDatabasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatabasesIterable listDatabasesPaginator(ListDatabasesRequest listDatabasesRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmSapException {
        return new ListDatabasesIterable(this, listDatabasesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listDatabases(software.amazon.awssdk.services.ssmsap.model.ListDatabasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListDatabasesIterable responses = client.listDatabasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmsap.paginators.ListDatabasesIterable responses = client.listDatabasesPaginator(request);
     *     for (software.amazon.awssdk.services.ssmsap.model.ListDatabasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListDatabasesIterable responses = client.listDatabasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatabases(software.amazon.awssdk.services.ssmsap.model.ListDatabasesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatabasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatabasesRequest#builder()}
     * </p>
     *
     * @param listDatabasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.ListDatabasesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatabasesIterable listDatabasesPaginator(Consumer<ListDatabasesRequest.Builder> listDatabasesRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmSapException {
        return listDatabasesPaginator(ListDatabasesRequest.builder().applyMutation(listDatabasesRequest).build());
    }

    /**
     * <p>
     * Returns a list of operations events.
     * </p>
     * <p>
     * Available parameters include <code>OperationID</code>, as well as optional parameters <code>MaxResults</code>,
     * <code>NextToken</code>, and <code>Filters</code>.
     * </p>
     *
     * @param listOperationEventsRequest
     * @return Result of the ListOperationEvents operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListOperationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListOperationEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOperationEventsResponse listOperationEvents(ListOperationEventsRequest listOperationEventsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of operations events.
     * </p>
     * <p>
     * Available parameters include <code>OperationID</code>, as well as optional parameters <code>MaxResults</code>,
     * <code>NextToken</code>, and <code>Filters</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOperationEventsRequest.Builder} avoiding the
     * need to create one manually via {@link ListOperationEventsRequest#builder()}
     * </p>
     *
     * @param listOperationEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.ListOperationEventsRequest.Builder} to create a
     *        request.
     * @return Result of the ListOperationEvents operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListOperationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListOperationEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOperationEventsResponse listOperationEvents(
            Consumer<ListOperationEventsRequest.Builder> listOperationEventsRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return listOperationEvents(ListOperationEventsRequest.builder().applyMutation(listOperationEventsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOperationEvents(software.amazon.awssdk.services.ssmsap.model.ListOperationEventsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListOperationEventsIterable responses = client.listOperationEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmsap.paginators.ListOperationEventsIterable responses = client
     *             .listOperationEventsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmsap.model.ListOperationEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListOperationEventsIterable responses = client.listOperationEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOperationEvents(software.amazon.awssdk.services.ssmsap.model.ListOperationEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOperationEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListOperationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListOperationEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOperationEventsIterable listOperationEventsPaginator(ListOperationEventsRequest listOperationEventsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return new ListOperationEventsIterable(this, listOperationEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOperationEvents(software.amazon.awssdk.services.ssmsap.model.ListOperationEventsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListOperationEventsIterable responses = client.listOperationEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmsap.paginators.ListOperationEventsIterable responses = client
     *             .listOperationEventsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmsap.model.ListOperationEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListOperationEventsIterable responses = client.listOperationEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOperationEvents(software.amazon.awssdk.services.ssmsap.model.ListOperationEventsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOperationEventsRequest.Builder} avoiding the
     * need to create one manually via {@link ListOperationEventsRequest#builder()}
     * </p>
     *
     * @param listOperationEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.ListOperationEventsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListOperationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListOperationEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOperationEventsIterable listOperationEventsPaginator(
            Consumer<ListOperationEventsRequest.Builder> listOperationEventsRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return listOperationEventsPaginator(ListOperationEventsRequest.builder().applyMutation(listOperationEventsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the operations performed by AWS Systems Manager for SAP.
     * </p>
     *
     * @param listOperationsRequest
     * @return Result of the ListOperations operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListOperations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOperationsResponse listOperations(ListOperationsRequest listOperationsRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the operations performed by AWS Systems Manager for SAP.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOperationsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOperationsRequest#builder()}
     * </p>
     *
     * @param listOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.ListOperationsRequest.Builder} to create a request.
     * @return Result of the ListOperations operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListOperations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOperationsResponse listOperations(Consumer<ListOperationsRequest.Builder> listOperationsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return listOperations(ListOperationsRequest.builder().applyMutation(listOperationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listOperations(software.amazon.awssdk.services.ssmsap.model.ListOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListOperationsIterable responses = client.listOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmsap.paginators.ListOperationsIterable responses = client.listOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmsap.model.ListOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListOperationsIterable responses = client.listOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOperations(software.amazon.awssdk.services.ssmsap.model.ListOperationsRequest)} operation.</b>
     * </p>
     *
     * @param listOperationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListOperations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOperationsIterable listOperationsPaginator(ListOperationsRequest listOperationsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return new ListOperationsIterable(this, listOperationsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listOperations(software.amazon.awssdk.services.ssmsap.model.ListOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListOperationsIterable responses = client.listOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmsap.paginators.ListOperationsIterable responses = client.listOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmsap.model.ListOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListOperationsIterable responses = client.listOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOperations(software.amazon.awssdk.services.ssmsap.model.ListOperationsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOperationsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOperationsRequest#builder()}
     * </p>
     *
     * @param listOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.ListOperationsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListOperations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOperationsIterable listOperationsPaginator(Consumer<ListOperationsRequest.Builder> listOperationsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return listOperationsPaginator(ListOperationsRequest.builder().applyMutation(listOperationsRequest).build());
    }

    /**
     * <p>
     * Lists the sub-check results of a specified configuration check operation.
     * </p>
     *
     * @param listSubCheckResultsRequest
     * @return Result of the ListSubCheckResults operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListSubCheckResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListSubCheckResults" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubCheckResultsResponse listSubCheckResults(ListSubCheckResultsRequest listSubCheckResultsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the sub-check results of a specified configuration check operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubCheckResultsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSubCheckResultsRequest#builder()}
     * </p>
     *
     * @param listSubCheckResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.ListSubCheckResultsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSubCheckResults operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListSubCheckResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListSubCheckResults" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubCheckResultsResponse listSubCheckResults(
            Consumer<ListSubCheckResultsRequest.Builder> listSubCheckResultsRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return listSubCheckResults(ListSubCheckResultsRequest.builder().applyMutation(listSubCheckResultsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubCheckResults(software.amazon.awssdk.services.ssmsap.model.ListSubCheckResultsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListSubCheckResultsIterable responses = client.listSubCheckResultsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmsap.paginators.ListSubCheckResultsIterable responses = client
     *             .listSubCheckResultsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmsap.model.ListSubCheckResultsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListSubCheckResultsIterable responses = client.listSubCheckResultsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubCheckResults(software.amazon.awssdk.services.ssmsap.model.ListSubCheckResultsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSubCheckResultsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListSubCheckResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListSubCheckResults" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubCheckResultsIterable listSubCheckResultsPaginator(ListSubCheckResultsRequest listSubCheckResultsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return new ListSubCheckResultsIterable(this, listSubCheckResultsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubCheckResults(software.amazon.awssdk.services.ssmsap.model.ListSubCheckResultsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListSubCheckResultsIterable responses = client.listSubCheckResultsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmsap.paginators.ListSubCheckResultsIterable responses = client
     *             .listSubCheckResultsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmsap.model.ListSubCheckResultsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListSubCheckResultsIterable responses = client.listSubCheckResultsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubCheckResults(software.amazon.awssdk.services.ssmsap.model.ListSubCheckResultsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubCheckResultsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSubCheckResultsRequest#builder()}
     * </p>
     *
     * @param listSubCheckResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.ListSubCheckResultsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListSubCheckResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListSubCheckResults" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubCheckResultsIterable listSubCheckResultsPaginator(
            Consumer<ListSubCheckResultsRequest.Builder> listSubCheckResultsRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return listSubCheckResultsPaginator(ListSubCheckResultsRequest.builder().applyMutation(listSubCheckResultsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the rules of a specified sub-check belonging to a configuration check operation.
     * </p>
     *
     * @param listSubCheckRuleResultsRequest
     * @return Result of the ListSubCheckRuleResults operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListSubCheckRuleResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListSubCheckRuleResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubCheckRuleResultsResponse listSubCheckRuleResults(ListSubCheckRuleResultsRequest listSubCheckRuleResultsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the rules of a specified sub-check belonging to a configuration check operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubCheckRuleResultsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSubCheckRuleResultsRequest#builder()}
     * </p>
     *
     * @param listSubCheckRuleResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.ListSubCheckRuleResultsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSubCheckRuleResults operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListSubCheckRuleResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListSubCheckRuleResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubCheckRuleResultsResponse listSubCheckRuleResults(
            Consumer<ListSubCheckRuleResultsRequest.Builder> listSubCheckRuleResultsRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return listSubCheckRuleResults(ListSubCheckRuleResultsRequest.builder().applyMutation(listSubCheckRuleResultsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubCheckRuleResults(software.amazon.awssdk.services.ssmsap.model.ListSubCheckRuleResultsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListSubCheckRuleResultsIterable responses = client.listSubCheckRuleResultsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmsap.paginators.ListSubCheckRuleResultsIterable responses = client
     *             .listSubCheckRuleResultsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmsap.model.ListSubCheckRuleResultsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListSubCheckRuleResultsIterable responses = client.listSubCheckRuleResultsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubCheckRuleResults(software.amazon.awssdk.services.ssmsap.model.ListSubCheckRuleResultsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSubCheckRuleResultsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListSubCheckRuleResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListSubCheckRuleResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubCheckRuleResultsIterable listSubCheckRuleResultsPaginator(
            ListSubCheckRuleResultsRequest listSubCheckRuleResultsRequest) throws ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, SsmSapException {
        return new ListSubCheckRuleResultsIterable(this, listSubCheckRuleResultsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubCheckRuleResults(software.amazon.awssdk.services.ssmsap.model.ListSubCheckRuleResultsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListSubCheckRuleResultsIterable responses = client.listSubCheckRuleResultsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmsap.paginators.ListSubCheckRuleResultsIterable responses = client
     *             .listSubCheckRuleResultsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmsap.model.ListSubCheckRuleResultsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmsap.paginators.ListSubCheckRuleResultsIterable responses = client.listSubCheckRuleResultsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubCheckRuleResults(software.amazon.awssdk.services.ssmsap.model.ListSubCheckRuleResultsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubCheckRuleResultsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSubCheckRuleResultsRequest#builder()}
     * </p>
     *
     * @param listSubCheckRuleResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.ListSubCheckRuleResultsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListSubCheckRuleResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListSubCheckRuleResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubCheckRuleResultsIterable listSubCheckRuleResultsPaginator(
            Consumer<ListSubCheckRuleResultsRequest.Builder> listSubCheckRuleResultsRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return listSubCheckRuleResultsPaginator(ListSubCheckRuleResultsRequest.builder()
                .applyMutation(listSubCheckRuleResultsRequest).build());
    }

    /**
     * <p>
     * Lists all tags on an SAP HANA application and/or database registered with AWS Systems Manager for SAP.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         A conflict has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException,
            SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags on an SAP HANA application and/or database registered with AWS Systems Manager for SAP.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         A conflict has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, SsmSapException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds permissions to the target database.
     * </p>
     *
     * @param putResourcePermissionRequest
     * @return Result of the PutResourcePermission operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.PutResourcePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/PutResourcePermission" target="_top">AWS
     *      API Documentation</a>
     */
    default PutResourcePermissionResponse putResourcePermission(PutResourcePermissionRequest putResourcePermissionRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds permissions to the target database.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePermissionRequest.Builder} avoiding the
     * need to create one manually via {@link PutResourcePermissionRequest#builder()}
     * </p>
     *
     * @param putResourcePermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.PutResourcePermissionRequest.Builder} to create a
     *        request.
     * @return Result of the PutResourcePermission operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.PutResourcePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/PutResourcePermission" target="_top">AWS
     *      API Documentation</a>
     */
    default PutResourcePermissionResponse putResourcePermission(
            Consumer<PutResourcePermissionRequest.Builder> putResourcePermissionRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return putResourcePermission(PutResourcePermissionRequest.builder().applyMutation(putResourcePermissionRequest).build());
    }

    /**
     * <p>
     * Register an SAP application with AWS Systems Manager for SAP. You must meet the following requirements before
     * registering.
     * </p>
     * <p>
     * The SAP application you want to register with AWS Systems Manager for SAP is running on Amazon EC2.
     * </p>
     * <p>
     * AWS Systems Manager Agent must be setup on an Amazon EC2 instance along with the required IAM permissions.
     * </p>
     * <p>
     * Amazon EC2 instance(s) must have access to the secrets created in AWS Secrets Manager to manage SAP applications
     * and components.
     * </p>
     *
     * @param registerApplicationRequest
     * @return Result of the RegisterApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         A conflict has occurred.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.RegisterApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/RegisterApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default RegisterApplicationResponse registerApplication(RegisterApplicationRequest registerApplicationRequest)
            throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Register an SAP application with AWS Systems Manager for SAP. You must meet the following requirements before
     * registering.
     * </p>
     * <p>
     * The SAP application you want to register with AWS Systems Manager for SAP is running on Amazon EC2.
     * </p>
     * <p>
     * AWS Systems Manager Agent must be setup on an Amazon EC2 instance along with the required IAM permissions.
     * </p>
     * <p>
     * Amazon EC2 instance(s) must have access to the secrets created in AWS Secrets Manager to manage SAP applications
     * and components.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterApplicationRequest#builder()}
     * </p>
     *
     * @param registerApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.RegisterApplicationRequest.Builder} to create a
     *        request.
     * @return Result of the RegisterApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         A conflict has occurred.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.RegisterApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/RegisterApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default RegisterApplicationResponse registerApplication(
            Consumer<RegisterApplicationRequest.Builder> registerApplicationRequest) throws ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            SsmSapException {
        return registerApplication(RegisterApplicationRequest.builder().applyMutation(registerApplicationRequest).build());
    }

    /**
     * <p>
     * Request is an operation which starts an application.
     * </p>
     * <p>
     * Parameter <code>ApplicationId</code> is required.
     * </p>
     *
     * @param startApplicationRequest
     * @return Result of the StartApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ConflictException
     *         A conflict has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.StartApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/StartApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default StartApplicationResponse startApplication(StartApplicationRequest startApplicationRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Request is an operation which starts an application.
     * </p>
     * <p>
     * Parameter <code>ApplicationId</code> is required.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link StartApplicationRequest#builder()}
     * </p>
     *
     * @param startApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.StartApplicationRequest.Builder} to create a request.
     * @return Result of the StartApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ConflictException
     *         A conflict has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.StartApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/StartApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default StartApplicationResponse startApplication(Consumer<StartApplicationRequest.Builder> startApplicationRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, SsmSapException {
        return startApplication(StartApplicationRequest.builder().applyMutation(startApplicationRequest).build());
    }

    /**
     * <p>
     * Refreshes a registered application.
     * </p>
     *
     * @param startApplicationRefreshRequest
     * @return Result of the StartApplicationRefresh operation returned by the service.
     * @throws UnauthorizedException
     *         The request is not authorized.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         A conflict has occurred.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.StartApplicationRefresh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/StartApplicationRefresh"
     *      target="_top">AWS API Documentation</a>
     */
    default StartApplicationRefreshResponse startApplicationRefresh(StartApplicationRefreshRequest startApplicationRefreshRequest)
            throws UnauthorizedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Refreshes a registered application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartApplicationRefreshRequest.Builder} avoiding
     * the need to create one manually via {@link StartApplicationRefreshRequest#builder()}
     * </p>
     *
     * @param startApplicationRefreshRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.StartApplicationRefreshRequest.Builder} to create a
     *        request.
     * @return Result of the StartApplicationRefresh operation returned by the service.
     * @throws UnauthorizedException
     *         The request is not authorized.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         A conflict has occurred.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.StartApplicationRefresh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/StartApplicationRefresh"
     *      target="_top">AWS API Documentation</a>
     */
    default StartApplicationRefreshResponse startApplicationRefresh(
            Consumer<StartApplicationRefreshRequest.Builder> startApplicationRefreshRequest) throws UnauthorizedException,
            ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, SsmSapException {
        return startApplicationRefresh(StartApplicationRefreshRequest.builder().applyMutation(startApplicationRefreshRequest)
                .build());
    }

    /**
     * <p>
     * Initiates configuration check operations against a specified application.
     * </p>
     *
     * @param startConfigurationChecksRequest
     * @return Result of the StartConfigurationChecks operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         A conflict has occurred.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.StartConfigurationChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/StartConfigurationChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default StartConfigurationChecksResponse startConfigurationChecks(
            StartConfigurationChecksRequest startConfigurationChecksRequest) throws ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates configuration check operations against a specified application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartConfigurationChecksRequest.Builder} avoiding
     * the need to create one manually via {@link StartConfigurationChecksRequest#builder()}
     * </p>
     *
     * @param startConfigurationChecksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.StartConfigurationChecksRequest.Builder} to create a
     *        request.
     * @return Result of the StartConfigurationChecks operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         A conflict has occurred.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.StartConfigurationChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/StartConfigurationChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default StartConfigurationChecksResponse startConfigurationChecks(
            Consumer<StartConfigurationChecksRequest.Builder> startConfigurationChecksRequest) throws ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            SsmSapException {
        return startConfigurationChecks(StartConfigurationChecksRequest.builder().applyMutation(startConfigurationChecksRequest)
                .build());
    }

    /**
     * <p>
     * Request is an operation to stop an application.
     * </p>
     * <p>
     * Parameter <code>ApplicationId</code> is required. Parameters <code>StopConnectedEntity</code> and
     * <code>IncludeEc2InstanceShutdown</code> are optional.
     * </p>
     *
     * @param stopApplicationRequest
     * @return Result of the StopApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ConflictException
     *         A conflict has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.StopApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/StopApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default StopApplicationResponse stopApplication(StopApplicationRequest stopApplicationRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Request is an operation to stop an application.
     * </p>
     * <p>
     * Parameter <code>ApplicationId</code> is required. Parameters <code>StopConnectedEntity</code> and
     * <code>IncludeEc2InstanceShutdown</code> are optional.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link StopApplicationRequest#builder()}
     * </p>
     *
     * @param stopApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.StopApplicationRequest.Builder} to create a request.
     * @return Result of the StopApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ConflictException
     *         A conflict has occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.StopApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/StopApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default StopApplicationResponse stopApplication(Consumer<StopApplicationRequest.Builder> stopApplicationRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, SsmSapException {
        return stopApplication(StopApplicationRequest.builder().applyMutation(stopApplicationRequest).build());
    }

    /**
     * <p>
     * Creates tag for a resource by specifying the ARN.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         A conflict has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates tag for a resource by specifying the ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         A conflict has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException,
            SsmSapException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Delete the tags for a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         A conflict has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         A conflict has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException,
            SsmSapException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the settings of an application registered with AWS Systems Manager for SAP.
     * </p>
     *
     * @param updateApplicationSettingsRequest
     * @return Result of the UpdateApplicationSettings operation returned by the service.
     * @throws UnauthorizedException
     *         The request is not authorized.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         A conflict has occurred.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.UpdateApplicationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/UpdateApplicationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationSettingsResponse updateApplicationSettings(
            UpdateApplicationSettingsRequest updateApplicationSettingsRequest) throws UnauthorizedException,
            ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings of an application registered with AWS Systems Manager for SAP.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateApplicationSettingsRequest#builder()}
     * </p>
     *
     * @param updateApplicationSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ssmsap.model.UpdateApplicationSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateApplicationSettings operation returned by the service.
     * @throws UnauthorizedException
     *         The request is not authorized.
     * @throws ResourceNotFoundException
     *         The resource is not available.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         A conflict has occurred.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmSapException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmSapClient.UpdateApplicationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-sap-2018-05-10/UpdateApplicationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationSettingsResponse updateApplicationSettings(
            Consumer<UpdateApplicationSettingsRequest.Builder> updateApplicationSettingsRequest) throws UnauthorizedException,
            ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, SsmSapException {
        return updateApplicationSettings(UpdateApplicationSettingsRequest.builder()
                .applyMutation(updateApplicationSettingsRequest).build());
    }

    /**
     * Create a {@link SsmSapClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SsmSapClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SsmSapClient}.
     */
    static SsmSapClientBuilder builder() {
        return new DefaultSsmSapClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default SsmSapServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
