/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The credentials of your SAP application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationCredential implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationCredential.Builder, ApplicationCredential> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(ApplicationCredential::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> CREDENTIAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CredentialType").getter(getter(ApplicationCredential::credentialTypeAsString))
            .setter(setter(Builder::credentialType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CredentialType").build()).build();

    private static final SdkField<String> SECRET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretId").getter(getter(ApplicationCredential::secretId)).setter(setter(Builder::secretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD,
            CREDENTIAL_TYPE_FIELD, SECRET_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String databaseName;

    private final String credentialType;

    private final String secretId;

    private ApplicationCredential(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.credentialType = builder.credentialType;
        this.secretId = builder.secretId;
    }

    /**
     * <p>
     * The name of the SAP HANA database.
     * </p>
     * 
     * @return The name of the SAP HANA database.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The type of the application credentials.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #credentialType}
     * will return {@link CredentialType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #credentialTypeAsString}.
     * </p>
     * 
     * @return The type of the application credentials.
     * @see CredentialType
     */
    public final CredentialType credentialType() {
        return CredentialType.fromValue(credentialType);
    }

    /**
     * <p>
     * The type of the application credentials.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #credentialType}
     * will return {@link CredentialType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #credentialTypeAsString}.
     * </p>
     * 
     * @return The type of the application credentials.
     * @see CredentialType
     */
    public final String credentialTypeAsString() {
        return credentialType;
    }

    /**
     * <p>
     * The secret ID created in AWS Secrets Manager to store the credentials of the SAP application.
     * </p>
     * 
     * @return The secret ID created in AWS Secrets Manager to store the credentials of the SAP application.
     */
    public final String secretId() {
        return secretId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(credentialTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(secretId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationCredential)) {
            return false;
        }
        ApplicationCredential other = (ApplicationCredential) obj;
        return Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(credentialTypeAsString(), other.credentialTypeAsString())
                && Objects.equals(secretId(), other.secretId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationCredential").add("DatabaseName", databaseName())
                .add("CredentialType", credentialTypeAsString())
                .add("SecretId", secretId() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "CredentialType":
            return Optional.ofNullable(clazz.cast(credentialTypeAsString()));
        case "SecretId":
            return Optional.ofNullable(clazz.cast(secretId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("CredentialType", CREDENTIAL_TYPE_FIELD);
        map.put("SecretId", SECRET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationCredential, T> g) {
        return obj -> g.apply((ApplicationCredential) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationCredential> {
        /**
         * <p>
         * The name of the SAP HANA database.
         * </p>
         * 
         * @param databaseName
         *        The name of the SAP HANA database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The type of the application credentials.
         * </p>
         * 
         * @param credentialType
         *        The type of the application credentials.
         * @see CredentialType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CredentialType
         */
        Builder credentialType(String credentialType);

        /**
         * <p>
         * The type of the application credentials.
         * </p>
         * 
         * @param credentialType
         *        The type of the application credentials.
         * @see CredentialType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CredentialType
         */
        Builder credentialType(CredentialType credentialType);

        /**
         * <p>
         * The secret ID created in AWS Secrets Manager to store the credentials of the SAP application.
         * </p>
         * 
         * @param secretId
         *        The secret ID created in AWS Secrets Manager to store the credentials of the SAP application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretId(String secretId);
    }

    static final class BuilderImpl implements Builder {
        private String databaseName;

        private String credentialType;

        private String secretId;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationCredential model) {
            databaseName(model.databaseName);
            credentialType(model.credentialType);
            secretId(model.secretId);
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getCredentialType() {
            return credentialType;
        }

        public final void setCredentialType(String credentialType) {
            this.credentialType = credentialType;
        }

        @Override
        public final Builder credentialType(String credentialType) {
            this.credentialType = credentialType;
            return this;
        }

        @Override
        public final Builder credentialType(CredentialType credentialType) {
            this.credentialType(credentialType == null ? null : credentialType.toString());
            return this;
        }

        public final String getSecretId() {
            return secretId;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        @Override
        public ApplicationCredential build() {
            return new ApplicationCredential(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
