/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration parameters for AWS Backint Agent for SAP HANA. You can backup your SAP HANA database with AWS Backup or
 * Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BackintConfig implements SdkPojo, Serializable, ToCopyableBuilder<BackintConfig.Builder, BackintConfig> {
    private static final SdkField<String> BACKINT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackintMode").getter(getter(BackintConfig::backintModeAsString)).setter(setter(Builder::backintMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackintMode").build()).build();

    private static final SdkField<Boolean> ENSURE_NO_BACKUP_IN_PROCESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("EnsureNoBackupInProcess")
            .getter(getter(BackintConfig::ensureNoBackupInProcess)).setter(setter(Builder::ensureNoBackupInProcess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnsureNoBackupInProcess").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKINT_MODE_FIELD,
            ENSURE_NO_BACKUP_IN_PROCESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String backintMode;

    private final Boolean ensureNoBackupInProcess;

    private BackintConfig(BuilderImpl builder) {
        this.backintMode = builder.backintMode;
        this.ensureNoBackupInProcess = builder.ensureNoBackupInProcess;
    }

    /**
     * <p>
     * AWS service for your database backup.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backintMode} will
     * return {@link BackintMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backintModeAsString}.
     * </p>
     * 
     * @return AWS service for your database backup.
     * @see BackintMode
     */
    public final BackintMode backintMode() {
        return BackintMode.fromValue(backintMode);
    }

    /**
     * <p>
     * AWS service for your database backup.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backintMode} will
     * return {@link BackintMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backintModeAsString}.
     * </p>
     * 
     * @return AWS service for your database backup.
     * @see BackintMode
     */
    public final String backintModeAsString() {
        return backintMode;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Boolean ensureNoBackupInProcess() {
        return ensureNoBackupInProcess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backintModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ensureNoBackupInProcess());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackintConfig)) {
            return false;
        }
        BackintConfig other = (BackintConfig) obj;
        return Objects.equals(backintModeAsString(), other.backintModeAsString())
                && Objects.equals(ensureNoBackupInProcess(), other.ensureNoBackupInProcess());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BackintConfig").add("BackintMode", backintModeAsString())
                .add("EnsureNoBackupInProcess", ensureNoBackupInProcess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackintMode":
            return Optional.ofNullable(clazz.cast(backintModeAsString()));
        case "EnsureNoBackupInProcess":
            return Optional.ofNullable(clazz.cast(ensureNoBackupInProcess()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BackintMode", BACKINT_MODE_FIELD);
        map.put("EnsureNoBackupInProcess", ENSURE_NO_BACKUP_IN_PROCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BackintConfig, T> g) {
        return obj -> g.apply((BackintConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BackintConfig> {
        /**
         * <p>
         * AWS service for your database backup.
         * </p>
         * 
         * @param backintMode
         *        AWS service for your database backup.
         * @see BackintMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackintMode
         */
        Builder backintMode(String backintMode);

        /**
         * <p>
         * AWS service for your database backup.
         * </p>
         * 
         * @param backintMode
         *        AWS service for your database backup.
         * @see BackintMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackintMode
         */
        Builder backintMode(BackintMode backintMode);

        /**
         * <p/>
         * 
         * @param ensureNoBackupInProcess
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ensureNoBackupInProcess(Boolean ensureNoBackupInProcess);
    }

    static final class BuilderImpl implements Builder {
        private String backintMode;

        private Boolean ensureNoBackupInProcess;

        private BuilderImpl() {
        }

        private BuilderImpl(BackintConfig model) {
            backintMode(model.backintMode);
            ensureNoBackupInProcess(model.ensureNoBackupInProcess);
        }

        public final String getBackintMode() {
            return backintMode;
        }

        public final void setBackintMode(String backintMode) {
            this.backintMode = backintMode;
        }

        @Override
        public final Builder backintMode(String backintMode) {
            this.backintMode = backintMode;
            return this;
        }

        @Override
        public final Builder backintMode(BackintMode backintMode) {
            this.backintMode(backintMode == null ? null : backintMode.toString());
            return this;
        }

        public final Boolean getEnsureNoBackupInProcess() {
            return ensureNoBackupInProcess;
        }

        public final void setEnsureNoBackupInProcess(Boolean ensureNoBackupInProcess) {
            this.ensureNoBackupInProcess = ensureNoBackupInProcess;
        }

        @Override
        public final Builder ensureNoBackupInProcess(Boolean ensureNoBackupInProcess) {
            this.ensureNoBackupInProcess = ensureNoBackupInProcess;
            return this;
        }

        @Override
        public BackintConfig build() {
            return new BackintConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
