/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The SAP HANA database of the application registered with AWS Systems Manager for SAP.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Database implements SdkPojo, Serializable, ToCopyableBuilder<Database.Builder, Database> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(Database::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> COMPONENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComponentId").getter(getter(Database::componentId)).setter(setter(Builder::componentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentId").build()).build();

    private static final SdkField<List<ApplicationCredential>> CREDENTIALS_FIELD = SdkField
            .<List<ApplicationCredential>> builder(MarshallingType.LIST)
            .memberName("Credentials")
            .getter(getter(Database::credentials))
            .setter(setter(Builder::credentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationCredential> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationCredential::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DATABASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseId").getter(getter(Database::databaseId)).setter(setter(Builder::databaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(Database::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> DATABASE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseType").getter(getter(Database::databaseTypeAsString)).setter(setter(Builder::databaseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseType").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Database::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Database::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> PRIMARY_HOST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryHost").getter(getter(Database::primaryHost)).setter(setter(Builder::primaryHost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryHost").build()).build();

    private static final SdkField<Integer> SQL_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SQLPort").getter(getter(Database::sqlPort)).setter(setter(Builder::sqlPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SQLPort").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdated").getter(getter(Database::lastUpdated)).setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()).build();

    private static final SdkField<List<String>> CONNECTED_COMPONENT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ConnectedComponentArns")
            .getter(getter(Database::connectedComponentArns))
            .setter(setter(Builder::connectedComponentArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedComponentArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            COMPONENT_ID_FIELD, CREDENTIALS_FIELD, DATABASE_ID_FIELD, DATABASE_NAME_FIELD, DATABASE_TYPE_FIELD, ARN_FIELD,
            STATUS_FIELD, PRIMARY_HOST_FIELD, SQL_PORT_FIELD, LAST_UPDATED_FIELD, CONNECTED_COMPONENT_ARNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String componentId;

    private final List<ApplicationCredential> credentials;

    private final String databaseId;

    private final String databaseName;

    private final String databaseType;

    private final String arn;

    private final String status;

    private final String primaryHost;

    private final Integer sqlPort;

    private final Instant lastUpdated;

    private final List<String> connectedComponentArns;

    private Database(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.componentId = builder.componentId;
        this.credentials = builder.credentials;
        this.databaseId = builder.databaseId;
        this.databaseName = builder.databaseName;
        this.databaseType = builder.databaseType;
        this.arn = builder.arn;
        this.status = builder.status;
        this.primaryHost = builder.primaryHost;
        this.sqlPort = builder.sqlPort;
        this.lastUpdated = builder.lastUpdated;
        this.connectedComponentArns = builder.connectedComponentArns;
    }

    /**
     * <p>
     * The ID of the application.
     * </p>
     * 
     * @return The ID of the application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The ID of the component.
     * </p>
     * 
     * @return The ID of the component.
     */
    public final String componentId() {
        return componentId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Credentials property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCredentials() {
        return credentials != null && !(credentials instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The credentials of the database.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCredentials} method.
     * </p>
     * 
     * @return The credentials of the database.
     */
    public final List<ApplicationCredential> credentials() {
        return credentials;
    }

    /**
     * <p>
     * The ID of the SAP HANA database.
     * </p>
     * 
     * @return The ID of the SAP HANA database.
     */
    public final String databaseId() {
        return databaseId;
    }

    /**
     * <p>
     * The name of the database.
     * </p>
     * 
     * @return The name of the database.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The type of the database.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #databaseType} will
     * return {@link DatabaseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #databaseTypeAsString}.
     * </p>
     * 
     * @return The type of the database.
     * @see DatabaseType
     */
    public final DatabaseType databaseType() {
        return DatabaseType.fromValue(databaseType);
    }

    /**
     * <p>
     * The type of the database.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #databaseType} will
     * return {@link DatabaseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #databaseTypeAsString}.
     * </p>
     * 
     * @return The type of the database.
     * @see DatabaseType
     */
    public final String databaseTypeAsString() {
        return databaseType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the database.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the database.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the database.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatabaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the database.
     * @see DatabaseStatus
     */
    public final DatabaseStatus status() {
        return DatabaseStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the database.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatabaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the database.
     * @see DatabaseStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The primary host of the database.
     * </p>
     * 
     * @return The primary host of the database.
     */
    public final String primaryHost() {
        return primaryHost;
    }

    /**
     * <p>
     * The SQL port of the database.
     * </p>
     * 
     * @return The SQL port of the database.
     */
    public final Integer sqlPort() {
        return sqlPort;
    }

    /**
     * <p>
     * The time at which the database was last updated.
     * </p>
     * 
     * @return The time at which the database was last updated.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectedComponentArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConnectedComponentArns() {
        return connectedComponentArns != null && !(connectedComponentArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names of the connected AWS Systems Manager for SAP components.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectedComponentArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names of the connected AWS Systems Manager for SAP components.
     */
    public final List<String> connectedComponentArns() {
        return connectedComponentArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(componentId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCredentials() ? credentials() : null);
        hashCode = 31 * hashCode + Objects.hashCode(databaseId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(databaseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(primaryHost());
        hashCode = 31 * hashCode + Objects.hashCode(sqlPort());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectedComponentArns() ? connectedComponentArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Database)) {
            return false;
        }
        Database other = (Database) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(componentId(), other.componentId())
                && hasCredentials() == other.hasCredentials() && Objects.equals(credentials(), other.credentials())
                && Objects.equals(databaseId(), other.databaseId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(databaseTypeAsString(), other.databaseTypeAsString()) && Objects.equals(arn(), other.arn())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(primaryHost(), other.primaryHost())
                && Objects.equals(sqlPort(), other.sqlPort()) && Objects.equals(lastUpdated(), other.lastUpdated())
                && hasConnectedComponentArns() == other.hasConnectedComponentArns()
                && Objects.equals(connectedComponentArns(), other.connectedComponentArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Database").add("ApplicationId", applicationId()).add("ComponentId", componentId())
                .add("Credentials", hasCredentials() ? credentials() : null).add("DatabaseId", databaseId())
                .add("DatabaseName", databaseName()).add("DatabaseType", databaseTypeAsString()).add("Arn", arn())
                .add("Status", statusAsString()).add("PrimaryHost", primaryHost()).add("SQLPort", sqlPort())
                .add("LastUpdated", lastUpdated())
                .add("ConnectedComponentArns", hasConnectedComponentArns() ? connectedComponentArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "ComponentId":
            return Optional.ofNullable(clazz.cast(componentId()));
        case "Credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        case "DatabaseId":
            return Optional.ofNullable(clazz.cast(databaseId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "DatabaseType":
            return Optional.ofNullable(clazz.cast(databaseTypeAsString()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "PrimaryHost":
            return Optional.ofNullable(clazz.cast(primaryHost()));
        case "SQLPort":
            return Optional.ofNullable(clazz.cast(sqlPort()));
        case "LastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "ConnectedComponentArns":
            return Optional.ofNullable(clazz.cast(connectedComponentArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("ComponentId", COMPONENT_ID_FIELD);
        map.put("Credentials", CREDENTIALS_FIELD);
        map.put("DatabaseId", DATABASE_ID_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("DatabaseType", DATABASE_TYPE_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("PrimaryHost", PRIMARY_HOST_FIELD);
        map.put("SQLPort", SQL_PORT_FIELD);
        map.put("LastUpdated", LAST_UPDATED_FIELD);
        map.put("ConnectedComponentArns", CONNECTED_COMPONENT_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Database, T> g) {
        return obj -> g.apply((Database) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Database> {
        /**
         * <p>
         * The ID of the application.
         * </p>
         * 
         * @param applicationId
         *        The ID of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The ID of the component.
         * </p>
         * 
         * @param componentId
         *        The ID of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentId(String componentId);

        /**
         * <p>
         * The credentials of the database.
         * </p>
         * 
         * @param credentials
         *        The credentials of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(Collection<ApplicationCredential> credentials);

        /**
         * <p>
         * The credentials of the database.
         * </p>
         * 
         * @param credentials
         *        The credentials of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(ApplicationCredential... credentials);

        /**
         * <p>
         * The credentials of the database.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmsap.model.ApplicationCredential.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ssmsap.model.ApplicationCredential#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmsap.model.ApplicationCredential.Builder#build()} is called
         * immediately and its result is passed to {@link #credentials(List<ApplicationCredential>)}.
         * 
         * @param credentials
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmsap.model.ApplicationCredential.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(java.util.Collection<ApplicationCredential>)
         */
        Builder credentials(Consumer<ApplicationCredential.Builder>... credentials);

        /**
         * <p>
         * The ID of the SAP HANA database.
         * </p>
         * 
         * @param databaseId
         *        The ID of the SAP HANA database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseId(String databaseId);

        /**
         * <p>
         * The name of the database.
         * </p>
         * 
         * @param databaseName
         *        The name of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The type of the database.
         * </p>
         * 
         * @param databaseType
         *        The type of the database.
         * @see DatabaseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatabaseType
         */
        Builder databaseType(String databaseType);

        /**
         * <p>
         * The type of the database.
         * </p>
         * 
         * @param databaseType
         *        The type of the database.
         * @see DatabaseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatabaseType
         */
        Builder databaseType(DatabaseType databaseType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the database.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the database.
         * </p>
         * 
         * @param status
         *        The status of the database.
         * @see DatabaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatabaseStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the database.
         * </p>
         * 
         * @param status
         *        The status of the database.
         * @see DatabaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatabaseStatus
         */
        Builder status(DatabaseStatus status);

        /**
         * <p>
         * The primary host of the database.
         * </p>
         * 
         * @param primaryHost
         *        The primary host of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryHost(String primaryHost);

        /**
         * <p>
         * The SQL port of the database.
         * </p>
         * 
         * @param sqlPort
         *        The SQL port of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlPort(Integer sqlPort);

        /**
         * <p>
         * The time at which the database was last updated.
         * </p>
         * 
         * @param lastUpdated
         *        The time at which the database was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * The Amazon Resource Names of the connected AWS Systems Manager for SAP components.
         * </p>
         * 
         * @param connectedComponentArns
         *        The Amazon Resource Names of the connected AWS Systems Manager for SAP components.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectedComponentArns(Collection<String> connectedComponentArns);

        /**
         * <p>
         * The Amazon Resource Names of the connected AWS Systems Manager for SAP components.
         * </p>
         * 
         * @param connectedComponentArns
         *        The Amazon Resource Names of the connected AWS Systems Manager for SAP components.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectedComponentArns(String... connectedComponentArns);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String componentId;

        private List<ApplicationCredential> credentials = DefaultSdkAutoConstructList.getInstance();

        private String databaseId;

        private String databaseName;

        private String databaseType;

        private String arn;

        private String status;

        private String primaryHost;

        private Integer sqlPort;

        private Instant lastUpdated;

        private List<String> connectedComponentArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Database model) {
            applicationId(model.applicationId);
            componentId(model.componentId);
            credentials(model.credentials);
            databaseId(model.databaseId);
            databaseName(model.databaseName);
            databaseType(model.databaseType);
            arn(model.arn);
            status(model.status);
            primaryHost(model.primaryHost);
            sqlPort(model.sqlPort);
            lastUpdated(model.lastUpdated);
            connectedComponentArns(model.connectedComponentArns);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getComponentId() {
            return componentId;
        }

        public final void setComponentId(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public final Builder componentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        public final List<ApplicationCredential.Builder> getCredentials() {
            List<ApplicationCredential.Builder> result = ApplicationCredentialListCopier.copyToBuilder(this.credentials);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCredentials(Collection<ApplicationCredential.BuilderImpl> credentials) {
            this.credentials = ApplicationCredentialListCopier.copyFromBuilder(credentials);
        }

        @Override
        public final Builder credentials(Collection<ApplicationCredential> credentials) {
            this.credentials = ApplicationCredentialListCopier.copy(credentials);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentials(ApplicationCredential... credentials) {
            credentials(Arrays.asList(credentials));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentials(Consumer<ApplicationCredential.Builder>... credentials) {
            credentials(Stream.of(credentials).map(c -> ApplicationCredential.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDatabaseId() {
            return databaseId;
        }

        public final void setDatabaseId(String databaseId) {
            this.databaseId = databaseId;
        }

        @Override
        public final Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDatabaseType() {
            return databaseType;
        }

        public final void setDatabaseType(String databaseType) {
            this.databaseType = databaseType;
        }

        @Override
        public final Builder databaseType(String databaseType) {
            this.databaseType = databaseType;
            return this;
        }

        @Override
        public final Builder databaseType(DatabaseType databaseType) {
            this.databaseType(databaseType == null ? null : databaseType.toString());
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DatabaseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getPrimaryHost() {
            return primaryHost;
        }

        public final void setPrimaryHost(String primaryHost) {
            this.primaryHost = primaryHost;
        }

        @Override
        public final Builder primaryHost(String primaryHost) {
            this.primaryHost = primaryHost;
            return this;
        }

        public final Integer getSqlPort() {
            return sqlPort;
        }

        public final void setSqlPort(Integer sqlPort) {
            this.sqlPort = sqlPort;
        }

        @Override
        public final Builder sqlPort(Integer sqlPort) {
            this.sqlPort = sqlPort;
            return this;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final Collection<String> getConnectedComponentArns() {
            if (connectedComponentArns instanceof SdkAutoConstructList) {
                return null;
            }
            return connectedComponentArns;
        }

        public final void setConnectedComponentArns(Collection<String> connectedComponentArns) {
            this.connectedComponentArns = ComponentArnListCopier.copy(connectedComponentArns);
        }

        @Override
        public final Builder connectedComponentArns(Collection<String> connectedComponentArns) {
            this.connectedComponentArns = ComponentArnListCopier.copy(connectedComponentArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectedComponentArns(String... connectedComponentArns) {
            connectedComponentArns(Arrays.asList(connectedComponentArns));
            return this;
        }

        @Override
        public Database build() {
            return new Database(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
