/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConfigurationCheckOperationsRequest extends SsmSapRequest implements
        ToCopyableBuilder<ListConfigurationCheckOperationsRequest.Builder, ListConfigurationCheckOperationsRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(ListConfigurationCheckOperationsRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> LIST_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ListMode").getter(getter(ListConfigurationCheckOperationsRequest::listModeAsString))
            .setter(setter(Builder::listMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListMode").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListConfigurationCheckOperationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListConfigurationCheckOperationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(ListConfigurationCheckOperationsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            LIST_MODE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String listMode;

    private final Integer maxResults;

    private final String nextToken;

    private final List<Filter> filters;

    private ListConfigurationCheckOperationsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.listMode = builder.listMode;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * The ID of the application.
     * </p>
     * 
     * @return The ID of the application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The mode for listing configuration check operations. Defaults to "LATEST_PER_CHECK".
     * </p>
     * <ul>
     * <li>
     * <p>
     * LATEST_PER_CHECK - Will list the latest configuration check operation per check type.
     * </p>
     * </li>
     * <li>
     * <p>
     * ALL_OPERATIONS - Will list all configuration check operations performed on the application.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #listMode} will
     * return {@link ConfigurationCheckOperationListingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #listModeAsString}.
     * </p>
     * 
     * @return The mode for listing configuration check operations. Defaults to "LATEST_PER_CHECK".</p>
     *         <ul>
     *         <li>
     *         <p>
     *         LATEST_PER_CHECK - Will list the latest configuration check operation per check type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ALL_OPERATIONS - Will list all configuration check operations performed on the application.
     *         </p>
     *         </li>
     * @see ConfigurationCheckOperationListingMode
     */
    public final ConfigurationCheckOperationListingMode listMode() {
        return ConfigurationCheckOperationListingMode.fromValue(listMode);
    }

    /**
     * <p>
     * The mode for listing configuration check operations. Defaults to "LATEST_PER_CHECK".
     * </p>
     * <ul>
     * <li>
     * <p>
     * LATEST_PER_CHECK - Will list the latest configuration check operation per check type.
     * </p>
     * </li>
     * <li>
     * <p>
     * ALL_OPERATIONS - Will list all configuration check operations performed on the application.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #listMode} will
     * return {@link ConfigurationCheckOperationListingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #listModeAsString}.
     * </p>
     * 
     * @return The mode for listing configuration check operations. Defaults to "LATEST_PER_CHECK".</p>
     *         <ul>
     *         <li>
     *         <p>
     *         LATEST_PER_CHECK - Will list the latest configuration check operation per check type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ALL_OPERATIONS - Will list all configuration check operations performed on the application.
     *         </p>
     *         </li>
     * @see ConfigurationCheckOperationListingMode
     */
    public final String listModeAsString() {
        return listMode;
    }

    /**
     * <p>
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call
     * with the returned nextToken value.
     * </p>
     * 
     * @return The maximum number of results to return with a single call. To retrieve the remaining results, make
     *         another call with the returned nextToken value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters of an operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters of an operation.
     */
    public final List<Filter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(listModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationCheckOperationsRequest)) {
            return false;
        }
        ListConfigurationCheckOperationsRequest other = (ListConfigurationCheckOperationsRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(listModeAsString(), other.listModeAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConfigurationCheckOperationsRequest").add("ApplicationId", applicationId())
                .add("ListMode", listModeAsString()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "ListMode":
            return Optional.ofNullable(clazz.cast(listModeAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("ListMode", LIST_MODE_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationCheckOperationsRequest, T> g) {
        return obj -> g.apply((ListConfigurationCheckOperationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsmSapRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListConfigurationCheckOperationsRequest> {
        /**
         * <p>
         * The ID of the application.
         * </p>
         * 
         * @param applicationId
         *        The ID of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The mode for listing configuration check operations. Defaults to "LATEST_PER_CHECK".
         * </p>
         * <ul>
         * <li>
         * <p>
         * LATEST_PER_CHECK - Will list the latest configuration check operation per check type.
         * </p>
         * </li>
         * <li>
         * <p>
         * ALL_OPERATIONS - Will list all configuration check operations performed on the application.
         * </p>
         * </li>
         * </ul>
         * 
         * @param listMode
         *        The mode for listing configuration check operations. Defaults to "LATEST_PER_CHECK".</p>
         *        <ul>
         *        <li>
         *        <p>
         *        LATEST_PER_CHECK - Will list the latest configuration check operation per check type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ALL_OPERATIONS - Will list all configuration check operations performed on the application.
         *        </p>
         *        </li>
         * @see ConfigurationCheckOperationListingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationCheckOperationListingMode
         */
        Builder listMode(String listMode);

        /**
         * <p>
         * The mode for listing configuration check operations. Defaults to "LATEST_PER_CHECK".
         * </p>
         * <ul>
         * <li>
         * <p>
         * LATEST_PER_CHECK - Will list the latest configuration check operation per check type.
         * </p>
         * </li>
         * <li>
         * <p>
         * ALL_OPERATIONS - Will list all configuration check operations performed on the application.
         * </p>
         * </li>
         * </ul>
         * 
         * @param listMode
         *        The mode for listing configuration check operations. Defaults to "LATEST_PER_CHECK".</p>
         *        <ul>
         *        <li>
         *        <p>
         *        LATEST_PER_CHECK - Will list the latest configuration check operation per check type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ALL_OPERATIONS - Will list all configuration check operations performed on the application.
         *        </p>
         *        </li>
         * @see ConfigurationCheckOperationListingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationCheckOperationListingMode
         */
        Builder listMode(ConfigurationCheckOperationListingMode listMode);

        /**
         * <p>
         * The maximum number of results to return with a single call. To retrieve the remaining results, make another
         * call with the returned nextToken value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return with a single call. To retrieve the remaining results, make
         *        another call with the returned nextToken value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The filters of an operation.
         * </p>
         * 
         * @param filters
         *        The filters of an operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters of an operation.
         * </p>
         * 
         * @param filters
         *        The filters of an operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters of an operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmsap.model.Filter.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ssmsap.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmsap.model.Filter.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmsap.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmSapRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String listMode;

        private Integer maxResults;

        private String nextToken;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationCheckOperationsRequest model) {
            super(model);
            applicationId(model.applicationId);
            listMode(model.listMode);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            filters(model.filters);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getListMode() {
            return listMode;
        }

        public final void setListMode(String listMode) {
            this.listMode = listMode;
        }

        @Override
        public final Builder listMode(String listMode) {
            this.listMode = listMode;
            return this;
        }

        @Override
        public final Builder listMode(ConfigurationCheckOperationListingMode listMode) {
            this.listMode(listMode == null ? null : listMode.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListConfigurationCheckOperationsRequest build() {
            return new ListConfigurationCheckOperationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
