/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of rule results, providing counts for each status type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleStatusCounts implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleStatusCounts.Builder, RuleStatusCounts> {
    private static final SdkField<Integer> FAILED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Failed").getter(getter(RuleStatusCounts::failed)).setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failed").build()).build();

    private static final SdkField<Integer> WARNING_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Warning").getter(getter(RuleStatusCounts::warning)).setter(setter(Builder::warning))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warning").build()).build();

    private static final SdkField<Integer> INFO_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Info")
            .getter(getter(RuleStatusCounts::info)).setter(setter(Builder::info))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Info").build()).build();

    private static final SdkField<Integer> PASSED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Passed").getter(getter(RuleStatusCounts::passed)).setter(setter(Builder::passed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Passed").build()).build();

    private static final SdkField<Integer> UNKNOWN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Unknown").getter(getter(RuleStatusCounts::unknown)).setter(setter(Builder::unknown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unknown").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_FIELD, WARNING_FIELD,
            INFO_FIELD, PASSED_FIELD, UNKNOWN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer failed;

    private final Integer warning;

    private final Integer info;

    private final Integer passed;

    private final Integer unknown;

    private RuleStatusCounts(BuilderImpl builder) {
        this.failed = builder.failed;
        this.warning = builder.warning;
        this.info = builder.info;
        this.passed = builder.passed;
        this.unknown = builder.unknown;
    }

    /**
     * <p>
     * The number of rules that failed.
     * </p>
     * 
     * @return The number of rules that failed.
     */
    public final Integer failed() {
        return failed;
    }

    /**
     * <p>
     * The number of rules that returned warnings.
     * </p>
     * 
     * @return The number of rules that returned warnings.
     */
    public final Integer warning() {
        return warning;
    }

    /**
     * <p>
     * The number of rules that returned informational results.
     * </p>
     * 
     * @return The number of rules that returned informational results.
     */
    public final Integer info() {
        return info;
    }

    /**
     * <p>
     * The number of rules that passed.
     * </p>
     * 
     * @return The number of rules that passed.
     */
    public final Integer passed() {
        return passed;
    }

    /**
     * <p>
     * The number of rules with unknown status.
     * </p>
     * 
     * @return The number of rules with unknown status.
     */
    public final Integer unknown() {
        return unknown;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failed());
        hashCode = 31 * hashCode + Objects.hashCode(warning());
        hashCode = 31 * hashCode + Objects.hashCode(info());
        hashCode = 31 * hashCode + Objects.hashCode(passed());
        hashCode = 31 * hashCode + Objects.hashCode(unknown());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleStatusCounts)) {
            return false;
        }
        RuleStatusCounts other = (RuleStatusCounts) obj;
        return Objects.equals(failed(), other.failed()) && Objects.equals(warning(), other.warning())
                && Objects.equals(info(), other.info()) && Objects.equals(passed(), other.passed())
                && Objects.equals(unknown(), other.unknown());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleStatusCounts").add("Failed", failed()).add("Warning", warning()).add("Info", info())
                .add("Passed", passed()).add("Unknown", unknown()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Failed":
            return Optional.ofNullable(clazz.cast(failed()));
        case "Warning":
            return Optional.ofNullable(clazz.cast(warning()));
        case "Info":
            return Optional.ofNullable(clazz.cast(info()));
        case "Passed":
            return Optional.ofNullable(clazz.cast(passed()));
        case "Unknown":
            return Optional.ofNullable(clazz.cast(unknown()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Failed", FAILED_FIELD);
        map.put("Warning", WARNING_FIELD);
        map.put("Info", INFO_FIELD);
        map.put("Passed", PASSED_FIELD);
        map.put("Unknown", UNKNOWN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleStatusCounts, T> g) {
        return obj -> g.apply((RuleStatusCounts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleStatusCounts> {
        /**
         * <p>
         * The number of rules that failed.
         * </p>
         * 
         * @param failed
         *        The number of rules that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Integer failed);

        /**
         * <p>
         * The number of rules that returned warnings.
         * </p>
         * 
         * @param warning
         *        The number of rules that returned warnings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warning(Integer warning);

        /**
         * <p>
         * The number of rules that returned informational results.
         * </p>
         * 
         * @param info
         *        The number of rules that returned informational results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder info(Integer info);

        /**
         * <p>
         * The number of rules that passed.
         * </p>
         * 
         * @param passed
         *        The number of rules that passed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passed(Integer passed);

        /**
         * <p>
         * The number of rules with unknown status.
         * </p>
         * 
         * @param unknown
         *        The number of rules with unknown status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unknown(Integer unknown);
    }

    static final class BuilderImpl implements Builder {
        private Integer failed;

        private Integer warning;

        private Integer info;

        private Integer passed;

        private Integer unknown;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleStatusCounts model) {
            failed(model.failed);
            warning(model.warning);
            info(model.info);
            passed(model.passed);
            unknown(model.unknown);
        }

        public final Integer getFailed() {
            return failed;
        }

        public final void setFailed(Integer failed) {
            this.failed = failed;
        }

        @Override
        public final Builder failed(Integer failed) {
            this.failed = failed;
            return this;
        }

        public final Integer getWarning() {
            return warning;
        }

        public final void setWarning(Integer warning) {
            this.warning = warning;
        }

        @Override
        public final Builder warning(Integer warning) {
            this.warning = warning;
            return this;
        }

        public final Integer getInfo() {
            return info;
        }

        public final void setInfo(Integer info) {
            this.info = info;
        }

        @Override
        public final Builder info(Integer info) {
            this.info = info;
            return this;
        }

        public final Integer getPassed() {
            return passed;
        }

        public final void setPassed(Integer passed) {
            this.passed = passed;
        }

        @Override
        public final Builder passed(Integer passed) {
            this.passed = passed;
            return this;
        }

        public final Integer getUnknown() {
            return unknown;
        }

        public final void setUnknown(Integer unknown) {
            this.unknown = unknown;
        }

        @Override
        public final Builder unknown(Integer unknown) {
            this.unknown = unknown;
            return this;
        }

        @Override
        public RuleStatusCounts build() {
            return new RuleStatusCounts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
