/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartConfigurationChecksRequest extends SsmSapRequest implements
        ToCopyableBuilder<StartConfigurationChecksRequest.Builder, StartConfigurationChecksRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(StartConfigurationChecksRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<List<String>> CONFIGURATION_CHECK_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ConfigurationCheckIds")
            .getter(getter(StartConfigurationChecksRequest::configurationCheckIdsAsStrings))
            .setter(setter(Builder::configurationCheckIdsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationCheckIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CONFIGURATION_CHECK_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final List<String> configurationCheckIds;

    private StartConfigurationChecksRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.configurationCheckIds = builder.configurationCheckIds;
    }

    /**
     * <p>
     * The ID of the application.
     * </p>
     * 
     * @return The ID of the application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The list of configuration checks to perform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurationCheckIds} method.
     * </p>
     * 
     * @return The list of configuration checks to perform.
     */
    public final List<ConfigurationCheckType> configurationCheckIds() {
        return ConfigurationCheckTypeListCopier.copyStringToEnum(configurationCheckIds);
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfigurationCheckIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConfigurationCheckIds() {
        return configurationCheckIds != null && !(configurationCheckIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of configuration checks to perform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurationCheckIds} method.
     * </p>
     * 
     * @return The list of configuration checks to perform.
     */
    public final List<String> configurationCheckIdsAsStrings() {
        return configurationCheckIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurationCheckIds() ? configurationCheckIdsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartConfigurationChecksRequest)) {
            return false;
        }
        StartConfigurationChecksRequest other = (StartConfigurationChecksRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && hasConfigurationCheckIds() == other.hasConfigurationCheckIds()
                && Objects.equals(configurationCheckIdsAsStrings(), other.configurationCheckIdsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartConfigurationChecksRequest").add("ApplicationId", applicationId())
                .add("ConfigurationCheckIds", hasConfigurationCheckIds() ? configurationCheckIdsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "ConfigurationCheckIds":
            return Optional.ofNullable(clazz.cast(configurationCheckIdsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("ConfigurationCheckIds", CONFIGURATION_CHECK_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartConfigurationChecksRequest, T> g) {
        return obj -> g.apply((StartConfigurationChecksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsmSapRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartConfigurationChecksRequest> {
        /**
         * <p>
         * The ID of the application.
         * </p>
         * 
         * @param applicationId
         *        The ID of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The list of configuration checks to perform.
         * </p>
         * 
         * @param configurationCheckIds
         *        The list of configuration checks to perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationCheckIdsWithStrings(Collection<String> configurationCheckIds);

        /**
         * <p>
         * The list of configuration checks to perform.
         * </p>
         * 
         * @param configurationCheckIds
         *        The list of configuration checks to perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationCheckIdsWithStrings(String... configurationCheckIds);

        /**
         * <p>
         * The list of configuration checks to perform.
         * </p>
         * 
         * @param configurationCheckIds
         *        The list of configuration checks to perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationCheckIds(Collection<ConfigurationCheckType> configurationCheckIds);

        /**
         * <p>
         * The list of configuration checks to perform.
         * </p>
         * 
         * @param configurationCheckIds
         *        The list of configuration checks to perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationCheckIds(ConfigurationCheckType... configurationCheckIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmSapRequest.BuilderImpl implements Builder {
        private String applicationId;

        private List<String> configurationCheckIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartConfigurationChecksRequest model) {
            super(model);
            applicationId(model.applicationId);
            configurationCheckIdsWithStrings(model.configurationCheckIds);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Collection<String> getConfigurationCheckIds() {
            if (configurationCheckIds instanceof SdkAutoConstructList) {
                return null;
            }
            return configurationCheckIds;
        }

        public final void setConfigurationCheckIds(Collection<String> configurationCheckIds) {
            this.configurationCheckIds = ConfigurationCheckTypeListCopier.copy(configurationCheckIds);
        }

        @Override
        public final Builder configurationCheckIdsWithStrings(Collection<String> configurationCheckIds) {
            this.configurationCheckIds = ConfigurationCheckTypeListCopier.copy(configurationCheckIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationCheckIdsWithStrings(String... configurationCheckIds) {
            configurationCheckIdsWithStrings(Arrays.asList(configurationCheckIds));
            return this;
        }

        @Override
        public final Builder configurationCheckIds(Collection<ConfigurationCheckType> configurationCheckIds) {
            this.configurationCheckIds = ConfigurationCheckTypeListCopier.copyEnumToString(configurationCheckIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationCheckIds(ConfigurationCheckType... configurationCheckIds) {
            configurationCheckIds(Arrays.asList(configurationCheckIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartConfigurationChecksRequest build() {
            return new StartConfigurationChecksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
