/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is information about the component of your SAP application, such as Web Dispatcher.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentInfo implements SdkPojo, Serializable, ToCopyableBuilder<ComponentInfo.Builder, ComponentInfo> {
    private static final SdkField<String> COMPONENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComponentType").getter(getter(ComponentInfo::componentTypeAsString))
            .setter(setter(Builder::componentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentType").build()).build();

    private static final SdkField<String> SID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Sid")
            .getter(getter(ComponentInfo::sid)).setter(setter(Builder::sid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sid").build()).build();

    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ec2InstanceId").getter(getter(ComponentInfo::ec2InstanceId)).setter(setter(Builder::ec2InstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_TYPE_FIELD,
            SID_FIELD, EC2_INSTANCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String componentType;

    private final String sid;

    private final String ec2InstanceId;

    private ComponentInfo(BuilderImpl builder) {
        this.componentType = builder.componentType;
        this.sid = builder.sid;
        this.ec2InstanceId = builder.ec2InstanceId;
    }

    /**
     * <p>
     * This string is the type of the component.
     * </p>
     * <p>
     * Accepted value is <code>WD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #componentType}
     * will return {@link ComponentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #componentTypeAsString}.
     * </p>
     * 
     * @return This string is the type of the component.</p>
     *         <p>
     *         Accepted value is <code>WD</code>.
     * @see ComponentType
     */
    public final ComponentType componentType() {
        return ComponentType.fromValue(componentType);
    }

    /**
     * <p>
     * This string is the type of the component.
     * </p>
     * <p>
     * Accepted value is <code>WD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #componentType}
     * will return {@link ComponentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #componentTypeAsString}.
     * </p>
     * 
     * @return This string is the type of the component.</p>
     *         <p>
     *         Accepted value is <code>WD</code>.
     * @see ComponentType
     */
    public final String componentTypeAsString() {
        return componentType;
    }

    /**
     * <p>
     * This string is the SAP System ID of the component.
     * </p>
     * <p>
     * Accepted values are alphanumeric.
     * </p>
     * 
     * @return This string is the SAP System ID of the component.</p>
     *         <p>
     *         Accepted values are alphanumeric.
     */
    public final String sid() {
        return sid;
    }

    /**
     * <p>
     * This is the Amazon EC2 instance on which your SAP component is running.
     * </p>
     * <p>
     * Accepted values are alphanumeric.
     * </p>
     * 
     * @return This is the Amazon EC2 instance on which your SAP component is running.</p>
     *         <p>
     *         Accepted values are alphanumeric.
     */
    public final String ec2InstanceId() {
        return ec2InstanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sid());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentInfo)) {
            return false;
        }
        ComponentInfo other = (ComponentInfo) obj;
        return Objects.equals(componentTypeAsString(), other.componentTypeAsString()) && Objects.equals(sid(), other.sid())
                && Objects.equals(ec2InstanceId(), other.ec2InstanceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentInfo").add("ComponentType", componentTypeAsString()).add("Sid", sid())
                .add("Ec2InstanceId", ec2InstanceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComponentType":
            return Optional.ofNullable(clazz.cast(componentTypeAsString()));
        case "Sid":
            return Optional.ofNullable(clazz.cast(sid()));
        case "Ec2InstanceId":
            return Optional.ofNullable(clazz.cast(ec2InstanceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ComponentType", COMPONENT_TYPE_FIELD);
        map.put("Sid", SID_FIELD);
        map.put("Ec2InstanceId", EC2_INSTANCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentInfo, T> g) {
        return obj -> g.apply((ComponentInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentInfo> {
        /**
         * <p>
         * This string is the type of the component.
         * </p>
         * <p>
         * Accepted value is <code>WD</code>.
         * </p>
         * 
         * @param componentType
         *        This string is the type of the component.</p>
         *        <p>
         *        Accepted value is <code>WD</code>.
         * @see ComponentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComponentType
         */
        Builder componentType(String componentType);

        /**
         * <p>
         * This string is the type of the component.
         * </p>
         * <p>
         * Accepted value is <code>WD</code>.
         * </p>
         * 
         * @param componentType
         *        This string is the type of the component.</p>
         *        <p>
         *        Accepted value is <code>WD</code>.
         * @see ComponentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComponentType
         */
        Builder componentType(ComponentType componentType);

        /**
         * <p>
         * This string is the SAP System ID of the component.
         * </p>
         * <p>
         * Accepted values are alphanumeric.
         * </p>
         * 
         * @param sid
         *        This string is the SAP System ID of the component.</p>
         *        <p>
         *        Accepted values are alphanumeric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sid(String sid);

        /**
         * <p>
         * This is the Amazon EC2 instance on which your SAP component is running.
         * </p>
         * <p>
         * Accepted values are alphanumeric.
         * </p>
         * 
         * @param ec2InstanceId
         *        This is the Amazon EC2 instance on which your SAP component is running.</p>
         *        <p>
         *        Accepted values are alphanumeric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceId(String ec2InstanceId);
    }

    static final class BuilderImpl implements Builder {
        private String componentType;

        private String sid;

        private String ec2InstanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentInfo model) {
            componentType(model.componentType);
            sid(model.sid);
            ec2InstanceId(model.ec2InstanceId);
        }

        public final String getComponentType() {
            return componentType;
        }

        public final void setComponentType(String componentType) {
            this.componentType = componentType;
        }

        @Override
        public final Builder componentType(String componentType) {
            this.componentType = componentType;
            return this;
        }

        @Override
        public final Builder componentType(ComponentType componentType) {
            this.componentType(componentType == null ? null : componentType.toString());
            return this;
        }

        public final String getSid() {
            return sid;
        }

        public final void setSid(String sid) {
            this.sid = sid;
        }

        @Override
        public final Builder sid(String sid) {
            this.sid = sid;
            return this;
        }

        public final String getEc2InstanceId() {
            return ec2InstanceId;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        @Override
        public ComponentInfo build() {
            return new ComponentInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
