/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a configuration check operation that has been executed against an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationCheckOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationCheckOperation.Builder, ConfigurationCheckOperation> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ConfigurationCheckOperation::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(ConfigurationCheckOperation::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ConfigurationCheckOperation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(ConfigurationCheckOperation::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> CONFIGURATION_CHECK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationCheckId").getter(getter(ConfigurationCheckOperation::configurationCheckIdAsString))
            .setter(setter(Builder::configurationCheckId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationCheckId").build())
            .build();

    private static final SdkField<String> CONFIGURATION_CHECK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationCheckName").getter(getter(ConfigurationCheckOperation::configurationCheckName))
            .setter(setter(Builder::configurationCheckName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationCheckName").build())
            .build();

    private static final SdkField<String> CONFIGURATION_CHECK_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationCheckDescription")
            .getter(getter(ConfigurationCheckOperation::configurationCheckDescription))
            .setter(setter(Builder::configurationCheckDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationCheckDescription")
                    .build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ConfigurationCheckOperation::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ConfigurationCheckOperation::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<RuleStatusCounts> RULE_STATUS_COUNTS_FIELD = SdkField
            .<RuleStatusCounts> builder(MarshallingType.SDK_POJO).memberName("RuleStatusCounts")
            .getter(getter(ConfigurationCheckOperation::ruleStatusCounts)).setter(setter(Builder::ruleStatusCounts))
            .constructor(RuleStatusCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleStatusCounts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            APPLICATION_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CONFIGURATION_CHECK_ID_FIELD,
            CONFIGURATION_CHECK_NAME_FIELD, CONFIGURATION_CHECK_DESCRIPTION_FIELD, START_TIME_FIELD, END_TIME_FIELD,
            RULE_STATUS_COUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String applicationId;

    private final String status;

    private final String statusMessage;

    private final String configurationCheckId;

    private final String configurationCheckName;

    private final String configurationCheckDescription;

    private final Instant startTime;

    private final Instant endTime;

    private final RuleStatusCounts ruleStatusCounts;

    private ConfigurationCheckOperation(BuilderImpl builder) {
        this.id = builder.id;
        this.applicationId = builder.applicationId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.configurationCheckId = builder.configurationCheckId;
        this.configurationCheckName = builder.configurationCheckName;
        this.configurationCheckDescription = builder.configurationCheckDescription;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.ruleStatusCounts = builder.ruleStatusCounts;
    }

    /**
     * <p>
     * The unique identifier of the configuration check operation.
     * </p>
     * 
     * @return The unique identifier of the configuration check operation.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the application against which the configuration check was performed.
     * </p>
     * 
     * @return The ID of the application against which the configuration check was performed.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The current status of the configuration check operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the configuration check operation.
     * @see OperationStatus
     */
    public final OperationStatus status() {
        return OperationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the configuration check operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the configuration check operation.
     * @see OperationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A message providing additional details about the status of the configuration check operation.
     * </p>
     * 
     * @return A message providing additional details about the status of the configuration check operation.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The unique identifier of the configuration check that was performed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationCheckId} will return {@link ConfigurationCheckType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #configurationCheckIdAsString}.
     * </p>
     * 
     * @return The unique identifier of the configuration check that was performed.
     * @see ConfigurationCheckType
     */
    public final ConfigurationCheckType configurationCheckId() {
        return ConfigurationCheckType.fromValue(configurationCheckId);
    }

    /**
     * <p>
     * The unique identifier of the configuration check that was performed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationCheckId} will return {@link ConfigurationCheckType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #configurationCheckIdAsString}.
     * </p>
     * 
     * @return The unique identifier of the configuration check that was performed.
     * @see ConfigurationCheckType
     */
    public final String configurationCheckIdAsString() {
        return configurationCheckId;
    }

    /**
     * <p>
     * The name of the configuration check that was performed.
     * </p>
     * 
     * @return The name of the configuration check that was performed.
     */
    public final String configurationCheckName() {
        return configurationCheckName;
    }

    /**
     * <p>
     * A description of the configuration check that was performed.
     * </p>
     * 
     * @return A description of the configuration check that was performed.
     */
    public final String configurationCheckDescription() {
        return configurationCheckDescription;
    }

    /**
     * <p>
     * The time at which the configuration check operation started.
     * </p>
     * 
     * @return The time at which the configuration check operation started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time at which the configuration check operation completed.
     * </p>
     * 
     * @return The time at which the configuration check operation completed.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * A summary of all the rule results, showing counts for each status type.
     * </p>
     * 
     * @return A summary of all the rule results, showing counts for each status type.
     */
    public final RuleStatusCounts ruleStatusCounts() {
        return ruleStatusCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(configurationCheckIdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configurationCheckName());
        hashCode = 31 * hashCode + Objects.hashCode(configurationCheckDescription());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(ruleStatusCounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationCheckOperation)) {
            return false;
        }
        ConfigurationCheckOperation other = (ConfigurationCheckOperation) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(configurationCheckIdAsString(), other.configurationCheckIdAsString())
                && Objects.equals(configurationCheckName(), other.configurationCheckName())
                && Objects.equals(configurationCheckDescription(), other.configurationCheckDescription())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(ruleStatusCounts(), other.ruleStatusCounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationCheckOperation").add("Id", id()).add("ApplicationId", applicationId())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("ConfigurationCheckId", configurationCheckIdAsString())
                .add("ConfigurationCheckName", configurationCheckName())
                .add("ConfigurationCheckDescription", configurationCheckDescription()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("RuleStatusCounts", ruleStatusCounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "ConfigurationCheckId":
            return Optional.ofNullable(clazz.cast(configurationCheckIdAsString()));
        case "ConfigurationCheckName":
            return Optional.ofNullable(clazz.cast(configurationCheckName()));
        case "ConfigurationCheckDescription":
            return Optional.ofNullable(clazz.cast(configurationCheckDescription()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "RuleStatusCounts":
            return Optional.ofNullable(clazz.cast(ruleStatusCounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("ConfigurationCheckId", CONFIGURATION_CHECK_ID_FIELD);
        map.put("ConfigurationCheckName", CONFIGURATION_CHECK_NAME_FIELD);
        map.put("ConfigurationCheckDescription", CONFIGURATION_CHECK_DESCRIPTION_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("RuleStatusCounts", RULE_STATUS_COUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationCheckOperation, T> g) {
        return obj -> g.apply((ConfigurationCheckOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationCheckOperation> {
        /**
         * <p>
         * The unique identifier of the configuration check operation.
         * </p>
         * 
         * @param id
         *        The unique identifier of the configuration check operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the application against which the configuration check was performed.
         * </p>
         * 
         * @param applicationId
         *        The ID of the application against which the configuration check was performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The current status of the configuration check operation.
         * </p>
         * 
         * @param status
         *        The current status of the configuration check operation.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the configuration check operation.
         * </p>
         * 
         * @param status
         *        The current status of the configuration check operation.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(OperationStatus status);

        /**
         * <p>
         * A message providing additional details about the status of the configuration check operation.
         * </p>
         * 
         * @param statusMessage
         *        A message providing additional details about the status of the configuration check operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The unique identifier of the configuration check that was performed.
         * </p>
         * 
         * @param configurationCheckId
         *        The unique identifier of the configuration check that was performed.
         * @see ConfigurationCheckType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationCheckType
         */
        Builder configurationCheckId(String configurationCheckId);

        /**
         * <p>
         * The unique identifier of the configuration check that was performed.
         * </p>
         * 
         * @param configurationCheckId
         *        The unique identifier of the configuration check that was performed.
         * @see ConfigurationCheckType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationCheckType
         */
        Builder configurationCheckId(ConfigurationCheckType configurationCheckId);

        /**
         * <p>
         * The name of the configuration check that was performed.
         * </p>
         * 
         * @param configurationCheckName
         *        The name of the configuration check that was performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationCheckName(String configurationCheckName);

        /**
         * <p>
         * A description of the configuration check that was performed.
         * </p>
         * 
         * @param configurationCheckDescription
         *        A description of the configuration check that was performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationCheckDescription(String configurationCheckDescription);

        /**
         * <p>
         * The time at which the configuration check operation started.
         * </p>
         * 
         * @param startTime
         *        The time at which the configuration check operation started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time at which the configuration check operation completed.
         * </p>
         * 
         * @param endTime
         *        The time at which the configuration check operation completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * A summary of all the rule results, showing counts for each status type.
         * </p>
         * 
         * @param ruleStatusCounts
         *        A summary of all the rule results, showing counts for each status type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleStatusCounts(RuleStatusCounts ruleStatusCounts);

        /**
         * <p>
         * A summary of all the rule results, showing counts for each status type.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleStatusCounts.Builder} avoiding the
         * need to create one manually via {@link RuleStatusCounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleStatusCounts.Builder#build()} is called immediately and its
         * result is passed to {@link #ruleStatusCounts(RuleStatusCounts)}.
         * 
         * @param ruleStatusCounts
         *        a consumer that will call methods on {@link RuleStatusCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleStatusCounts(RuleStatusCounts)
         */
        default Builder ruleStatusCounts(Consumer<RuleStatusCounts.Builder> ruleStatusCounts) {
            return ruleStatusCounts(RuleStatusCounts.builder().applyMutation(ruleStatusCounts).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String applicationId;

        private String status;

        private String statusMessage;

        private String configurationCheckId;

        private String configurationCheckName;

        private String configurationCheckDescription;

        private Instant startTime;

        private Instant endTime;

        private RuleStatusCounts ruleStatusCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationCheckOperation model) {
            id(model.id);
            applicationId(model.applicationId);
            status(model.status);
            statusMessage(model.statusMessage);
            configurationCheckId(model.configurationCheckId);
            configurationCheckName(model.configurationCheckName);
            configurationCheckDescription(model.configurationCheckDescription);
            startTime(model.startTime);
            endTime(model.endTime);
            ruleStatusCounts(model.ruleStatusCounts);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getConfigurationCheckId() {
            return configurationCheckId;
        }

        public final void setConfigurationCheckId(String configurationCheckId) {
            this.configurationCheckId = configurationCheckId;
        }

        @Override
        public final Builder configurationCheckId(String configurationCheckId) {
            this.configurationCheckId = configurationCheckId;
            return this;
        }

        @Override
        public final Builder configurationCheckId(ConfigurationCheckType configurationCheckId) {
            this.configurationCheckId(configurationCheckId == null ? null : configurationCheckId.toString());
            return this;
        }

        public final String getConfigurationCheckName() {
            return configurationCheckName;
        }

        public final void setConfigurationCheckName(String configurationCheckName) {
            this.configurationCheckName = configurationCheckName;
        }

        @Override
        public final Builder configurationCheckName(String configurationCheckName) {
            this.configurationCheckName = configurationCheckName;
            return this;
        }

        public final String getConfigurationCheckDescription() {
            return configurationCheckDescription;
        }

        public final void setConfigurationCheckDescription(String configurationCheckDescription) {
            this.configurationCheckDescription = configurationCheckDescription;
        }

        @Override
        public final Builder configurationCheckDescription(String configurationCheckDescription) {
            this.configurationCheckDescription = configurationCheckDescription;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final RuleStatusCounts.Builder getRuleStatusCounts() {
            return ruleStatusCounts != null ? ruleStatusCounts.toBuilder() : null;
        }

        public final void setRuleStatusCounts(RuleStatusCounts.BuilderImpl ruleStatusCounts) {
            this.ruleStatusCounts = ruleStatusCounts != null ? ruleStatusCounts.build() : null;
        }

        @Override
        public final Builder ruleStatusCounts(RuleStatusCounts ruleStatusCounts) {
            this.ruleStatusCounts = ruleStatusCounts;
            return this;
        }

        @Override
        public ConfigurationCheckOperation build() {
            return new ConfigurationCheckOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
