/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConfigurationCheckDefinitionsResponse extends SsmSapResponse implements
        ToCopyableBuilder<ListConfigurationCheckDefinitionsResponse.Builder, ListConfigurationCheckDefinitionsResponse> {
    private static final SdkField<List<ConfigurationCheckDefinition>> CONFIGURATION_CHECKS_FIELD = SdkField
            .<List<ConfigurationCheckDefinition>> builder(MarshallingType.LIST)
            .memberName("ConfigurationChecks")
            .getter(getter(ListConfigurationCheckDefinitionsResponse::configurationChecks))
            .setter(setter(Builder::configurationChecks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationChecks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationCheckDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationCheckDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListConfigurationCheckDefinitionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_CHECKS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ConfigurationCheckDefinition> configurationChecks;

    private final String nextToken;

    private ListConfigurationCheckDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationChecks = builder.configurationChecks;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfigurationChecks property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConfigurationChecks() {
        return configurationChecks != null && !(configurationChecks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration check types supported by AWS Systems Manager for SAP.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurationChecks} method.
     * </p>
     * 
     * @return The configuration check types supported by AWS Systems Manager for SAP.
     */
    public final List<ConfigurationCheckDefinition> configurationChecks() {
        return configurationChecks;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is null when there are no more results
     *         to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurationChecks() ? configurationChecks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationCheckDefinitionsResponse)) {
            return false;
        }
        ListConfigurationCheckDefinitionsResponse other = (ListConfigurationCheckDefinitionsResponse) obj;
        return hasConfigurationChecks() == other.hasConfigurationChecks()
                && Objects.equals(configurationChecks(), other.configurationChecks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConfigurationCheckDefinitionsResponse")
                .add("ConfigurationChecks", hasConfigurationChecks() ? configurationChecks() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationChecks":
            return Optional.ofNullable(clazz.cast(configurationChecks()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationChecks", CONFIGURATION_CHECKS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationCheckDefinitionsResponse, T> g) {
        return obj -> g.apply((ListConfigurationCheckDefinitionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsmSapResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListConfigurationCheckDefinitionsResponse> {
        /**
         * <p>
         * The configuration check types supported by AWS Systems Manager for SAP.
         * </p>
         * 
         * @param configurationChecks
         *        The configuration check types supported by AWS Systems Manager for SAP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationChecks(Collection<ConfigurationCheckDefinition> configurationChecks);

        /**
         * <p>
         * The configuration check types supported by AWS Systems Manager for SAP.
         * </p>
         * 
         * @param configurationChecks
         *        The configuration check types supported by AWS Systems Manager for SAP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationChecks(ConfigurationCheckDefinition... configurationChecks);

        /**
         * <p>
         * The configuration check types supported by AWS Systems Manager for SAP.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmsap.model.ConfigurationCheckDefinition.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.ssmsap.model.ConfigurationCheckDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmsap.model.ConfigurationCheckDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #configurationChecks(List<ConfigurationCheckDefinition>)}.
         * 
         * @param configurationChecks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmsap.model.ConfigurationCheckDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationChecks(java.util.Collection<ConfigurationCheckDefinition>)
         */
        Builder configurationChecks(Consumer<ConfigurationCheckDefinition.Builder>... configurationChecks);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is null when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmSapResponse.BuilderImpl implements Builder {
        private List<ConfigurationCheckDefinition> configurationChecks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationCheckDefinitionsResponse model) {
            super(model);
            configurationChecks(model.configurationChecks);
            nextToken(model.nextToken);
        }

        public final List<ConfigurationCheckDefinition.Builder> getConfigurationChecks() {
            List<ConfigurationCheckDefinition.Builder> result = ConfigurationCheckDefinitionListCopier
                    .copyToBuilder(this.configurationChecks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationChecks(Collection<ConfigurationCheckDefinition.BuilderImpl> configurationChecks) {
            this.configurationChecks = ConfigurationCheckDefinitionListCopier.copyFromBuilder(configurationChecks);
        }

        @Override
        public final Builder configurationChecks(Collection<ConfigurationCheckDefinition> configurationChecks) {
            this.configurationChecks = ConfigurationCheckDefinitionListCopier.copy(configurationChecks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationChecks(ConfigurationCheckDefinition... configurationChecks) {
            configurationChecks(Arrays.asList(configurationChecks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationChecks(Consumer<ConfigurationCheckDefinition.Builder>... configurationChecks) {
            configurationChecks(Stream.of(configurationChecks)
                    .map(c -> ConfigurationCheckDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConfigurationCheckDefinitionsResponse build() {
            return new ListConfigurationCheckDefinitionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
