/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sso.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccountsResponse extends SsoResponse implements
        ToCopyableBuilder<ListAccountsResponse.Builder, ListAccountsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAccountsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<AccountInfo>> ACCOUNT_LIST_FIELD = SdkField
            .<List<AccountInfo>> builder(MarshallingType.LIST)
            .getter(getter(ListAccountsResponse::accountList))
            .setter(setter(Builder::accountList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            ACCOUNT_LIST_FIELD));

    private final String nextToken;

    private final List<AccountInfo> accountList;

    private ListAccountsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.accountList = builder.accountList;
    }

    /**
     * <p>
     * The page token client that is used to retrieve the list of accounts.
     * </p>
     * 
     * @return The page token client that is used to retrieve the list of accounts.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the AccountList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAccountList() {
        return accountList != null && !(accountList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A paginated response with the list of account information and the next token if more results are available.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccountList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A paginated response with the list of account information and the next token if more results are
     *         available.
     */
    public List<AccountInfo> accountList() {
        return accountList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(accountList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountsResponse)) {
            return false;
        }
        ListAccountsResponse other = (ListAccountsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(accountList(), other.accountList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListAccountsResponse").add("NextToken", nextToken()).add("AccountList", accountList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "accountList":
            return Optional.ofNullable(clazz.cast(accountList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccountsResponse, T> g) {
        return obj -> g.apply((ListAccountsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAccountsResponse> {
        /**
         * <p>
         * The page token client that is used to retrieve the list of accounts.
         * </p>
         * 
         * @param nextToken
         *        The page token client that is used to retrieve the list of accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A paginated response with the list of account information and the next token if more results are available.
         * </p>
         * 
         * @param accountList
         *        A paginated response with the list of account information and the next token if more results are
         *        available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountList(Collection<AccountInfo> accountList);

        /**
         * <p>
         * A paginated response with the list of account information and the next token if more results are available.
         * </p>
         * 
         * @param accountList
         *        A paginated response with the list of account information and the next token if more results are
         *        available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountList(AccountInfo... accountList);

        /**
         * <p>
         * A paginated response with the list of account information and the next token if more results are available.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AccountInfo>.Builder} avoiding the need to
         * create one manually via {@link List<AccountInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccountInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #accountList(List<AccountInfo>)}.
         * 
         * @param accountList
         *        a consumer that will call methods on {@link List<AccountInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountList(List<AccountInfo>)
         */
        Builder accountList(Consumer<AccountInfo.Builder>... accountList);
    }

    static final class BuilderImpl extends SsoResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<AccountInfo> accountList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountsResponse model) {
            super(model);
            nextToken(model.nextToken);
            accountList(model.accountList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<AccountInfo.Builder> getAccountList() {
            return accountList != null ? accountList.stream().map(AccountInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accountList(Collection<AccountInfo> accountList) {
            this.accountList = AccountListTypeCopier.copy(accountList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountList(AccountInfo... accountList) {
            accountList(Arrays.asList(accountList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountList(Consumer<AccountInfo.Builder>... accountList) {
            accountList(Stream.of(accountList).map(c -> AccountInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAccountList(Collection<AccountInfo.BuilderImpl> accountList) {
            this.accountList = AccountListTypeCopier.copyFromBuilder(accountList);
        }

        @Override
        public ListAccountsResponse build() {
            return new ListAccountsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
