/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sso;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sso.DefaultSsoBaseClientBuilder;
import software.amazon.awssdk.services.sso.DefaultSsoClient;
import software.amazon.awssdk.services.sso.SsoClient;
import software.amazon.awssdk.services.sso.SsoClientBuilder;
import software.amazon.awssdk.services.sso.SsoServiceClientConfiguration;
import software.amazon.awssdk.services.sso.endpoints.SsoEndpointProvider;

@SdkInternalApi
final class DefaultSsoClientBuilder
extends DefaultSsoBaseClientBuilder<SsoClientBuilder, SsoClient>
implements SsoClientBuilder {
    DefaultSsoClientBuilder() {
    }

    @Override
    public DefaultSsoClientBuilder endpointProvider(SsoEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SsoClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSsoClientBuilder.validateClientOptions(clientConfiguration);
        SsoServiceClientConfiguration serviceClientConfiguration = SsoServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultSsoClient(serviceClientConfiguration, clientConfiguration);
    }
}

