/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sso.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRoleCredentialsResponse extends SsoResponse implements
        ToCopyableBuilder<GetRoleCredentialsResponse.Builder, GetRoleCredentialsResponse> {
    private static final SdkField<RoleCredentials> ROLE_CREDENTIALS_FIELD = SdkField
            .<RoleCredentials> builder(MarshallingType.SDK_POJO).memberName("roleCredentials")
            .getter(getter(GetRoleCredentialsResponse::roleCredentials)).setter(setter(Builder::roleCredentials))
            .constructor(RoleCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleCredentials").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_CREDENTIALS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("roleCredentials", ROLE_CREDENTIALS_FIELD);
                }
            });

    private final RoleCredentials roleCredentials;

    private GetRoleCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.roleCredentials = builder.roleCredentials;
    }

    /**
     * <p>
     * The credentials for the role that is assigned to the user.
     * </p>
     * 
     * @return The credentials for the role that is assigned to the user.
     */
    public final RoleCredentials roleCredentials() {
        return roleCredentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(roleCredentials());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRoleCredentialsResponse)) {
            return false;
        }
        GetRoleCredentialsResponse other = (GetRoleCredentialsResponse) obj;
        return Objects.equals(roleCredentials(), other.roleCredentials());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRoleCredentialsResponse").add("RoleCredentials", roleCredentials()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleCredentials":
            return Optional.ofNullable(clazz.cast(roleCredentials()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetRoleCredentialsResponse, T> g) {
        return obj -> g.apply((GetRoleCredentialsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRoleCredentialsResponse> {
        /**
         * <p>
         * The credentials for the role that is assigned to the user.
         * </p>
         * 
         * @param roleCredentials
         *        The credentials for the role that is assigned to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleCredentials(RoleCredentials roleCredentials);

        /**
         * <p>
         * The credentials for the role that is assigned to the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoleCredentials.Builder} avoiding the
         * need to create one manually via {@link RoleCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoleCredentials.Builder#build()} is called immediately and its
         * result is passed to {@link #roleCredentials(RoleCredentials)}.
         * 
         * @param roleCredentials
         *        a consumer that will call methods on {@link RoleCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roleCredentials(RoleCredentials)
         */
        default Builder roleCredentials(Consumer<RoleCredentials.Builder> roleCredentials) {
            return roleCredentials(RoleCredentials.builder().applyMutation(roleCredentials).build());
        }
    }

    static final class BuilderImpl extends SsoResponse.BuilderImpl implements Builder {
        private RoleCredentials roleCredentials;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRoleCredentialsResponse model) {
            super(model);
            roleCredentials(model.roleCredentials);
        }

        public final RoleCredentials.Builder getRoleCredentials() {
            return roleCredentials != null ? roleCredentials.toBuilder() : null;
        }

        public final void setRoleCredentials(RoleCredentials.BuilderImpl roleCredentials) {
            this.roleCredentials = roleCredentials != null ? roleCredentials.build() : null;
        }

        @Override
        public final Builder roleCredentials(RoleCredentials roleCredentials) {
            this.roleCredentials = roleCredentials;
            return this;
        }

        @Override
        public GetRoleCredentialsResponse build() {
            return new GetRoleCredentialsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
