/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePermissionSetProvisioningStatusResponse extends SsoAdminResponse
        implements
        ToCopyableBuilder<DescribePermissionSetProvisioningStatusResponse.Builder, DescribePermissionSetProvisioningStatusResponse> {
    private static final SdkField<PermissionSetProvisioningStatus> PERMISSION_SET_PROVISIONING_STATUS_FIELD = SdkField
            .<PermissionSetProvisioningStatus> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribePermissionSetProvisioningStatusResponse::permissionSetProvisioningStatus))
            .setter(setter(Builder::permissionSetProvisioningStatus))
            .constructor(PermissionSetProvisioningStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionSetProvisioningStatus")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PERMISSION_SET_PROVISIONING_STATUS_FIELD));

    private final PermissionSetProvisioningStatus permissionSetProvisioningStatus;

    private DescribePermissionSetProvisioningStatusResponse(BuilderImpl builder) {
        super(builder);
        this.permissionSetProvisioningStatus = builder.permissionSetProvisioningStatus;
    }

    /**
     * <p>
     * The status object for the permission set provisioning operation.
     * </p>
     * 
     * @return The status object for the permission set provisioning operation.
     */
    public PermissionSetProvisioningStatus permissionSetProvisioningStatus() {
        return permissionSetProvisioningStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(permissionSetProvisioningStatus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePermissionSetProvisioningStatusResponse)) {
            return false;
        }
        DescribePermissionSetProvisioningStatusResponse other = (DescribePermissionSetProvisioningStatusResponse) obj;
        return Objects.equals(permissionSetProvisioningStatus(), other.permissionSetProvisioningStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribePermissionSetProvisioningStatusResponse")
                .add("PermissionSetProvisioningStatus", permissionSetProvisioningStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PermissionSetProvisioningStatus":
            return Optional.ofNullable(clazz.cast(permissionSetProvisioningStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePermissionSetProvisioningStatusResponse, T> g) {
        return obj -> g.apply((DescribePermissionSetProvisioningStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribePermissionSetProvisioningStatusResponse> {
        /**
         * <p>
         * The status object for the permission set provisioning operation.
         * </p>
         * 
         * @param permissionSetProvisioningStatus
         *        The status object for the permission set provisioning operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionSetProvisioningStatus(PermissionSetProvisioningStatus permissionSetProvisioningStatus);

        /**
         * <p>
         * The status object for the permission set provisioning operation.
         * </p>
         * This is a convenience that creates an instance of the {@link PermissionSetProvisioningStatus.Builder}
         * avoiding the need to create one manually via {@link PermissionSetProvisioningStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link PermissionSetProvisioningStatus.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #permissionSetProvisioningStatus(PermissionSetProvisioningStatus)}.
         * 
         * @param permissionSetProvisioningStatus
         *        a consumer that will call methods on {@link PermissionSetProvisioningStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissionSetProvisioningStatus(PermissionSetProvisioningStatus)
         */
        default Builder permissionSetProvisioningStatus(
                Consumer<PermissionSetProvisioningStatus.Builder> permissionSetProvisioningStatus) {
            return permissionSetProvisioningStatus(PermissionSetProvisioningStatus.builder()
                    .applyMutation(permissionSetProvisioningStatus).build());
        }
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private PermissionSetProvisioningStatus permissionSetProvisioningStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePermissionSetProvisioningStatusResponse model) {
            super(model);
            permissionSetProvisioningStatus(model.permissionSetProvisioningStatus);
        }

        public final PermissionSetProvisioningStatus.Builder getPermissionSetProvisioningStatus() {
            return permissionSetProvisioningStatus != null ? permissionSetProvisioningStatus.toBuilder() : null;
        }

        @Override
        public final Builder permissionSetProvisioningStatus(PermissionSetProvisioningStatus permissionSetProvisioningStatus) {
            this.permissionSetProvisioningStatus = permissionSetProvisioningStatus;
            return this;
        }

        public final void setPermissionSetProvisioningStatus(
                PermissionSetProvisioningStatus.BuilderImpl permissionSetProvisioningStatus) {
            this.permissionSetProvisioningStatus = permissionSetProvisioningStatus != null ? permissionSetProvisioningStatus
                    .build() : null;
        }

        @Override
        public DescribePermissionSetProvisioningStatusResponse build() {
            return new DescribePermissionSetProvisioningStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
